/*
+-------------------------------------------------------------------+
| PROJECT: GSM-BT  (8445)            $Workfile:: Bti.h             $|
| $Author:: Mg                       $$Revision:: 26               $|
| CREATED: 06 April 2000             $Modtime:: 15.03.00 16:01     $|
+-------------------------------------------------------------------+

   MODULE  : BTI

   PURPOSE : Global definitions for the Bluetooth Interface,
             which are visible to both sides

   $Log:: /GSM/Condat/MS/SRC/BTI/Bti.h                             $
 *

*/


#ifndef BTI_H
#define BTI_H



/*
 * Conditional Compiling
 */

/*
 * Constants
 */

/* These are the addresses for the headset and the dial-up devices*/

#define HS_BD_ADDR_BYTE_0 0xbb; /*mvi@140900*/
#define HS_BD_ADDR_BYTE_1 0xbb;
#define HS_BD_ADDR_BYTE_2 0xbb;
#define HS_BD_ADDR_BYTE_3 0xbb;
#define HS_BD_ADDR_BYTE_4 0xbb;
#define HS_BD_ADDR_BYTE_5 0xbb;

#define DU_BD_ADDR_BYTE_0 0xcc; /*mvi@140900*/
#define DU_BD_ADDR_BYTE_1 0xcc;
#define DU_BD_ADDR_BYTE_2 0xcc;
#define DU_BD_ADDR_BYTE_3 0xcc;
#define DU_BD_ADDR_BYTE_4 0xcc;
#define DU_BD_ADDR_BYTE_5 0xcc;


typedef unsigned char   T_BTI_DEVICE_TYPE;
typedef unsigned short	T_BTI_SEARCH_TIME;
typedef unsigned short	T_BTI_SEARCH_BREAK;
typedef unsigned short	T_BTI_SCAN_TIME;
typedef unsigned short	T_BTI_SCAN_BREAK;
typedef unsigned char	T_BTI_SECURITY_MODE;
typedef unsigned char	T_BTI_ATTEMPTS;
typedef unsigned char	T_BTI_MAX_RING;
typedef unsigned char   T_BTI_BONDING_MODE;
typedef unsigned char   T_BTI_PARK_MODE;

typedef struct
{
	T_BTI_SEARCH_TIME	search_time;
	T_BTI_SEARCH_BREAK	search_break;
	T_BTI_SCAN_TIME		scan_time;
	T_BTI_SCAN_BREAK	scan_break;
	T_BTI_SECURITY_MODE	security_mode;
	T_BTI_ATTEMPTS		connect_attempts;
	T_BTI_MAX_RING		max_ring;
	T_BTI_PARK_MODE		park_mode;
	T_BTI_BONDING_MODE	bonding;
}T_BTI_CONFIG;

typedef unsigned char   T_BTI_RESULT;


typedef unsigned char	T_BTI_BD_ADDR;
typedef unsigned char	T_BTI_BD_NAME;
typedef unsigned char	T_BTI_PIN;

typedef unsigned char   T_BTI_ERROR_CAUSE;

typedef unsigned char   T_BTI_AUDIO_STATE;

typedef unsigned char   T_BTI_REQ_ID;

typedef unsigned char   T_BTI_RES_ID;

typedef unsigned char   T_BTI_CNF_ID;

typedef unsigned char   T_BTI_IND_ID;


#endif
