#
#       Makefile for the Test of Audio Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Mazard Francois
#       Date : 12 July 2001

# Compilation flags
AUDIO_TEST_FLAGS     := $(NODBG) $(16INST) -mn $(CFLAGSSERVICES_TESTS) -i$(SERVICES_DIR)/audio
WIN_AUDIO_TEST_FLAGS := $($(TP)CFLAGS) $(CFLAGSSERVICES_TESTS) /I $(SERVICES_DIR)/audio

# Libraries definition
LIB_AUDIO_TEST := $(OUT_LIB_DIR)/audio_tests.lib
CFG_LIBS       += $(LIB_AUDIO_TEST)

# Source definition
COMMON_SRC_AUDIO_TEST := $(SERVICES_DIR)/audio/tests/audio_test.c \
                         $(SERVICES_DIR)/audio/tests/audio_test_regr.c \
                         $(SERVICES_DIR)/audio/tests/audio_test_misc.c
SRC_AUDIO_TEST        := $(COMMON_SRC_AUDIO_TEST)
WIN_SRC_AUDIO_TEST    := $(COMMON_SRC_AUDIO_TEST)

# Objects and dependencies definition
OBJ_AUDIO_TEST := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_AUDIO_TEST)))
CFG_OBJS += $(OBJ_AUDIO_TEST)
CFG_DEPS += $(OBJ_AUDIO_TEST:.obj=.d)


######## LIBRARIES #############
$(LIB_AUDIO_TEST) : $(OBJ_AUDIO_TEST)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_AUDIO_TEST) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)AUDIO_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

