/********************************************************************************/
/*                                                                              */
/*  File Name:  audio_test_regr.h                                               */
/*                                                                              */
/*  Purpose:  This file contains the definition usefull for an audio            */
/*            non regression test.                                              */
/*                                                                              */
/*  Note:   None.                                                               */
/*                                                                              */
/*  Version   0.1                                                               */
/*                                                                              */
/*  Date        Modification                                                    */
/*  ----------------------------------------------------------------------------*/
/*  14 May 2001  Create                                                         */
/*                                                                              */
/*  Author      Francois Mazard - Stephanie Gerthoux                            */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved    */
/********************************************************************************/

#ifndef _AUDIO_TEST_REGR_H_
  #define _AUDIO_TEST_REGR_H_

#include "tests/rv/rv_test_regr.h"
#include "audio/audio_features_i.h"

  #if (AUDIO_REGR == SW_COMPILED)

    /* Define paramters, functions and macros used tto ferform miscellaneous AUDIO tests */
 /* declare the external functions */

  #if (KEYBEEP)
    T_RV_REGR_RET audio_regr_test_1 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_2 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_3 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_4 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_5 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_6 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_7 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_8 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* KEYBEEP */
  #if (TONE)
    T_RV_REGR_RET audio_regr_test_10 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_11 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_12 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_13 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_14 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_15 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_16 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_17 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* TONE */
  #if (MELODY_E1)
    T_RV_REGR_RET audio_regr_test_18 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_20 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_21 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_22 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_23 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_24 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_25 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_26 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_27 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_28 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_29 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_39 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* MELODY_E1 */
  #if (VOICE_MEMO)
    T_RV_REGR_RET audio_regr_test_30 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_31 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_32 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_33 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_34 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_35 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_36 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_37 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_38 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_59 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_40 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_41 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_42 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_43 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_44 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_45 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_46 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_47 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_48 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_69 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* VOICE_MEMO */
    /* AUDIO mode */
    T_RV_REGR_RET audio_regr_test_50 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_51 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_52 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_53 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_54 (T_RV_REGR_ERR_TYPE *error_type);
    /* Audio incompatibilities */
  #if (TONE) && (MELODY_E1)
    T_RV_REGR_RET audio_regr_test_60 (T_RV_REGR_ERR_TYPE *error_type);
  #endif
  #if (SPEECH_RECO) && (KEYBEEP)
    T_RV_REGR_RET audio_regr_test_61 (T_RV_REGR_ERR_TYPE *error_type);
  #endif
  #if (SPEECH_RECO)
    /* enrollment */
    T_RV_REGR_RET audio_regr_test_70 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_71 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_72 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_73 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_74 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_75 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_76 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_77 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_78 (T_RV_REGR_ERR_TYPE *error_type);
    /* update */
    T_RV_REGR_RET audio_regr_test_80 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_81 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_82 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_83 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_84 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_85 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_86 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_87 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_88 (T_RV_REGR_ERR_TYPE *error_type);
    /* update-check */
    T_RV_REGR_RET audio_regr_test_90 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_91 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_92 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_93 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_94 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_95 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_96 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_97 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_98 (T_RV_REGR_ERR_TYPE *error_type);
    /* reco */
    T_RV_REGR_RET audio_regr_test_100 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_101 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_102 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_103 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_104 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_105 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_106 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_107 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* SPEECH_RECO */
  #if (MELODY_E2)
    T_RV_REGR_RET audio_regr_test_110 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_111 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_112 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_113 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_114 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_115 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_116 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_117 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_118 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_119 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_120 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_121 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_122 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* MELODY_E2 */
  #if (L1_GTT == 1)
    T_RV_REGR_RET audio_regr_test_130 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_131 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_132 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_133 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_134 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_135 (T_RV_REGR_ERR_TYPE *error_type);
  #endif /* L1_GTT */
  #if (AUDIO_MEM_MANAGER)
    T_RV_REGR_RET audio_regr_test_140 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_141 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_142 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_143 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_144 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_145 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_146 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_147 (T_RV_REGR_ERR_TYPE *error_type);

    T_RV_REGR_RET audio_regr_test_150 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_151 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_152 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_153 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_154 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_155 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_156 (T_RV_REGR_ERR_TYPE *error_type);
  #endif
  #if (L1_MIDI==1)
    T_RV_REGR_RET audio_regr_test_160 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_161 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_162 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_163 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_164 (T_RV_REGR_ERR_TYPE *error_type);
    T_RV_REGR_RET audio_regr_test_165 (T_RV_REGR_ERR_TYPE *error_type);
  #endif

  T_RV_RET trace_audio_test_verdict ( T_RV_TEST_RET  test_verdict,
                                             T_RV_REGR_TEST_TOT nb_of_test_in_list,
                                             T_RV_REGR_TEST_TOT nb_of_test_succeeded,
                                             T_RV_REGR_ERR_TYPE *error_type);


  #endif /* #if (AUDIO_REGR == SW_COMPILED) */
#endif
