/********************************************************************************/
/*                                                                              */
/*  File Name:  audio_test_misc.c                                               */
/*                                                                              */
/*  Purpose:  This file gathers misc tests for AUDIO.				                    */
/*                                                                              */
/*  Note:   None.                                                               */
/*                                                                              */
/*  Version   0.1                                                               */
/*                                                                              */
/*  Date        Modification                                                    */
/*  ----------------------------------------------------------------------------*/
/*  11 July 2001  Create                                                        */
/*                                                                              */
/*  Author      Francois Mazard - Stephanie Gerthoux                            */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved    */
/********************************************************************************/

/********************************************************************************/
/*                                                                              */
/*  Include files used for Audio riviera testing.                               */
/*                                                                              */
/********************************************************************************/

#include "rvf/rvf_api.h"
#include "tests/rv/rv_test_filter.h"

#if (AUDIO_MISC == SW_COMPILED)
  #ifndef _WINDOWS
    #include "config/swconfig.cfg"
    #include "config/sys.cfg"
    #include "config/chipset.cfg"
  #endif

  #include "l1_confg.h"
  #include "rv/rv_general.h"
  #include "rvm/rvm_gen.h"
  #include "audio/tests/audio_test_regr.h"
  #include "audio/tests/audio_test_misc.h"
  #include "audio/audio_ffs_i.h"
  #include "audio/audio_api.h"
  #include "audio/audio_structs_i.h"
  #include "audio/audio_var_i.h"
  #include "audio/audio_messages_i.h"
  #include "rvf/rvf_target.h"
  #include "audio/audio_const_i.h"
  #include "audio/audio_error_hdlr_i.h"
  #ifdef _WINDOWS
    /* include the usefull L1 header */
    #define BOOL_FLAG
    #include "l1_types.h"
    #include "l1audio_const.h"
    #include "l1audio_cust.h"
    #include "l1audio_defty.h"
    #include "l1audio_msgty.h"
    #include "l1audio_signa.h"
    #include "l1_const.h"
    #include "l1_defty.h"
    #include "l1_msgty.h"
    #include "l1_signa.h"
    #include "l1_varex.h"
  #endif
  #include "audio/tests/audio_test.h"




  /********************************************************************************/
  /*                                                                              */
  /*    Function Name:   audio_test_misc                                          */
  /*                                                                              */
  /*    Purpose:  This function executes the AUDIO misc tests.                    */
  /*                                                                              */
  /*    Input Parameters:                                                         */
  /*        test number.                                                          */
  /*                                                                              */
  /*    Output Parameters:                                                        */
  /*        None.                                                                 */
  /*                                                                              */
  /*    Note:                                                                     */
  /*        None.                                                                 */
  /*                                                                              */
  /*    Revision History:                                                         */
  /*        11 July 2001   Stephanie Gerthoux: Creation.                          */
  /*                                                                              */
  /********************************************************************************/

  T_RV_MISC_RET audio_test_misc (T_RV_MISC_TEST_NBR test_number)
  {

    T_RV_MISC_ERR_TYPE  error_type        = NO_ERR;
    T_RV_MISC_RET       test_verdict      = TEST_PASSED;


    /************************* Start audio_test_misc function *************************/

    RV_TEST_TRACE_HIGH ("**************** START AUDIO MISC ****************");

    /************************************************************************/
    /*                                                                      */
    /*  Memory dump -> check memory used before testing.                    */
    /*  Task   dump -> check task stack used before testing.                */
    /*                                                                      */
    /************************************************************************/
    rvf_dump_mem ();
    rvf_dump_tasks();

   switch(test_number)
      {
        #if (KEYBEEP)
          case 1:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 1: KB+auto stop");
            test_verdict = audio_regr_test_1 (&error_type);
            break;
          }
          case 2:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 2: KB+requested stop");
            test_verdict = audio_regr_test_2 (&error_type);
            break;
          }
          case 3:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 3: KB+requested stop before KB start");
            test_verdict = audio_regr_test_3 (&error_type);
            break;
          }
          case 4:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 4: KB+2 start");
            test_verdict = audio_regr_test_4 (&error_type);
            break;
          }
          case 5:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 5: KB+2 stop");
            test_verdict = audio_regr_test_5 (&error_type);
            break;
          }
          case 6:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 6: KB+check error in parameters");
            test_verdict = audio_regr_test_6 (&error_type);
            break;
          }
          case 7:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 7: KB+stop after a L1 stop");
            test_verdict = audio_regr_test_7 (&error_type);
            break;
          }
          case 8:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 8: KB+callback func");
            test_verdict = audio_regr_test_8 (&error_type);
            break;
          }
        #endif
        #if (TONE)
          case 10:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 10: TONE+auto stop");
              test_verdict = audio_regr_test_10 (&error_type);
              break;
          }
          case 11:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 11: TONE+resquested stop");
              test_verdict = audio_regr_test_11 (&error_type);
              break;
          }
          case 12:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 12: TONE+resquested stop before TONE start");
              test_verdict = audio_regr_test_12 (&error_type);
              break;
          }
          case 13:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 13: TONE+2 start");
              test_verdict = audio_regr_test_13 (&error_type);
              break;
          }
          case 14:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 14: TONE+2 stop");
              test_verdict = audio_regr_test_14 (&error_type);
              break;
          }
          case 15:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 15: TONE+Check parameters");
              test_verdict = audio_regr_test_15 (&error_type);
              break;
          }
          case 16:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 16: TONE+requested stop after L1 stop");
              test_verdict = audio_regr_test_16 (&error_type);
              break;
          }
          case 17:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 17: TONE+callback func");
              test_verdict = audio_regr_test_17 (&error_type);
              break;
          }
        #endif
        #if (MELODY_E1)
          case 18:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 18: MELODY E1+Check parameters");
              test_verdict = audio_regr_test_18 (&error_type);
              break;
          }

          case 20:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 20:MELODY_E1+auto stop");
              test_verdict = audio_regr_test_20 (&error_type);
              break;
          }
          case 21:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 21: MELODY_E1+resquested stop");
              test_verdict = audio_regr_test_21 (&error_type);
              break;
          }
          case 22:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 22: MELODY_E1+resquested stop before L1 start");
              test_verdict = audio_regr_test_22 (&error_type);
              break;
          }
          case 23:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 23: MELODY_E1+resquested stop before FFS initialization");
              test_verdict = audio_regr_test_23 (&error_type);
              break;
          }
          case 24:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 24: MELODY_E1+2 start");
              test_verdict = audio_regr_test_24 (&error_type);
              break;
          }
          case 25:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 25: MELODY_E1+2 stop");
              test_verdict = audio_regr_test_25 (&error_type);
              break;
          }
          case 26:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 26: MELODY_E1+stop after a L1 stop");
              test_verdict = audio_regr_test_26 (&error_type);
              break;
          }
         case 27:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 27: MELODY_E1+callback func");
              test_verdict = audio_regr_test_27 (&error_type);
              break;
          }
         case 28:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 28: MELODY_E1+3 start and 1 unexpected stop");
              test_verdict = audio_regr_test_28 (&error_type);
              break;
          }
         case 29:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 29: MELODY_E1+2 start in normal mode");
              test_verdict = audio_regr_test_29 (&error_type);
              break;
          }
          case 39:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 39: MELODY_E1+ start and stop in loopback mode");
              test_verdict = audio_regr_test_39 (&error_type);
              break;
         }
        #endif
      #if (VOICE_MEMO)
          case 30:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 30: VOICE_MEMO_PLAY + auto stop");
            test_verdict = audio_regr_test_30 (&error_type);
            break;
        }
        case 31:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 31: VOICE_MEMO_PLAY + resquested stop");
            test_verdict = audio_regr_test_31 (&error_type);
            break;
        }
        case 32:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 32: VOICE_MEMO_PLAY+resquested stop before L1 start");
            test_verdict = audio_regr_test_32 (&error_type);
            break;
        }
        case 33:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 33: VOICE_MEMO_PLAY+resquested stop before FFS initialization");
            test_verdict = audio_regr_test_33 (&error_type);
            break;
        }
        case 34:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 34: VOICE_MEMO_PLAY+2 start");
            test_verdict = audio_regr_test_34 (&error_type);
            break;
        }
        case 35:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 35: VOICE_MEMO_PLAY+2 stop");
            test_verdict = audio_regr_test_35 (&error_type);
            break;
        }
        case 36:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 36: VOICE_MEMO_PLAY+stop after a L1 stop");
            test_verdict = audio_regr_test_36 (&error_type);
            break;
        }
        case 37:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 37: VOICE_MEMO_PLAY+callback func");
            test_verdict = audio_regr_test_37 (&error_type);
            break;
        }
        case 38:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 38: VOICE_MEMO_PLAY +Check parameters");
            test_verdict = audio_regr_test_38 (&error_type);
            break;
        }
        case 59:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 59: VOICE_MEMO_PLAY long duration 150s+ audio stop");
            test_verdict = audio_regr_test_59 (&error_type);
            break;
        }
         case 40:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 40: VOICE_MEMO_RECORD + auto stop");
            test_verdict = audio_regr_test_40 (&error_type);
            break;
        }
        case 41:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 41: VOICE_MEMO_RECORD + resquested stop");
            test_verdict = audio_regr_test_41 (&error_type);
            break;
        }
        case 42:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 42: VOICE_MEMO_RECORD+resquested stop before L1 start");
            test_verdict = audio_regr_test_42 (&error_type);
            break;
        }
        case 43:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 43: VOICE_MEMO_RECORD +resquested stop before FFS initialization");
            test_verdict = audio_regr_test_43 (&error_type);
            break;
        }
        case 44:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 44: VOICE_MEMO_RECORD+2 start");
            test_verdict = audio_regr_test_44 (&error_type);
            break;
        }
        case 45:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 45: VOICE_MEMO_RECORD+2 stop");
            test_verdict = audio_regr_test_45 (&error_type);
            break;
        }
        case 46:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 46: VOICE_MEMO_RECORD+stop after a L1 stop");
            test_verdict = audio_regr_test_46 (&error_type);
            break;
        }
        case 47:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 47: VOICE_MEMO_RECORD+callback func");
            test_verdict = audio_regr_test_47 (&error_type);
            break;
        }
        case 48:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 48: VOICE_MEMO_RECORD+Check parameters");
            test_verdict = audio_regr_test_48 (&error_type);
            break;
        }
        case 69:
        {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 69: VOICE_MEMO_RECORD long duration 150s+ audio stop");
            test_verdict = audio_regr_test_69 (&error_type);
            break;
        }
      #endif
         case 50:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 50: Audio mode full access write and read");
              test_verdict = audio_regr_test_50 (&error_type);
              break;
          }
       case 51:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 51: Audio mode save");
            test_verdict = audio_regr_test_51 (&error_type);
            break;
        }
       case 52:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 52: Audio mode load");
            test_verdict = audio_regr_test_52 (&error_type);
            break;
        }
       case 53:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 53: Audio mode speaker volume");
            test_verdict = audio_regr_test_53 (&error_type);
            break;
        }
       case 54:
        {
           RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 54: Audio mode path test");
            test_verdict = audio_regr_test_54 (&error_type);
            break;
        }
	#if (TONE) && (MELODY_E1)
         case 60:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 60: Audio compatibilities: Tone + Melody E1");
              test_verdict = audio_regr_test_60 (&error_type);
              break;
          }
        #endif
        #if (SPEECH_RECO) && (KEYBEEP)
         case 61:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 61: Audio compatibilities: Speech reco + Keybeep");
              test_verdict = audio_regr_test_61 (&error_type);
              break;
          }
        #endif
        #if (SPEECH_RECO)
         case 70:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 70: SR_ENROLL without stop");
              test_verdict = audio_regr_test_70 (&error_type);
              break;
          }
         case 71:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 71: SR_ENROLL + stop");
              test_verdict = audio_regr_test_71 (&error_type);
              break;
          }
          case 72:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 72: SR_ENROLL+requested stop before start");
            test_verdict = audio_regr_test_72 (&error_type);
            break;
          }
          case 73:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 73: SR_ENROLL+ 2 start");
            test_verdict = audio_regr_test_73 (&error_type);
            break;
          }
          case 74:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 74: SR_ENROLL+ 2 stop");
            test_verdict = audio_regr_test_74 (&error_type);
            break;
          }
          case 75:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 75: SR_ENROLL+check parameters");
            test_verdict = audio_regr_test_75 (&error_type);
            break;
          }
          case 76:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 76: SR_ENROLL+ stop after the end");
            test_verdict = audio_regr_test_76 (&error_type);
            break;
          }
          case 77:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 77: SR_ENROLL+ callback");
            test_verdict = audio_regr_test_77 (&error_type);
            break;
          }
          case 78:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 78: SR_ENROLL+ 6 enroll");
            test_verdict = audio_regr_test_78 (&error_type);
            break;
          }
         case 80:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 80: SR_UPDATE without stop");
            test_verdict = audio_regr_test_80 (&error_type);
            break;
          }
         case 81:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 81: SR_UPDATE + stop");
            test_verdict = audio_regr_test_81 (&error_type);
            break;
          }
          case 82:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 82: SR_UPDATE+requested stop before start");
            test_verdict = audio_regr_test_82 (&error_type);
            break;
          }
          case 83:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 83: SR_UPDATE+ 2 start");
            test_verdict = audio_regr_test_83 (&error_type);
            break;
          }
          case 84:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 84: SR_UPDATE+ 2 stop");
            test_verdict = audio_regr_test_84 (&error_type);
            break;
          }
          case 85:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 85: SR_UPDATE+check parameters");
            test_verdict = audio_regr_test_85 (&error_type);
            break;
          }
          case 86:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 86: SR_UPDATE+ stop after the end");
            test_verdict = audio_regr_test_86 (&error_type);
            break;
          }
          case 87:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 87: SR_UPDATE+ callback");
            test_verdict = audio_regr_test_87 (&error_type);
            break;
          }
          case 88:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 88: SR_UPDATE+ 6 update");
            test_verdict = audio_regr_test_88 (&error_type);
            break;
          }
         case 90:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 90: SR_UPDATE_CHECK without stop");
            test_verdict = audio_regr_test_90 (&error_type);
            break;
          }
         case 91:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 91: SR_UPDATE_CHECK + stop");
            test_verdict = audio_regr_test_91 (&error_type);
            break;
          }
          case 92:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 92: SR_UPDATE_CHECK+requested stop before start");
            test_verdict = audio_regr_test_92 (&error_type);
            break;
          }
          case 93:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 93: SR_UPDATE_CHECK+ 2 start");
            test_verdict = audio_regr_test_93 (&error_type);
            break;
          }
          case 94:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 94: SR_UPDATE_CHECK+ 2 stop");
            test_verdict = audio_regr_test_94 (&error_type);
            break;
          }
          case 95:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 95: SR_UPDATE_CHECK+check parameters");
            test_verdict = audio_regr_test_95 (&error_type);
            break;
          }
          case 96:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 96: SR_UPDATE_CHECK+ stop after the end");
            test_verdict = audio_regr_test_96 (&error_type);
            break;
          }
          case 97:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 97: SR_UPDATE_CHECK+ callback");
            test_verdict = audio_regr_test_97 (&error_type);
            break;
          }
          case 98:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 98: SR_UPDATE_CHECK+ 6 update");
            test_verdict = audio_regr_test_98 (&error_type);
            break;
          }
         case 100:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 100: SR_RECO without stop");
            test_verdict = audio_regr_test_100 (&error_type);
            break;
          }
         case 101:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 101: SR_RECO + stop");
            test_verdict = audio_regr_test_101 (&error_type);
            break;
          }
          case 102:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 102: SR_RECO+requested stop before start");
            test_verdict = audio_regr_test_102 (&error_type);
            break;
          }
          case 103:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 103: SR_RECO+ 2 start");
            test_verdict = audio_regr_test_103 (&error_type);
            break;
          }
          case 104:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 104: SR_RECO+ 2 stop");
            test_verdict = audio_regr_test_104 (&error_type);
            break;
          }
          case 105:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 105: SR_RECO+check parameters");
            test_verdict = audio_regr_test_105 (&error_type);
            break;
          }
          case 106:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 106: SR_RECO+ stop after the end");
            test_verdict = audio_regr_test_106 (&error_type);
            break;
          }
          case 107:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 107: SR_RECO+ callback");
            test_verdict = audio_regr_test_107 (&error_type);
            break;
          }
        #endif
        #if (MELODY_E2)
          case 110:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 110:MELODY_E2+auto stop");
             test_verdict = audio_regr_test_110 (&error_type);
             break;
          }
          case 111:
          {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 111: MELODY_E2+resquested stop");
             test_verdict = audio_regr_test_111 (&error_type);
             break;
          }
          case 112:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 112: MELODY_E2+resquested stop before L1 start");
              test_verdict = audio_regr_test_112 (&error_type);
              break;
          }
          case 113:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 113: MELODY_E2+resquested stop before FFS initialization");
              test_verdict = audio_regr_test_113 (&error_type);
              break;
          }
          case 114:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 114: MELODY_E2+2 start");
              test_verdict = audio_regr_test_114 (&error_type);
              break;
          }
          case 115:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 115: MELODY_E2+2 stop");
              test_verdict = audio_regr_test_115 (&error_type);
              break;
          }
          case 116:
          {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 116: MELODY_E2+stop after a L1 stop");
              test_verdict = audio_regr_test_116 (&error_type);
              break;
          }
          case 117:
           {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 117: MELODY_E2+callback func");
              test_verdict = audio_regr_test_117 (&error_type);
              break;
           }
          case 118:
           {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 118: MELODY_E2+3 start and 1 unexpected stop");
              test_verdict = audio_regr_test_118 (&error_type);
              break;
           }
          case 119:
           {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 119: MELODY_E2+2 start in normal mode");
              test_verdict = audio_regr_test_119 (&error_type);
              break;
           }
          case 120:
           {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 120: MELODY_E2+ start and stop in loopback mode");
              test_verdict = audio_regr_test_120 (&error_type);
              break;
           }
          case 121:
           {
              RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 121: MELODY E2+Check parameters");
              test_verdict = audio_regr_test_121 (&error_type);
              break;
           }
          case 122:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 122: MELODY E2 without loading the instruments file ");
             test_verdict = audio_regr_test_122 (&error_type);
             break;
           }
        #endif
        #if (L1_GTT == 1)
           case 130:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST REGR 130: TTY + requested stop");
             test_verdict = audio_regr_test_130 (&error_type);
           }
           break;
           case 131:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST REGR 131: TTY + requested stop before L1 start");
             test_verdict = audio_regr_test_131 (&error_type);
           }
           break;
           case 132:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST REGR 132: TTY + 2 start + stop");
             test_verdict = audio_regr_test_132 (&error_type);
           }
           break;
           case 133:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST REGR 133: TTY + 2 stop");
             test_verdict = audio_regr_test_133 (&error_type);
           }
           break;
           case 134:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST REGR 134: TTY + check error in parameters");
             test_verdict = audio_regr_test_134 (&error_type);
           }
           break;
           case 135:
           {
             RV_TEST_TRACE_HIGH ("**AUDIO TEST REGR 135: TTY + callback function");
             test_verdict = audio_regr_test_135 (&error_type);
           }
           break;
        #endif
        #if (AUDIO_MEM_MANAGER)
          case 140:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 140: Flash/RAM Voice Memo AMR, start record + auto stop");
            test_verdict = audio_regr_test_140 (&error_type);
          }
          break;
          case 141:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 141: Flash/RAM Voice Memo AMR, start record + requested stop");
            test_verdict = audio_regr_test_141 (&error_type);
          }
          break;
          case 142:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 142: Flash/RAM Voice Memo AMR, start record + requested stop just after start");
            test_verdict = audio_regr_test_142 (&error_type);
          }
          break;
          case 143:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 143: Flash/RAM Voice Memo AMR, start record + 2 starts");
            test_verdict = audio_regr_test_143 (&error_type);
          }
          break;
          case 144:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 144: Flash/RAM Voice Memo AMR, start record + 2 stops");
            test_verdict = audio_regr_test_144 (&error_type);
          }
          break;
          case 145:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 145: Flash/RAM Voice Memo AMR, start record check parameters");
            test_verdict = audio_regr_test_145 (&error_type);
          }
          break;
          case 146:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 146: Flash/RAM Voice Memo AMR, start record + start error with callback_function");
            test_verdict = audio_regr_test_146 (&error_type);
          }
          break;
          case 147:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 147: Flash Voice Memo AMR, start record + auto stop (180s)");
            test_verdict = audio_regr_test_147 (&error_type);
          }
          break;

          case 150:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 150: Flash/RAM Voice Memo AMR, start play + auto stop");
            test_verdict = audio_regr_test_150 (&error_type);
          }
          break;
          case 151:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 151: Flash/RAM Voice Memo AMR, start play + requested stop");
            test_verdict = audio_regr_test_151 (&error_type);
          }
          break;
          case 152:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 152: Flash/RAM Voice Memo AMR, start play + requested stop just after start");
            test_verdict = audio_regr_test_152 (&error_type);
          }
          break;
          case 153:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 153: Flash/RAM Voice Memo AMR, start play + 2 starts");
            test_verdict = audio_regr_test_153 (&error_type);
          }
          break;
          case 154:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 154: Flash/RAM Voice Memo AMR, start play + 2 stops");
            test_verdict = audio_regr_test_154 (&error_type);
          }
          break;
          case 155:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 155: Flash/RAM Voice Memo AMR, start play check parameters");
            test_verdict = audio_regr_test_155 (&error_type);
          }
          break;
          case 156:
          {
            RV_TEST_TRACE_HIGH ("**AUDIO TEST MISC 156: Flash/RAM Voice Memo AMR, start play + start with callback_function");
            test_verdict = audio_regr_test_156 (&error_type);
          }
          break;
        #endif // AUDIO_MEM_MANAGER
        #if (L1_MIDI==1)
          case 160:
          {
            RV_TEST_TRACE_HIGH("**AUDIO TEST MISC 160: MIDI, start + automatic stop");
            test_verdict=audio_regr_test_160(&error_type);
          }
          break;
          case 161:
          {
            RV_TEST_TRACE_HIGH("**AUDIO TEST MISC 161: MIDI, start + requested stop");
            test_verdict=audio_regr_test_161(&error_type);
          }
          break;
          case 162:
          {
            RV_TEST_TRACE_HIGH("**AUDIO TEST MISC 162: MIDI, start + immediate stop");
            test_verdict=audio_regr_test_162(&error_type);
          }
          break;
          case 163:
          {
            RV_TEST_TRACE_HIGH("**AUDIO TEST MISC 163: MIDI, start with wrong parameters");
            test_verdict=audio_regr_test_163(&error_type);
          }
          break;
          case 164:
          {
            RV_TEST_TRACE_HIGH("**AUDIO TEST MISC 164: MIDI, 2 starts");
            test_verdict=audio_regr_test_164(&error_type);
          }
          break;
          case 165:
          {
            RV_TEST_TRACE_HIGH("**AUDIO TEST MISC 165: MIDI, start + 2 requested stops");
            test_verdict=audio_regr_test_165(&error_type);
          }
          break;
        #endif // L1_MIDI==1
        default:
        {
          RV_TEST_TRACE_ERROR ("!!! ERROR !!! Invalid AUDIO test_number value for MISC test_type");
          test_verdict = TEST_IRRECOVERABLY_FAILED;
          break;
        }
     } /* switch */

    trace_audio_test_verdict (test_verdict,
                              0,
                              test_number,
                              &error_type);

    trace_audio_test_verdict (test_verdict,
                              test_number,
                              test_number,
                              &error_type);
    /************************************************************************/
    /*                                                                      */
    /*  Memory dump -> check memory used before testing.                    */
    /*  Task   dump -> check task stack used before testing.                */
    /*                                                                      */
    /************************************************************************/
    rvf_dump_mem ();
    rvf_dump_tasks();

    return (test_verdict);
  }

  /************************** Stop audio_test_misc function *************************/

#endif /* #if (AUDIO_MISC == SW_COMPILED) */
