/********************************************************************************/
/*                                                                              */
/*  File Name:  audio_test.h                                                    */
/*                                                                              */
/*  Purpose:  This file contains the definition usefull for an generic audio    */
/*            test.                                                             */
/*                                                                              */
/*  Note:   None.                                                               */
/*                                                                              */
/*  Version   0.1                                                               */
/*                                                                              */
/*  Date        Modification                                                    */
/*  ----------------------------------------------------------------------------*/
/*  14 May 2001  Create                                                         */
/*                                                                              */
/*  Author      Francois Mazard - Stephanie Gerthoux                            */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved    */
/********************************************************************************/

#ifndef _AUDIO_TEST_H_
  #define _AUDIO_TEST_H_

#include "rvf/rvf_api.h"
#include "tests/rv/rv_test_filter.h"

  #if ((AUDIO_REGR == SW_COMPILED) || (AUDIO_MISC == SW_COMPILED))

    /* structure only use for test purpose in PC */
    typedef struct
    {
      /* variable to set the number of speech reco model in a database */
      UINT8   vocabuary_size;
      /* variable to detect if the call back function was called */
      INT8    audio_call_back_called;
      /* structure for the audio mode configuration test */
      T_AUDIO_MODE  audio_mode_1;
      /* structure for the audio mode configuration test */
      T_AUDIO_MODE  audio_mode_2;
      /* structure for the audio spekaer volume test */
      T_AUDIO_SPEAKER_LEVEL speaker_volume_1;
      /* structure for the audio spekaer volume test */
      T_AUDIO_SPEAKER_LEVEL speaker_volume_2;
      #ifdef _WINDOWS
        /* structure used to simulate the NDB API memory */
        T_NDB_MCU_DSP ndb_memory;
        /* structure used to simulate the param API memory */
        T_PARAM_MCU_DSP param_memory;
      #endif
      /* addr_id of the test entity */
      T_RVF_ADDR_ID test_addr_id;
    } T_AUDIO_TEST;

    /* Define the global variables used with AUDIO test level */
    extern T_RVF_MB_ID mb_audio_test;
    extern T_AUDIO_TEST *p_audio_test;
    /* Define the parameters used with AUDIO test level */

    /* Define the macros used with AUDIO test level */

    /* Define function prototypes used with AUDIO test level */

  #endif /* #if (AUDIO_REGR == SW_COMPILED) || (AUDIO_MISC == SW_COMPILED)) */
#endif
