/******************************************************************************/
/*                                                                            */
/*  File Name:  audio_test.c                                                  */
/*                                                                            */
/*  Purpose:  This file contains AUDIO test generic functions.                */
/*                                                                            */
/*  Note:   None.                                                             */
/*                                                                            */
/*  Version   0.1                                                             */
/*                                                                            */
/*  Date        Modification                                                  */
/*  ------------------------------------------------------------------------  */
/*  14 May 2001  Create                                                       */
/*                                                                            */
/*  Author      Francois Mazard - Stephanie Gerthoux                          */
/*                                                                            */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved  */
/******************************************************************************/

#include "tests/rv/rv_test_filter.h"


#if ((AUDIO_REGR == SW_COMPILED) || (AUDIO_MISC == SW_COMPILED))
  #ifndef _WINDOWS
    #include "config/swconfig.cfg"
    #include "config/sys.cfg"
    #include "config/chipset.cfg"
  #endif

  #include "l1_confg.h"
  #include "rv/rv_general.h"
  #include "rvm/rvm_gen.h"
  #include "audio/audio_ffs_i.h"
  #include "audio/audio_api.h"
  #include "audio/audio_structs_i.h"
  #include "audio/audio_var_i.h"
  #include "audio/audio_messages_i.h"
  #include "rvf/rvf_target.h"
  #include "audio/audio_const_i.h"
  #include "audio/audio_error_hdlr_i.h"
  #include "audio/audio_macro_i.h"
  #include "audio/tests/audio_test_regr.h"
  #ifdef _WINDOWS
    /* include the usefull L1 header */
    #define BOOL_FLAG
    #include "l1_types.h"
    #include "l1audio_const.h"
    #include "l1audio_cust.h"
    #include "l1audio_defty.h"
    #include "l1audio_msgty.h"
    #include "l1audio_signa.h"
    #include "l1_const.h"
    #include "l1_defty.h"
    #include "l1_msgty.h"
    #include "l1_signa.h"
    #include "l1_varex.h"
  #endif
  #include "audio/tests/audio_test.h"
    
  #include "tests/rv/rv_test.h"

   /* Define the global variables used with AUDIO test level */
   T_RVF_MB_ID mb_audio_test;
   T_AUDIO_TEST *p_audio_test;

  /********************************************************************************/
  /*                                                                              */
  /*    Function Name:   audio_test_set_mb_id                                     */
  /*                                                                              */
  /*    Purpose:  This function is called to set Audio test MBs IDs and initialize*/
  /*              the pointer to the global variable.                             */
  /*                                                                              */
  /*    Input Parameters:                                                         */
  /*            memory bank list                                                  */
  /*                                                                              */
  /*    Output Parameters:                                                        */
  /*        None.                                                                 */
  /*                                                                              */
  /*    Note:                                                                     */
  /*        None.                                                                 */
  /*                                                                              */
  /*    Revision History:                                                         */
  /*        14 May 2001   Francois Mazard: Creation.                              */
  /*                                                                              */
  /********************************************************************************/
  void audio_test_set_mb_id (T_RVF_MB_ID mb_id[])
  {

    T_RVF_MB_STATUS mb_status;

    /********************** Start audio_test_set_mb_id function ***********************/
    mb_audio_test = mb_id[0];

    mb_status = rvf_get_buf ( mb_audio_test,
                              sizeof (T_AUDIO_TEST),
                              (T_RVF_BUFFER **) (&p_audio_test));
    /* If insufficient resources, then report a memory error and abort.               */
    if ((mb_status == RVF_RED))
    {
      RV_TEST_TRACE_ERROR ("AUDIO TEST: no enough memory to allocate the test structure");
      return;
    }

    /* initilalize the global test variable */
    p_audio_test->test_addr_id = rvf_get_taskid();

    #ifdef _WINDOWS
      /* initialize the L1 ndb pointer */
      l1s_dsp_com.dsp_ndb_ptr = &(p_audio_test->ndb_memory);
      l1s_dsp_com.dsp_param_ptr = &(p_audio_test->param_memory);
    #endif
  }

  /*********************** Stop audio_test_set_mb_id function ***********************/

#endif /* #if (AUDIO_TEST == SW_COMPILED) */