/********************************************************************************/
/*                                                                              */
/*    File Name:   audio_structs_i.h                                            */
/*                                                                              */
/*    Purpose:     This file contains constants, data type, and data            */
/*                 structures that are used by the AUDIO's task.                */
/*                                                                              */
/*    Note:                                                                     */
/*        None.                                                                 */
/*                                                                              */
/*    Revision History:                                                         */
/*      11 May 01     Francois Mazard - Stephanie Gerthoux        Create        */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved.   */
/*                                                                              */
/********************************************************************************/
#include "rv/rv_defined_swe.h"
#ifdef RVM_AUDIO_MAIN_SWE
  #ifndef  _AUDIO_STRUCTS_I_
    #define  _AUDIO_STRUCTS_I_

    #ifndef _WINDOWS
      #include "config/sys.cfg"
      #include "config/chipset.cfg"
    #endif
    #include "l1_confg.h"
    #include "rvm/rvm_gen.h"
    #include "audio/audio_features_i.h"
    #include "audio/audio_ffs_i.h"
    #include "audio/audio_const_i.h"

    #include "ffs/ffs_api.h"

    #ifdef __cplusplus
      extern "C"
        {
    #endif

    /****************************** AUDIO'S ENVIRONMENT *****************************/
    /* Define a structure used to store all information related to the AUDIO's task */
    /* & memory bank identifiers.                                                   */

    #if (KEYBEEP)
      typedef struct
      {
        UINT8         state;              /* keybeep state */
        T_RVF_ADDR_ID task_id;            /* keybeep task_id */
        T_RV_RETURN   return_path;        /* return path of the function that previously start the keybeep */
      } T_AUDIO_KEYBEEP_VAR;
    #endif /* #if (KEYBEEP) */

    #if (TONE)
      typedef struct
      {
        UINT8         state;              /* tones state */
        T_RVF_ADDR_ID task_id;            /* tones task_id */
        T_RV_RETURN   return_path;        /* return path of the function that previously start the tones */
      } T_AUDIO_TONES_VAR;
    #endif

    #if (MELODY_E1)
      typedef struct
      {
        UINT8           state;             /* melody state */
        T_RVF_ADDR_ID   task_id;           /* melody task_id */
        char            melody_name[AUDIO_PATH_NAME_MAX_SIZE];  /* name and path of the word to enroll */
        BOOLEAN         loopback;
        T_RV_RETURN     return_path;       /* return path of the function that previously start the melody */
      } T_AUDIO_MELODY_E1_VAR;
    #endif

    #if (MELODY_E2)
      typedef struct
      {
        UINT8           state;             /* melody state */
        T_RVF_ADDR_ID   task_id;           /* melody task_id */
        char            melody_name[AUDIO_PATH_NAME_MAX_SIZE];  /* name of the melody E2 */
        BOOLEAN         loopback;
        T_RV_RETURN     return_path;       /* return path of the function that previously start the melody */
      } T_AUDIO_MELODY_E2_VAR;

      typedef struct
      {
        BOOLEAN       file_downloaded;
        UINT8         nb_of_instruments;
        char          instrument_file_name[AUDIO_PATH_NAME_MAX_SIZE];
      } T_AUDIO_MELODY_E2_LOAD_FILE_VAR;

      typedef struct
      {
        INT8            id;             /* id of the melody in the .lsi file*/
        char            melody_name[AUDIO_PATH_NAME_MAX_SIZE];  /* name of the melody E2 */

      } T_AUDIO_MELODY_E2_ID_NAME;


    #endif


    #if (VOICE_MEMO)
      typedef struct
      {
        UINT8         state;                /* voice memo state */
        T_RVF_ADDR_ID task_id;              /* voice memo task_id */
        UINT32        recorded_size;        /* voice memo recorded size */
        T_RV_RETURN   return_path;          /* return path of the function that previously start the voice memo  */
        void          *p_l1_send_message;   /* address to the message to send to the L1 */
      } T_AUDIO_VOICE_MEMO_RECORD_VAR;

      typedef struct
      {
        UINT8         state;                /* voice memo state */
        T_RVF_ADDR_ID task_id;              /* voice memo task_id */
        T_RV_RETURN   return_path;          /* return path of the function that previously start the voice memo  */
      } T_AUDIO_VOICE_MEMO_PLAY_VAR;

    #endif

    #if (L1_VOICE_MEMO_AMR)
      typedef struct
      {
        UINT8         state;                /* voice memo state */
        T_RV_RETURN   return_path;          /* return path of the function that previously start the voice memo  */
        UINT8         channel_id;
      #if (AUDIO_NEW_FFS_MANAGER)
        T_FFS_FD      ffs_fd;
      #endif
      #if (AUDIO_RAM_MANAGER)
        UINT8         *audio_ram_fd;
      #endif
      } T_AUDIO_VOICE_MEMO_AMR_RECORD_TO_MEM_VAR;

      typedef struct
      {
        UINT8         state;                /* voice memo state */
        T_RV_RETURN   return_path;          /* return path of the function that previously start the voice memo  */
        UINT8         channel_id;
      #if (AUDIO_NEW_FFS_MANAGER)
        T_FFS_FD      ffs_fd;
      #endif
      #if (AUDIO_RAM_MANAGER)
        UINT8         *audio_ram_fd;
        UINT16        audio_ram_size;
      #endif
      } T_AUDIO_VOICE_MEMO_AMR_PLAY_FROM_MEM_VAR;
    #endif

    #if (MELODY_E1) || (MELODY_E2) || (VOICE_MEMO)

      typedef struct
      {
        UINT8  *p_start_pointer;
        UINT8  *p_stop_pointer;
        UINT16  size;
      } T_AUDIO_FFS_BUFFER_INFO;

      typedef struct
      {
        /* validity of the session: */
        /* 0: this session isn't started */
        /* 1: this session is running */
        BOOLEAN   valid_channel;
        /* file descriptor */
        T_FFS_FD  audio_ffs_fd;
        /*initial size requested before to start the L1 */
        UINT16    size;
        /* loop mode is used or not during this session */
        BOOLEAN   loop_mode;
        /* mode of the session: */
        /* 0: FLASH to RAM download */
        /* 1: RAM to FLASH download */
        BOOLEAN   session_mode;
        UINT8     session_id;
      } T_AUDIO_FFS_SESSION_REQ;

      typedef struct
      {
        /* index of the next buffer will be used by the L1 */
        UINT8                   index_l1;
        /* index of the current buffer used by the FFS */
        UINT8                   index_ffs;
        T_AUDIO_FFS_BUFFER_INFO buffer[AUDIO_MAX_FFS_BUFFER_PER_SESSION];
        /* state of the cust_get_pointer function */
        UINT8                  cust_get_pointer_state;
      } T_AUDIO_FFS_SESSION_INFO;

      typedef struct
      {
        /* Request of the current session */
        T_AUDIO_FFS_SESSION_REQ   session_req;
        /* information of the current session */
        T_AUDIO_FFS_SESSION_INFO  session_info;
      } T_AUDIO_FFS_SESSION;
    #endif

    #if (AUDIO_MEM_MANAGER)
      typedef struct
      {
        // file or RAM buffer descriptor
      #if (AUDIO_NEW_FFS_MANAGER)
        T_FFS_FD  audio_ffs_fd;
      #endif
      #if (AUDIO_RAM_MANAGER)
        UINT8     *audio_ram_fd;
        UINT16    audio_ram_size;
      #endif

        // size of temporary RAM buffers (8-bit unit)
        UINT16    size;

        // session_id and channel_id to identify feature
        UINT8     session_id;
        UINT8     channel_id;
      } T_AUDIO_MEM_SESSION_REQ;

      typedef struct
      {
        UINT8                   state; // state machine
        UINT8                   size_left; // sample split between 2 RAM buffers
        UINT8                   previous_type; // last sample type processed
        UINT32                  recorded_size; /* voice memo recorded size */
        BOOL                    stop_req_allowed;// TRUE first then FALSE
      } T_AUDIO_MEM_SESSION_INFO;

      typedef struct
      {
        /* Request of the current session */
        T_AUDIO_MEM_SESSION_REQ   session_req;
        /* information of the current session */
        T_AUDIO_MEM_SESSION_INFO  session_info;
      } T_AUDIO_MEM_SESSION;
    #endif

    #if (MELODY_E1) || (MELODY_E2) || (VOICE_MEMO)

      typedef struct
      {
        UINT8  *p_start_pointer;
        UINT16  size;
      } T_AUDIO_DRIVER_BUFFER_INFO;

      typedef struct
      {
        UINT16    size; // initial size requested before to start the L1
        UINT8     nb_buffer; // nb buffer
        UINT8     session_id;
        void      *p_l1_send_message;   /* address to the message to send to the L1 */
        T_RV_RETURN return_path;
      } T_AUDIO_DRIVER_SESSION_REQ;

      typedef struct
      {
        UINT8                   index_l1; // index of the next buffer will be used by the L1
        UINT8                   index_appli; // index of the current buffer used by the FFS

        T_AUDIO_DRIVER_BUFFER_INFO *buffer; // pointers on temporary RAM buffers

        UINT8                   state;
        UINT8                   play_api_state;// only play
        UINT8                   stop_request;// 0 first then 1 when stop request
      } T_AUDIO_DRIVER_SESSION_INFO;

      typedef struct
      {
        /* Request of the current session */
        T_AUDIO_DRIVER_SESSION_REQ   session_req;
        /* information of the current session */
        T_AUDIO_DRIVER_SESSION_INFO  session_info;
      } T_AUDIO_DRIVER_SESSION;
    #endif

    #if (SPEECH_RECO)
      typedef struct
      {
        /* enroll speech reco state */
        UINT8       state;
        /* voice sample file descriptor */
        T_FFS_FD  voice_ffs_fd;
        /* speech reco sample file descriptor */
        T_FFS_FD  sr_ffs_fd;
        /* task_id */
        UINT16       task_id;
        /* Speech buffer address */
        void        *p_speech_address;
        /* return path of the function that previously start the sppeech reco */
        T_RV_RETURN return_path;
      } T_AUDIO_SR_ENROLL_VAR;

      typedef struct
      {
        /* update speech reco state */
        UINT8       state;
        /* task_id */
        UINT16       task_id;
        /* Speech buffer address */
        void        *p_speech_address;
        /* Temporary model buffer address */
        void        *p_model_address;
        /* vocabulary size */
        UINT8        vocabulary_size;
        /* model index to update */
        UINT8        model_index;
        /* flag to mention if the speech must be recorded */
        BOOL         record_speech;
        /* return path of the function that previously start the sppeech reco */
        T_RV_RETURN return_path;
        /* pointer to the vocabulary database */
        void  *p_database;
      } T_AUDIO_SR_UPDATE_VAR;

      typedef struct
      {
        /* update speech reco state */
        UINT8       state;
        /* task_id */
        UINT16       task_id;
        /* vocabulary size */
        UINT8        vocabulary_size;
        /* return path of the function that previously start the sppeech reco */
        T_RV_RETURN return_path;
        /* pointer to the vocabulary database */
        void  *p_database;
      } T_AUDIO_SR_RECO_VAR;

      typedef struct
      {
        /* speech reco enroll variables */
        T_AUDIO_SR_ENROLL_VAR sr_enroll;
        T_AUDIO_SR_UPDATE_VAR sr_update;
        T_AUDIO_SR_RECO_VAR sr_reco;
      } T_AUDIO_SPEECH_RECO_VAR;
    #endif

    #if (L1_MIDI==1)
      typedef struct
      {
        UINT8         state;                // midi state
        T_RV_RETURN   return_path;          // return path of the function that previously started midi
        UINT8         channel_id;
        UINT16        size;
        T_FFS_FD      ffs_fd;
        BOOL          stop_req_allowed;
        #ifdef _WINDOWS
          UINT8 l1_state;
          INT16 counter;
        #endif
      } T_AUDIO_MIDI_VAR;
    #endif


    /* audio configuration variable */
    typedef struct
    {
      /* full access write state */
      UINT8   state;
      /* Number of message to receive */
      UINT8 number_of_message;
      /* address to the data buffer */
      void   *buffer;
      /* flag to know if the data buffer need to be deallocate or not */
      BOOLEAN             deallocate_buffer;
      /* return path of the function that previously start the full access write */
      T_RV_RETURN return_path;
    }
    T_AUDIO_FULL_ACCESS_WRITE_VAR;

    typedef struct
    {
      /* state of the audio mode load state machine */
      UINT8 state;
      /* Number of message to receive */
      UINT8 number_of_message;
      /* pointer to the RAM buffer */
      T_AUDIO_MODE *p_audio_mode;
      /* return path */
      T_RV_RETURN return_path;
    }
    T_AUDIO_MODE_LOAD_VAR;

    typedef struct
    {
      char  audio_volume_path_name[AUDIO_PATH_NAME_MAX_SIZE];
    }
    T_AUDIO_VOLUME_VAR;

    typedef struct
    {
      T_AUDIO_FULL_ACCESS_WRITE_VAR full_access_write_var;
      T_AUDIO_MODE_LOAD_VAR         audio_mode_load_var;
      T_AUDIO_VOLUME_VAR            audio_volume_var;
      } T_AUDIO_MODE_VAR;

    typedef struct
    {
      T_RVF_ADDR_ID          addrId;            /* AUDIO address ID.       */
      T_RVF_ADDR_ID          audio_ffs_addrId;  /* AUDIO FFS manager address ID.       */

      T_RVF_MB_ID            mb_internal;   /* AUDIO internal memory bank. */
      T_RVF_MB_ID            mb_external;   /* AUDIO external memory bank. */
      T_RVF_MB_ID            mb_audio_ffs;  /* AUDIO FFS memory bank */
      T_RVM_RETURN           (*callBackFct)  (T_RVM_NAME        SWEntName,
                                              T_RVM_RETURN      errorCause,
                                              T_RVM_ERROR_TYPE  errorType,
                                              T_RVM_STRING      errorMsg);

      BOOLEAN               message_processed;

      #if (KEYBEEP)
        /* Keybeep global variable */
        T_AUDIO_KEYBEEP_VAR     keybeep;
      #endif
      #if (TONE)
        /* Tones global variable */
        T_AUDIO_TONES_VAR     tones;
      #endif
      #if (MELODY_E1)
        /* Melody_E1 global variable */
        BOOLEAN                   melody_E1_mode;
        T_AUDIO_MELODY_E1_VAR     melody_E1_0;
        T_AUDIO_MELODY_E1_VAR     melody_E1_1;
      #endif
      #if (MELODY_E2)
        /* Melody_E2 global variable */
        BOOLEAN                                melody_E2_mode;
        T_AUDIO_MELODY_E2_VAR                  melody_E2_0;
        T_AUDIO_MELODY_E2_VAR                  melody_E2_1;
        T_AUDIO_MELODY_E2_LOAD_FILE_VAR melody_E2_load_file_instruments;
      #endif
      #if (VOICE_MEMO)
        /* Voice Memo global variable */
        T_AUDIO_VOICE_MEMO_PLAY_VAR       vm_play;
        T_AUDIO_VOICE_MEMO_RECORD_VAR     vm_record;
      #endif
      #if (L1_VOICE_MEMO_AMR)
        /* Voice Memo global variable */
        T_AUDIO_VOICE_MEMO_AMR_RECORD_TO_MEM_VAR audio_vm_amr_record;
        T_AUDIO_VOICE_MEMO_AMR_PLAY_FROM_MEM_VAR audio_vm_amr_play;
      #endif
      #if (SPEECH_RECO)
        /* Speech reco global variable */
        T_AUDIO_SPEECH_RECO_VAR       speech_reco;
      #endif

      #if (L1_MIDI==1)
        // Midi global variable
        T_AUDIO_MIDI_VAR midi;
      #endif

      /* audio mode variable */
      T_AUDIO_MODE_VAR  audio_mode_var;

      #if (MELODY_E1) ||(MELODY_E2) || (VOICE_MEMO)
        /* Audio FFS global variable */
        T_AUDIO_FFS_SESSION audio_ffs_session[AUDIO_FFS_MAX_CHANNEL];
      #endif
      #if (AUDIO_MEM_MANAGER)
        T_AUDIO_MEM_SESSION audio_mem_session[AUDIO_MEM_MAX_CHANNEL];
      #endif
      #if (MELODY_E1) ||(MELODY_E2) || (VOICE_MEMO) || (L1_VOICE_MEMO_AMR)
        /* Audio FFS global variable */
        T_AUDIO_DRIVER_SESSION audio_driver_session[AUDIO_DRIVER_MAX_CHANNEL];
      #endif
    }
    T_AUDIO_ENV_CTRL_BLK;

    #ifdef __cplusplus
       }
    #endif
  #endif /* _AUDIO_STRUCTS_I_ */
#endif /* #ifdef RVM_AUDIO_MAIN_SWE */
