/**
 * @file	audio_pool_size.h
 *
 * Declarations of:
 * - the memory bank sizes and their watermark
 * - the SWE stack size
 * - the pool size needed (generally the sum of memory bank and stack sizes)
 *
 * @author	Vincent Oberle
 * @version 0.1
 */

/*
 * History:
 *
 *	Date       	Author					Modification
 *	-------------------------------------------------------------------
 *	07/08/2003	Vincent Oberle			Extracted from rvf_pool_size.h
 *
 * (C) Copyright 2003 by Texas Instruments Incorporated, All Rights Reserved
 */

#ifndef __AUDIO_POOL_SIZE_H_
#define __AUDIO_POOL_SIZE_H_


#ifndef _WINDOWS
  #include "l1sw.cfg"
  #include "swconfig.cfg"
#endif


/*
 * Values used in audio_env_i.h
 */
#define AUDIO_STACK_SIZE (1280)
#define AUDIO_MB1_SIZE   (512)
#define AUDIO_MB2_SIZE   (2000)

#if (GSMLITE)
  #define AUDIO_MB3_SIZE   (0)
#elif (SPEECH_RECO)
  #define AUDIO_MB3_SIZE   (7382)
#else
  #define AUDIO_MB3_SIZE   (2048)
#endif

#define AUDIO_POOL_SIZE  (AUDIO_STACK_SIZE + \
                          AUDIO_MB1_SIZE + AUDIO_MB2_SIZE + AUDIO_MB3_SIZE)


#define AUDIO_BGD_STACK_SIZE (512)
#define AUDIO_BGD_MB1_SIZE   (256)

#define AUDIO_BGD_POOL_SIZE  (AUDIO_BGD_STACK_SIZE + AUDIO_BGD_MB1_SIZE)


#endif /*__AUDIO_POOL_SIZE_H_*/
