/****************************************************************************/
/*                                                                          */
/*  File Name:  audio_mode_i.h                                              */
/*                                                                          */
/*  Purpose:  This file contains symbolic constant used for the audio mode  */
/*                                                                          */
/*  Version   0.1                                                           */
/*                                                                          */
/*  Date         Modification                                               */
/*  ------------------------------------                                    */
/*  18 Jan 2002  Create                                                     */
/*                                                                          */
/*  Author       Francois Mazard                                            */
/*                                                                          */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved*/
/****************************************************************************/

#include "rv/rv_defined_swe.h"
#ifdef RVM_AUDIO_MAIN_SWE

  #ifndef __AUDIO_MODE_I_H_
    #define __AUDIO_MODE_I_H_

    #ifdef __cplusplus
      extern "C"
        {
    #endif

    #if (ANLG_FAM == 1)
      /* Register mapping for OMEGA, NAUSICA */

      /* VBCR register */
      #define AUDIO_VBCR_VFBYP        (0x0200)
      #define AUDIO_VBCR_VBDFAUXG     (0x0100)
      #define AUDIO_VBCR_VSYNC        (0x0080)
      #define AUDIO_VBCR_VCLKMODE     (0x0040)
      #define AUDIO_VBCR_VALOOP       (0x0020)
      #define AUDIO_VBCR_MICBIAS      (0x0010)
      #define AUDIO_VBCR_VULSWITCH    (0x0008)
      #define AUDIO_VBCR_VBUZ         (0x0004)
      #define AUDIO_VBCR_VDLEAR       (0x0002)
      #define AUDIO_VBCR_VDLAUX       (0x0001)

      /* VBUR */
      #define AUDIO_VBUR_DXEN         (0x0200)
      #define AUDIO_VBUR_VDLST        (0x000F)
      #define AUDIO_VBUR_VULPG        (0x001F)

      /* VBDR */
      #define AUDIO_VBDR_VDLPG        (0x000F)
      #define AUDIO_VBDR_VOLCTL       (0x000F)
    #endif
    #if (ANLG_FAM == 2)
      /* Register mapping for IOTA */

      /* VBCR register */
      #define AUDIO_VBCR_VFBYP        (0x0200)
      #define AUDIO_VBCR_VBDFAUXG     (0x0100)
      #define AUDIO_VBCR_VSYNC        (0x0080)
      #define AUDIO_VBCR_VCLKMODE     (0x0040)
      #define AUDIO_VBCR_VALOOP       (0x0020)
      #define AUDIO_VBCR_MICBIAS      (0x0010)
      #define AUDIO_VBCR_VULSWITCH    (0x0008)
      #define AUDIO_VBCR_VBUZ         (0x0004)
      #define AUDIO_VBCR_VDLEAR       (0x0002)
      #define AUDIO_VBCR_VDLAUX       (0x0001)

      /* VBCR2 */
      #define AUDIO_VBCR2_MICBIASEL   (0x0001)
      #define AUDIO_VBCR2_VDLHSO      (0x0002)
      #define AUDIO_VBCR2_MICNAUX     (0x0004)

      /* VBUR */
      #define AUDIO_VBUR_DXEN         (0x0200)
      #define AUDIO_VBUR_VDLST        (0x000F)
      #define AUDIO_VBUR_VULPG        (0x001F)

      /* VBDR */
      #define AUDIO_VBDR_VDLPG        (0x000F)
      #define AUDIO_VBDR_VOLCTL       (0x000F)
    #endif
    #if (ANLG_FAM == 3)
      /* Register mapping for SYREN */

      /* VBCR register */
      #define AUDIO_VBCR_VFBYP        (0x0200)
      #define AUDIO_VBCR_VBDFAUXG     (0x0100)
      #define AUDIO_VBCR_VSYNC        (0x0080)
      #define AUDIO_VBCR_VCLKMODE     (0x0040)
      #define AUDIO_VBCR_VALOOP       (0x0020)
      #define AUDIO_VBCR_MICBIAS      (0x0010)
      #define AUDIO_VBCR_VULSWITCH    (0x0008)

      /* VBCR2 */
      #define AUDIO_VBCR2_MICBIASEL   (0x0004)

      /* VBUR */
      #define AUDIO_VBUR_DXEN         (0x0200)
      #define AUDIO_VBUR_VDLST        (0x01E0)
      #define AUDIO_VBUR_VULPG        (0x001F)

      /* VBDR */
      #define AUDIO_VBDR_VDLPG        (0x000F)
      #define AUDIO_VBDR_VOLCTL       (0x0070)
    #endif

    #ifdef __cplusplus
      }
    #endif

  #endif /* __AUDIO_MODE_I_H_ */
#endif /* #ifdef RVM_AUDIO_MAIN_SWE */


