#ifndef AUDIO_FEATURES_I_H
#define AUDIO_FEATURES_I_H

  #include "audio/audio_api.h"

  /* configuration */
  /* FFS or RAM manager exist only if they are enabled AND a related L1 feature is enabled
     Currently only VOICE MEMO AMR is supported */
  #define AUDIO_ENABLE_NEW_FFS_MANAGER 1
  #define AUDIO_NEW_FFS_MANAGER (AUDIO_ENABLE_NEW_FFS_MANAGER)&&(L1_VOICE_MEMO_AMR)
  #define AUDIO_ENABLE_RAM_MANAGER 1
  #define AUDIO_RAM_MANAGER (AUDIO_ENABLE_RAM_MANAGER)&&(L1_VOICE_MEMO_AMR)
  #define AUDIO_MEM_MANAGER (AUDIO_RAM_MANAGER) || (AUDIO_NEW_FFS_MANAGER)

  /* external prototype */
  #if (KEYBEEP)
    void audio_keybeep_manager (T_RV_HDR *p_message);
    void audio_keybeep_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
  #endif
  #if (TONE)
    void audio_tones_manager (T_RV_HDR *p_message);
    void audio_tones_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
  #endif
  #if (MELODY_E1)
    void audio_melody_E1_manager_0       (T_RV_HDR *p_message);
    void audio_melody_E1_manager_1       (T_RV_HDR *p_message);
    UINT8 audio_melody_E1_message_switch (T_RV_HDR *p_message);
    void audio_melody_E1_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
  #endif
  #if (MELODY_E2)
    void audio_melody_E2_manager_0       (T_RV_HDR *p_message);
    void audio_melody_E2_manager_1       (T_RV_HDR *p_message);
    UINT8 audio_melody_E2_message_switch (T_RV_HDR *p_message);
    void audio_background_melody_e2_download_instrument_manager (T_RV_HDR *p_message);
    void audio_melody_E2_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
  #endif
  #if (VOICE_MEMO)
    void audio_vm_play_manager (T_RV_HDR *p_message);
    void audio_vm_record_manager(T_RV_HDR *p_message);
    UINT8 audio_voice_memo_message_switch (T_RV_HDR *p_message);
    void audio_vm_play_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
    void audio_vm_record_send_status ( T_AUDIO_RET status,
                                              UINT32 recorded_size,
                                              T_RV_RETURN return_path);
  #endif
  #if (MELODY_E1) || (MELODY_E2) || (VOICE_MEMO)
    void audio_ffs_manager (T_RV_HDR *p_message);
    void audio_ffs_downloader (void);
  #endif
  #if (L1_VOICE_MEMO_AMR)&&(AUDIO_MEM_MANAGER)
    void audio_vm_amr_play_from_memory_manager (T_RV_HDR *p_message);
    void audio_vm_amr_record_to_memory_manager (T_RV_HDR *p_message);
  #endif
  #if (L1_VOICE_MEMO_AMR)
    UINT8 audio_voice_memo_amr_memory_message_switch (T_RV_HDR *p_message);
    void audio_vm_amr_play_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
    void audio_vm_amr_record_send_status ( T_AUDIO_RET status,
                                           UINT32 recorded_size,
                                           T_RV_RETURN return_path);
  #endif
  #if (SPEECH_RECO)
    void audio_sr_enroll_manager (T_RV_HDR *p_message);
    void audio_sr_update_manager (T_RV_HDR *p_message);
    void audio_sr_reco_manager (T_RV_HDR *p_message);
    #ifndef _WINDOWS
      void audio_sr_background_manager(T_RV_HDR *p_message);
    #endif
    void audio_sr_enroll_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
    void audio_sr_update_send_status (T_AUDIO_RET status, T_RV_RETURN return_path);
    void audio_sr_reco_send_status (T_AUDIO_RET status, UINT8 word_index, T_RV_RETURN return_path);
  #endif

  #if (AUDIO_MEM_MANAGER)
    UINT8 audio_mem_message_switch(T_RV_HDR *p_message);
    void audio_mem_manager (T_RV_HDR *p_message);
  #endif
  #if (L1_AUDIO_DRIVER)
    void audio_driver_manager(T_RV_HDR *p_message);
    UINT8 audio_driver_message_switch(T_RV_HDR *p_message);
  #endif

  /* audio mode prototype */
  void  audio_mode_full_access_write_manager  (T_RV_HDR *p_message);
  void  audio_mode_load_manager               (T_RV_HDR *p_message);
  void  audio_mode_save_manager               (T_RV_HDR *p_message);
  void audio_mode_speaker_volume_manager      (T_RV_HDR *p_message);
  UINT8 audio_mode_message_switch             (T_RV_HDR *p_message);

  void *audio_allocate_l1_message(UINT16 size);
  void audio_deallocate_l1_message(void *message);
  T_RV_RET audio_send_l1_message(INT16 message_id, void *message);
#endif
