#
#       Makefile for Audio Riviera service (ARM compiler)
#
#       Copyright (c) Texas Instruments 2001
#
#               Author: Mazard Francois
#       Date : 12 July 2001

# Compilation flags
AUDIO_FLAGS      = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_AUDIO_FLAGS := $($(TP)CFLAGS) $(CFLAGSSERVICES) -I$(SYSTEM_DIR)/main -I$(SERVICES_DIR)/audio/tests -I$(DRIVERS_CORE_DIR)/abb -I$(RIVIERA_DIR)/tests/rv -I$(LAYER1_DIR)/audio_cust0 /D "OP_RIV_AUDIO=1"

# Libraries definition
LIB_AUDIO := $(OUT_LIB_DIR)/audio.lib
CFG_LIBS  += $(LIB_AUDIO)

# Source definition
ifdef AUDIO_SOURCE
COMMON_SRC_AUDIO := $(SERVICES_DIR)/audio/audio_env.c \
                    $(SERVICES_DIR)/audio/audio_api.c \
                    $(SERVICES_DIR)/audio/audio_error_hdlr.c \
                    $(SERVICES_DIR)/audio/audio_task.c \
                    $(SERVICES_DIR)/audio/audio_keybeep.c \
                    $(SERVICES_DIR)/audio/audio_tones.c \
                    $(SERVICES_DIR)/audio/audio_melody_E1.c \
                    $(SERVICES_DIR)/audio/audio_melody_E2.c \
                    $(SERVICES_DIR)/audio/audio_ffs.c \
                    $(SERVICES_DIR)/audio/audio_vm.c \
                    $(SERVICES_DIR)/audio/audio_vm_play.c \
                    $(SERVICES_DIR)/audio/audio_vm_record.c \
                    $(SERVICES_DIR)/audio/audio_compatibilities.c \
                    $(SERVICES_DIR)/audio/audio_sr_enroll.c \
                    $(SERVICES_DIR)/audio/audio_sr_update.c \
                    $(SERVICES_DIR)/audio/audio_sr_reco.c \
                    $(SERVICES_DIR)/audio/audio_sr.c \
                    $(SERVICES_DIR)/audio/audio_mode.c \
                    $(SERVICES_DIR)/audio/audio_mode_full_write.c \
                    $(SERVICES_DIR)/audio/audio_mode_load.c \
                    $(SERVICES_DIR)/audio/audio_mode_save.c \
                    $(SERVICES_DIR)/audio/audio_mode_drivers.c \
                    $(SERVICES_DIR)/audio/audio_mode_volume.c \
                    $(SERVICES_DIR)/audio/audio_midi.c

SRC_AUDIO        += $(COMMON_SRC_AUDIO) \
                    $(SERVICES_DIR)/audio/audio_vm_amr.c \
                    $(SERVICES_DIR)/audio/audio_vm_amr_play.c \
                    $(SERVICES_DIR)/audio/audio_vm_amr_record.c \
                    $(SERVICES_DIR)/audio/audio_driver.c

WIN_SRC_AUDIO    += $(COMMON_SRC_AUDIO) \
                    $(LAYER1_DIR)/audio_cfile/l1audio_abb.c
endif

# Objects and dependencies definition
OBJ_AUDIO := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_AUDIO)))
CFG_OBJS += $(OBJ_AUDIO)
CFG_DEPS += $(OBJ_AUDIO:.obj=.d)


######## LIBRARIES #############
$(LIB_AUDIO) : $(OBJ_AUDIO)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_AUDIO) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)AUDIO_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<
