#
#       Makefile for Audio Riviera service (ARM compiler)
#
#       Copyright (c) Texas Instruments 2001
#
#               Author: Mazard Francois
#       Date : 12 July 2001

# Compilation flags
AUDIO_BGD_FLAGS     = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_AUDIO_BGD_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES)

# Libraries definition
LIB_AUDIO_BGD := $(OUT_LIB_DIR)/audio_bgd.lib
CFG_LIBS  += $(LIB_AUDIO_BGD)

# Source definition
ifdef AUDIO_SOURCE
COMMON_SRC_AUDIO_BGD := $(SERVICES_DIR)/audio/audio_bgd/audio_bgd_env.c \
                        $(SERVICES_DIR)/audio/audio_bgd/audio_bgd_task.c

SRC_AUDIO_BGD        := $(COMMON_SRC_AUDIO_BGD)
WIN_SRC_AUDIO_BGD    := $(COMMON_SRC_AUDIO_BGD)
endif

# Objects and dependencies definition
OBJ_AUDIO_BGD := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_AUDIO_BGD)))
CFG_OBJS += $(OBJ_AUDIO_BGD)
CFG_DEPS += $(OBJ_AUDIO_BGD:.obj=.d)


######## LIBRARIES #############
$(LIB_AUDIO_BGD) : $(OBJ_AUDIO_BGD)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_AUDIO_BGD) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)AUDIO_BGD_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<
