
#
# Makefile for rebuilding the Nucleus libraries: One being in Flash and the
# other one being loaded in Internal RAM.
# In order to re-build the Nucleus libraries, the flag OS_MK must be set to 1
#


# Compilation flags
OS_DBG    = $(DBG) # $(DBG) for debug; see master.mak for definition

OS_FLAGS      = $(OS_DBG) $(LENDIAN) $(16INST) -o $(ALGN) $(patsubst %,-i%,$(CFG_INCLUDE))
OS_FLAGS_NOPT = $(OS_DBG) $(LENDIAN) $(16INST) $(ALGN) $(patsubst %,-i%,$(CFG_INCLUDE))
OS_AFLAGS = $(OS_DBG) $(ASMFLAGS)

OS_ADEFS  = -dOP_L1_STANDALONE=$(OP_L1_STANDALONE)
ifeq ($(OP_L1_STANDALONE), 0)
  OS_ADEFS  += -dTI_NUC_MONITOR=$(TI_NUC_MONITOR)
endif



# Initialization and Abort on error files
OS_SRC_INIT := $(OS_NUC_DIR)/inc.c $(OS_NUC_DIR)/dmi.c $(OS_NUC_DIR)/evi.c \
               $(OS_NUC_DIR)/pmi.c $(OS_NUC_DIR)/mbi.c $(OS_NUC_DIR)/ioi.c \
               $(OS_NUC_DIR)/tmi.c $(OS_NUC_DIR)/qui.c $(OS_NUC_DIR)/hii.c \
               $(OS_NUC_DIR)/eri.c $(OS_NUC_DIR)/pii.c $(OS_NUC_DIR)/smi.c \
               $(OS_NUC_DIR)/tci.c $(OS_NUC_DIR)/erc.c 

# Data used due to the init above
OS_SRC_DAT  := $(OS_NUC_DIR)/mbd.c $(OS_NUC_DIR)/iod.c $(OS_NUC_DIR)/hid.c \
               $(OS_NUC_DIR)/pid.c $(OS_NUC_DIR)/qud.c $(OS_NUC_DIR)/erd.c

# licence Informations files
OS_SRC_LIC  := $(OS_NUC_DIR)/lic.c $(OS_NUC_DIR)/rld.c $(OS_NUC_DIR)/lid.c 

# not used files
OS_SRC_NU   := $(OS_NUC_DIR)/ioc.c $(OS_NUC_DIR)/ioce.c $(OS_NUC_DIR)/iof.c \
               $(OS_NUC_DIR)/quc.c $(OS_NUC_DIR)/quce.c $(OS_NUC_DIR)/quf.c \
               $(OS_NUC_DIR)/qus.c $(OS_NUC_DIR)/quse.c                     \
               $(OS_NUC_DIR)/pic.c $(OS_NUC_DIR)/pice.c $(OS_NUC_DIR)/pif.c \
               $(OS_NUC_DIR)/pis.c $(OS_NUC_DIR)/pise.c                     \
               $(OS_NUC_DIR)/mbc.c $(OS_NUC_DIR)/mbce.c $(OS_NUC_DIR)/mbf.c \
               $(OS_NUC_DIR)/mbs.c $(OS_NUC_DIR)/mbse.c                     \
               $(OS_NUC_DIR)/sms.c $(OS_NUC_DIR)/smse.c                     \
               $(OS_NUC_DIR)/tcs.c $(OS_NUC_DIR)/tcse.c                     \
               $(OS_NUC_DIR)/evf.c $(OS_NUC_DIR)/hic.c   

# not important files
ifeq ($(TOOL_CHOICE),0)
OS_SRC_NI_NOPT := $(OS_NUC_DIR)/dmc.c
else
OS_SRC_NI_NOPT :=
OS_SRC_NI   := $(OS_NUC_DIR)/dmc.c
endif

OS_SRC_NI   += $(OS_NUC_DIR)/dmce.c $(OS_NUC_DIR)/dmd.c  \
               $(OS_NUC_DIR)/dmf.c $(OS_NUC_DIR)/evc.c  $(OS_NUC_DIR)/evce.c \
               $(OS_NUC_DIR)/evd.c $(OS_NUC_DIR)/pmf.c  $(OS_NUC_DIR)/smf.c  \
               $(OS_NUC_DIR)/tcf.c $(OS_NUC_DIR)/tmf.c  $(OS_NUC_DIR)/rlc.c  

# All files in Flash
OS_SRC_FLASH := $(OS_SRC_INIT) $(OS_SRC_DAT) $(OS_SRC_LIC) $(OS_SRC_NU) $(OS_SRC_NI)
OS_SRC_FLASH_NOPT := $(OS_SRC_NI_NOPT)


# C files in Internal RAM
OS_SRC_INT_RAM := $(OS_NUC_DIR)/csc.c $(OS_NUC_DIR)/tmc.c                      \
                  $(OS_NUC_DIR)/pmc.c $(OS_NUC_DIR)/pmce.c $(OS_NUC_DIR)/pmd.c \
                  $(OS_NUC_DIR)/smc.c $(OS_NUC_DIR)/smce.c $(OS_NUC_DIR)/smd.c \
                  $(OS_NUC_DIR)/tcc.c $(OS_NUC_DIR)/tcce.c $(OS_NUC_DIR)/tcd.c \
                  $(OS_NUC_DIR)/tms.c $(OS_NUC_DIR)/tmse.c $(OS_NUC_DIR)/tmd.c

# Assembly files in Internal RAM
OS_SRC_ASM_INT_RAM := $(OS_NUC_DIR)/tct.s $(OS_NUC_DIR)/tmt.s


# Object definitions (Flags)
OS_FLASH_OBJ        := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(OS_SRC_FLASH)))
CFG_OBJS            += $(OS_FLASH_OBJ)
CFG_DEPS            += $(OS_FLASH_OBJ:.obj=.d)

OS_FLASH_NOPT_OBJ   := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(OS_SRC_FLASH_NOPT)))
CFG_OBJS            += $(OS_FLASH_NOPT_OBJ)
CFG_DEPS            += $(OS_FLASH_NOPT_OBJ:.obj=.d)

OS_INT_RAM_OBJ      := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(OS_SRC_INT_RAM)))
CFG_OBJS            += $(OS_INT_RAM_OBJ)
CFG_DEPS            += $(OS_INT_RAM_OBJ:.obj=.d)

OS_ASM_INT_RAM_OBJ  := $(patsubst ../%.s,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.s,$(OS_SRC_ASM_INT_RAM)))
CFG_OBJS            += $(OS_ASM_INT_RAM_OBJ)

# All files in Flash
OS_EXT_FLASH_OBJ := $(OS_FLASH_OBJ) $(OS_FLASH_NOPT_OBJ)

# All files in Internal RAM
OS_INTERNAL_RAM_OBJ := $(OS_INT_RAM_OBJ) $(OS_ASM_INT_RAM_OBJ)


# Libraries
all: $(OS_INT_RAM_LIB) $(OS_FLASH_LIB)

$(OS_FLASH_LIB): $(OS_EXT_FLASH_OBJ) 
	$(MKDIR) $(dir $@)
	$(AR470) r $(OS_FLASH_LIB) $(OS_EXT_FLASH_OBJ)

$(OS_INT_RAM_LIB): $(OS_INTERNAL_RAM_OBJ) 
	$(MKDIR) $(dir $@)
	$(AR470) r $(OS_INT_RAM_LIB) $(OS_INTERNAL_RAM_OBJ)


# Objects
$(OS_FLASH_OBJ) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$(COMPILER) $(OS_FLAGS) -fr$(@D) $<

$(OS_FLASH_NOPT_OBJ) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$(COMPILER) $(OS_FLAGS_NOPT) -fr$(@D) $<

$(OS_INT_RAM_OBJ) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$(COMPILER) $(OS_FLAGS) -fr$(@D) $<

ifeq ($(TOOL_CHOICE),0)
$(OS_ASM_INT_RAM_OBJ) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.s
	$(ASM470) $(OS_AFLAGS) $(OS_ADEFS) $< $@
endif

ifeq ($(TOOL_CHOICE),3)
$(OS_ASM_INT_RAM_OBJ) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.s
	$(COMPILER) $(OS_AFLAGS) $(OS_ADEFS) -fr=$(@D) $<
endif

