#
# TPU drivers makefile
#

# Compilation flags

TPU_DBG := $(DBG) # $(DBG) for debug; see master.mak for definition

TPU_DRIVERS_FLAGS := $(TPU_DBG) -c $(16INST) $(ALGN) -o2 $(CFLAGSTPUDRIVERS)


CFG_LIBS += $(TPU_DRIVERS_LIB)

# Source definitions

SRC_TPU_DRV := $(TPU_DRIVERS_DIR)/source/tpudrv.c $(TPU_DRIVERS_DIR)/source0/tpudrv$(RF_FAM).c
ifeq ($(L1_GPRS), 1)
SRC_TPU_DRV += $(TPU_DRIVERS_DIR)/p_source0/p_tpudr$(RF_FAM).c
endif

# Objects definition

OBJ_TPU_DRV := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(SRC_TPU_DRV)))
CFG_OBJS += $(OBJ_TPU_DRV)
CFG_DEPS += $(OBJ_TPU_DRV:.obj=.d)

# Library

$(TPU_DRIVERS_LIB) : $(OBJ_TPU_DRV)
	$(AR470) r $(TPU_DRIVERS_LIB) $(OBJ_TPU_DRV)

# Objects

$(OBJ_TPU_DRV) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$(COMPILER) $(TPU_DRIVERS_FLAGS) -fr$(@D) $<

