#!perl

# generate a dynamic Linker command file 
# PARAMETER ARE:
# 1 : Name of the Linker command file
# 2 : Name of the file with the parameter
# 

my ($cmd_file_temp,$tmp_file)=@ARGV;

open (TMP, "$tmp_file");
my $const_boot_lib = <TMP>;
my $bss_boot_lib = <TMP>;
my $bss_libs = <TMP>;
my $const_libs = <TMP>;
my $toolchoice_type = <TMP>;
close TMP;

# define the REPLACE STRINGS
my $const_boot_str="(CONST_BOOT_LIB)";
my $bss_boot_str="(BSS_BOOT_LIB)";
my $bss_str="(BSS_LIBS)";
my $const_str="(CONST_LIBS)";

# define some local variables
my $temp;
my @CMD;
my $line;

# determine the cmd file name
@CMD=split /.template/, $cmd_file_temp;
$cmd_file=$CMD[0].".cmd";

open (TMP1, ">$cmd_file");
open (TMP,$cmd_file_temp);
while ($line=<TMP>) {
	if ($line =~ m/$const_boot_str/g) {
		$line=mak_libs ($const_boot_lib)
	}
	if ($line =~ m/$bss_boot_str/g) {
		$line=mak_libs ($bss_boot_lib)
	}
	if ($line =~ m/$bss_str/g) {
		# insert the Libs
		$line=mak_libs ($bss_libs);
	}
	if ($line =~ m/$const_str/g) {
		$line=mak_libs ($const_libs)
	}

    # NEW COMPILER MANAGEMENT 
    # If use of VISUAL LINKER, needs to manage trampoline download.
    # Case of:
    #      - TOOL_CHOICE == 0 => compiler v1.22e with vlinker v1.9902
    if ($toolchoice_type == 0)  {
        $line =~ s(COMMENT2START)();
        $line =~ s(COMMENT2END)();    
    }
     
    if ($toolchoice_type == 3)  {
        $line =~ s(COMMENT2START)(/*);
        $line =~ s(COMMENT2END)(*/);
    }

	print TMP1 $line;
}
close TMP;
close TMP1;
unlink $tmp_file;

sub mak_libs
{
	my ($bss_libs) =@_;
	my @temp;
	@temp = split /=/, $bss_libs;
	$_="\t\t\t" . $temp[1];
	s/\) /)\n\t\t\t/g;
	$_ =~ tr /\"//d;
	return $_;
}

