#!/usr/bin/perl


if ($#ARGV == -1)
  {
  die "\nSyntax is gen_intram <C file (with extension)>\n\n";
  }

$#ARGV == 0 or die "Incorrect number of parameters";

$c_input_file = @ARGV[0];

# -------------------------------------------------------------------------------
# Remove .c extension and create the new filename for the processed file

@file_name = split /\.c/, $c_input_file;
$c_output_file = join ('', @file_name, "_intram.c");

print "Output file: $c_output_file\n";

# -------------------------------------------------------------------------------
# Generates the C file for internal RAM

open input_stream, $c_input_file
  or die "\n\n Input C file $C_input_file cannot be opened: $!\n";

open(output_stream,'>'.$c_output_file)
  or die "\n\nCan't open output file $C_output_file: $!";		

printf output_stream "/* ----- WARNING - File automatically generated - Do not modify it ----- */\n\n\n\n\n";

$d_internal_found = 0;

# Search for data
while(<input_stream>)
  {
  chomp $_;

  # Search for start comment
  if ( /#pragma DUPLICATE_FOR_INTERNAL_RAM_START/ )
    {
    # DEBUG
    #print "Found begin of string\n";
    $d_internal_found = 1;

    # Found begin internal RAM code, then output up to the end string
    while(<input_stream>)
      {
      chomp $_;
      if ( /#pragma DUPLICATE_FOR_INTERNAL_RAM_END/ )
        {
        # Found end of the internal RAM code, then search for another one
        # DEBUG
        #print "Found end of string\n";
        last;
        }
      else
        {
        printf output_stream "%s\n", $_;
        # DEBUG
        #print "Copied lines - $_\n";
        }
      }

    }
  }

close input_stream;
close output_stream;
