/************* Revision Controle System Header *************
 *                  GSM Layer 1 software 
 * L1GTT_VAREX.H
 *
 *        Filename %M%
 *  Copyright 2003 (C) Texas Instruments  
 *
 ************* Revision Controle System Header *************/


#if (L1_GTT == 1)

  #ifdef L1GTT_ASYNC_C
    // Every BUFFER are associated with a variable
    T_TTY_FIFO_struct *TTY_FIFO_1;
    T_TTY_FIFO_struct *TTY_FIFO_2;
    T_TTY_FIFO_struct *TTY_FIFO_3;
    T_TTY_FIFO_struct *TTY_FIFO_4;

    /* state variables for CTM transmitter and CTM receiver,respectively */
    tx_state_t   tx_state;
    rx_state_t   rx_state;
  
    /* State variables for the Baudot decoder and encoder,respectively. */
    baudot_decode_state_t baudot_decode_state;
    baudot_encode_state_t baudot_encode_state;
 
 
    /* Define fifo state variables */
    WORD16        baudotOutTTYCodeFifoLength = 50;
    fifo_state_t  baudotOutTTYCodeFifoState;
    fifo_state_t  signalFifoState;
    fifo_state_t  ctmOutTTYCodeFifoState;
    fifo_state_t  baudotToCtmFifoState;
    fifo_state_t  ctmToBaudotFifoState;

    WORD16     cntFramesSinceBurstInit          = 0;
    WORD16     cntSamplesSinceLastBypassFromCTM = 0;
    WORD16     cntTransmittedEnquiries          = 0;
    BOOL       ctmFromFarEndDetected     = false;
    BOOL       ctmCharacterTransmitted   = false;
    BOOL       enquiryFromFarEndDetected = false;
    BOOL       ctmTransmitterIsIdle      = true;
    BOOL       earlyMutingRequired       = false;
    BOOL       transparentMode           = false;

    /* Used to keep track of time since last Enquiry burst. 
     * Currently 1 cycle == 120 ms */
    WORD16     cyclesSinceLastEnquiryBurst      = 0; 

    /* Stores the output from baudot encoder in downlink */
    fifo_state_t  baudotCodeFifoState;    
    /* Store the output from CTM transmitter in uplink */
    fifo_state_t  ctmCodeULFifoState;     

    WORD16 cntSamplesSinceEnquiryDetected = 0;

    /* Shared global buffers between L1S and l1gtt_main_processing. */
    fifo_state_t  global_ul;
    fifo_state_t  global_dl;

    int init_complete = 0;

    /* Array containing silence data for muting uplink bypass path. */
    WORD16 silence_data[]={0,0,0,0,0,0,0,0};

    /* Global flag to indicate that uplink bypass path is to be muted */
    int begin_ul_bypasspath_mute = 0;
    
    /* Counter for keeping track of amount of silence written to DSP task 2. */
    int silence_pad_time = 0;

  #else
    extern T_TTY_FIFO_struct  *TTY_FIFO_1;
    extern T_TTY_FIFO_struct  *TTY_FIFO_2;
    extern T_TTY_FIFO_struct  *TTY_FIFO_3;
    extern T_TTY_FIFO_struct  *TTY_FIFO_4;
    extern tx_state_t    tx_state;
    extern rx_state_t   rx_state;
    extern baudot_decode_state_t baudot_decode_state;
    extern baudot_encode_state_t baudot_encode_state;
    extern WORD16        baudotOutTTYCodeFifoLength;
    extern fifo_state_t  baudotOutTTYCodeFifoState;
    extern fifo_state_t  signalFifoState;
    extern fifo_state_t  ctmOutTTYCodeFifoState;
    extern fifo_state_t  baudotToCtmFifoState;
    extern fifo_state_t  ctmToBaudotFifoState;
    extern WORD16     cntFramesSinceBurstInit;
    extern WORD16     cntSamplesSinceLastBypassFromCTM;
    extern WORD16     cntTransmittedEnquiries;
    extern BOOL       ctmFromFarEndDetected;
    extern BOOL       ctmCharacterTransmitted;
    extern BOOL       enquiryFromFarEndDetected;
    extern BOOL       ctmTransmitterIsIdle;
    extern BOOL       earlyMutingRequired;
    extern BOOL       transparentMode;
    extern WORD16     cyclesSinceLastEnquiryBurst; 
    extern fifo_state_t  baudotCodeFifoState;    
    extern fifo_state_t  ctmCodeULFifoState;     
    extern WORD16 cntSamplesSinceEnquiryDetected;
    extern fifo_state_t  global_ul;
    extern fifo_state_t  global_dl;
    extern int init_complete;
    extern WORD16 silence_data[];
    extern int begin_ul_bypasspath_mute;
    extern int silence_pad_time;
  #endif

#endif
