/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)              SOURCE : L1.H                 |
| AUTHOR  : CONDAT GmbH (nn)           VERSION: 01.00-01             |
| CREATED : 03.06.96                   STATE  : code                 |
+--------------------------------------------------------------------+

   MODULE  : L1

   PURPOSE : Definitions for the Protocol Stack Entity
             Layer 1


*/

#ifndef L1_H
#define L1_H

/*==== CONSTANTS ==================================================*/
#define DEBUG_PORT       (2)
#define DUART_PORT       (DEBUG_PORT - 1)
#define DEBUG_STACK_SIZE (1024)
#define LOG_STACK_SIZE (1024)
#define MONITOR_STACK_SIZE (1024)

/*==== TYPES ======================================================*/
/*==== EXPORT =====================================================*/
void l1_create_ISR (void);
void dl1_create_debug_task (void);

void dt_assert(int _expr, char *s);
void dt_error_message(char *s);
void l1a_task(unsigned arcg, void *argv);
unsigned get_arm_version (void);
unsigned get_dsp_version (void);


#endif


