/************* Revision Controle System Header *************
 *                  GSM Layer 1 software
 * L1AUDIO_CUST.H
 *
 *        Filename l1audio_cust.h
 *  Copyright 2003 (C) Texas Instruments  
 *
 ************* Revision Controle System Header *************/

#if (AUDIO_TASK == 1)

  #if (OP_RIV_AUDIO == 0)
    extern void vocoder_mute_dl (BOOL mute);
    extern void vocoder_mute_ul (BOOL mute);
  #endif
  
  #if (MELODY_E1)
    //----------------------------------------
    // Melody format E1 constant.
    //----------------------------------------

    // Number of oscillators (fixed value)
    #define SC_NUMBER_OSCILLATOR         8

    // Define the unit of the downloading time (fixed value)
    #define SC_MELO_DOWNLOAD_TIME_UNIT    4   // unit = 20ms

  #endif // MELODY_E1

  #if (VOICE_MEMO) || (SPEECH_RECO)
    //----------------------------------------
    // Voice memo constant.
    //----------------------------------------

    // Word to indicate the end of the speech data (fixed value).
    #define SC_VM_END_MASK        0xFBFF

  #endif // VOICE_MEMO || SPEECH_RECO

  #if (L1_VOICE_MEMO_AMR)
    //----------------------------------------
    // Voice memo amr constant.
    //----------------------------------------

    // Word to indicate the end of the speech data (fixed value).
    #define SC_VM_AMR_END_MASK_SIZE        1
    #define SC_VM_AMR_END_MASK          0xFF

  #endif // L1_VOICE_MEMO_AMR

  #if (SPEECH_RECO)
    //----------------------------------------
    // Speech recognition constant.
    //----------------------------------------

    // Error ID (fixed values)
    #define SC_NO_ERROR         0   // No error
    #define SC_BAD_ACQUISITION  1   // Bad acquisition of the word. The word is too long or too short
    #define SC_TIME_OUT         2   // The DSP task to acquire the word takes to much time
    #define SC_BAD_UPDATE       3   // Bad update of the model. The model from the database is too different
                                    // than the model built during the acquisition.
    #define SC_BAD_RECOGNITION  4   // This word is out of vocabulary or the best words are too close
    #define SC_CTO_WORD         5   // A word generated by the CTO algorithm is the best word.
    #define SC_CHECK_ERROR      6   // The best word isn't the word to update.

    // Time out (fixed values)
    #define SC_SR_AQUISITION_TIME_OUT    867  // acquisition time out in fn unit (3s).
    #define SC_SR_UPDATE_TIME_OUT        500  // update time out in fn unit.
    #define SC_SR_PROCESSING_TIME_OUT    500  // processing time out in fn unit.


    // CTO algorithm parameters (tuning value)
    #define SC_SR_MAX_WORDS_FOR_CTO  4   // Threshold to decide when the CTO algorithm is needed:
                                         // if the number of model is less 0r equal to this value, the CTO algo. is enabled.

    // model constant (fixed values)
    #define SC_SR_MODEL_FRAME_SIZE  16      // size of the model parameters per audio frames (20 ms).
    #define SC_SR_MODEL_API_SIZE    1041    // size of the model corrsponding to the longest possible word (1,3 second):
                                            // 16 words frames* 1,3s/20ms + 1 = 1041
                                            // the header word of the model gives the size of the model in model frame unit.
    #define SC_SR_MMI_DB_MODEL_SIZE SC_SR_MODEL_API_SIZE    // maximum size of the model in the MMI database.

    // speech constant (fixed values)
    #define SC_SR_SPEECH_FRAME_SIZE  20      // size of the speech samples per audio frams (20ms)

    #define SC_SR_SPEECH_WORD_SIZE                65  // maximum size in speech frame size unit of the word to acquire
    #define SC_SR_SPEECH_WORD_BEGIN_VAD_LATENCY   35  // time in speech frame size unit to detect that the word begins
    #define SC_SR_SPEECH_WORD_END_VAD_LATENCY     35  // time in speech frame size unit to detect that the word is finished
    #define SC_SR_SPEECH_WORD_BEGIN_MARGIN         5  // time in speech frame size unit to add a beginning margin of the word
    #define SC_SR_SPEECH_WORD_END_MARGIN           5  // time in speech frame size unit to add a end margin of the word
    #define SC_SR_SPEECH_ENDING_DONE_MARGING      20  // time in speech frame size unit to have the word done status after the word ending status.

    #define SC_SR_MMI_2_L1_SPEECH_SIZE (SC_SR_SPEECH_WORD_BEGIN_MARGIN + SC_SR_SPEECH_WORD_SIZE + SC_SR_SPEECH_WORD_END_VAD_LATENCY + SC_SR_SPEECH_ENDING_DONE_MARGING) * SC_SR_SPEECH_FRAME_SIZE
                                       // size of the speech buffer allocated by MMI to acquire the speech.
    #define SC_SR_MMI_DB_SPEECH_SIZE   (SC_SR_SPEECH_WORD_BEGIN_MARGIN + SC_SR_SPEECH_WORD_SIZE + SC_SR_SPEECH_WORD_END_MARGIN) * SC_SR_SPEECH_FRAME_SIZE + 1 // size of the speech buffer included in a MMI database
                                                                                                                                                              // "+1" is for the END voice memo mask.

    // DSP Out-Of-Vocabulary constant (tuning value)
    #define SC_SR_OOV_SFT_THR   10  // OOV rejection threhold (the lower more rejection)
                                    // if this value is equal to 0, ther's no rejection

  #endif // SPEECH_RECO

  #if (L1_NEW_AEC)
    // time interval between 2 AEC debug traces (in TDMA). Must be <= 127
    #define SC_AEC_VISIBILITY_INTERVAL 52
  #endif

  #if (FIR)
    // FIR indication (fixed values)
    #define DL_FIR      1   // The DL FIR must be updated
    #define UL_FIR      2   // The UL FIR must be updated
    #define UL_DL_FIR   3   // The UL&DL FIR must be updated

  #endif

  // List of the error returned by the Cust_get_pointer function
  #define DATA_AVAILABLE    0   // No error is occured
  #define SESSION_ERROR     1   // Wrong session id
  #define POINTER_ERROR     2   // Wrong ptr argument
  #define DATA_AVAIL_ERROR  3   // No more data available

  #if (AUDIO_MODE)
    #define GSM_ONLY        0   // GSM normal mode
    #define BT_CORDLESS     1   // Bluetooth cordless mode
    #define BT_HEADSET      2   // Bluetooth headset mode
  #endif

  #if (MELODY_E2)
    #define SC_AUDIO_MELODY_E2_MAX_NUMBER_OF_INSTRUMENT   8    // Maximum number of instruments allowed to play in thesame time
                                                               // (Fixed value)
    #define SC_AUDIO_MELODY_E2_MAX_SIZE_OF_INSTRUMENT     (3807 - C_DEBUG_BUFFER_SIZE)
                                                               // Melody E2 instrument wave table size in the API memory
                                                               // (fixed value)
    #define SC_AUDIO_MELODY_E2_MAX_SIZE_OF_DSP_TRACE      (C_DEBUG_BUFFER_SIZE + 1)
                                                               // DSP API buffer trace size (fixed value)

    // Note :the melody E2 instrument are overlayed with the DSP buffer trace. The size ofthe trace buffer can
    // change in order to increase the DSP tracability. In all case, the following rules need to be followed
    // (when melody E2 is activated):
         // size of the E2 instruments buffer + size of DSP trace buffer = 2049
         // size of the E2 instrument buffers > 1
         // size of DSP trace buffer > 1
  #endif
#endif // AUDIO_TASK

// Number of coefficient for each FIR (fixed value)
#define MAX_FIR_COEF  31

