/*                @(#) nom : certificate.c SID: 1.2 date : 02/17/03                           */
/* Filename:      certificate.c                                                         */
/* Version:       1.2                                                         */
/******************************************************************************
 *                   WIRELESS COMMUNICATION SYSTEM DEVELOPMENT
 *
 *             (C) 2002 Texas Instruments France. All rights reserved
 *
 *                          Author : Francois AMAND
 *
 *
 *  Important Note
 *  --------------
 *
 *  This S/W is a preliminary version. It contains information on a product 
 *  under development and is issued for evaluation purposes only. Features 
 *  characteristics, data and other information are subject to change.
 *
 *  The S/W is furnished under Non Disclosure Agreement and may be used or
 *  copied only in accordance with the terms of the agreement. It is an offence
 *  to copy the software in any way except as specifically set out in the 
 *  agreement. No part of this document may be reproduced or transmitted in any
 *  form or by any means, electronic or mechanical, including photocopying and
 *  recording, for any purpose without the express written permission of Texas
 *  Instruments Inc.
 *
 ******************************************************************************
 *
 *  FILE NAME: firmware.c
 *
 *
 *  PURPOSE:  Simulation of Firmware application located in FLASH.
 *            Used to generate COFF file with certificate management.
 *
 *
 *
 *  FILE REFERENCES:
 *
 *  Name                  IO      Description
 *  -------------         --      ---------------------------------------------
 *  
 *
 *
 *  EXTERNAL VARIABLES:
 *
 *  Source:
 *
 *  Name                  Type              IO   Description
 *  -------------         ---------------   --   ------------------------------
 *
 *
 *  EXTERNAL REFERENCES:
 *
 *  Name                Description
 *  ------------------  -------------------------------------------------------
 *
 *
 *
 *  ABNORMAL TERMINATION CONDITIONS, ERROR AND WARNING MESSAGES:
 *  
 *
 *
 *  ASSUMPTION, CONSTRAINTS, RESTRICTIONS:
 *  
 *
 *
 *  NOTES:
 *  
 *
 *
 *  REQUIREMENTS/FUNCTIONAL SPECIFICATION REFERENCES:
 *
 *
 *
 *
 *  DEVELOPMENT HISTORY:
 *
 *  Date        Name(s)         Version  Description
 *  ----------  --------------  -------  --------------------------------------
 *
 *
 *  ALGORITHM: 
 *
 *
 *****************************************************************************/

#include "l1sw.cfg"
#include "chipset.cfg"

#if (CHIPSET == 12)

#if (OP_L1_STANDALONE == 0)
  #include "main/sys_types.h"
#else
  #include "sys_types.h"
#endif


typedef unsigned char      UWORD8;
typedef unsigned short int UWORD16;
typedef unsigned long int  UWORD32;

typedef signed long int    WORD32;

typedef unsigned char      BOOLEAN;


#include "secure_types.h"


/*
 *  Certificate variable
 */
extern void ResetVector(void);
#pragma DATA_SECTION(d_firmware_certificate, ".cert")

volatile const T_MANUFACTURER_CERTIFICATE d_firmware_certificate =
              {
                (UWORD16)sizeof(T_MANUFACTURER_CERTIFICATE),    // Size of Certificate
                (UWORD8)C_CERTTYPE_MAN,                         // Type of Certificate
                (UWORD8)C_DEBUGREQUEST,                         // Confidentiality request
                (UWORD32)0x00000000L,                           // Address of code
                (UWORD32)0x00000000L,                           // Size of code : To be defined by tool
                (UWORD32)ResetVector,                           // Entry point address
                // Manufacturer Public key : To be defined by tool
                {
                  //Public Modulus
                  {
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L
                  },
                  //Public Modulus length in bytes
                  (UWORD32)1024/8,
                  //Public Exponent
                  0x00000000L,
                },
                // Originator Public key : To be defined by tool
                {
                  //Public Modulus
                  {
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L
                  },
                  //Public Modulus length in bytes
                  (UWORD32)1024/8,
                  //Public Exponent
                  0x00000000L,
                },
                // Originator Public key Signature
                {
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                    0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L
                },
                // Software Signature
                {
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L
                },
                // Configuration parameters
                {
                  0x0EA5,                     // CONF_CS5 register
                  0x7BC2,                     // EXWS_CS5 register
                  0x0000,                     // EX_CTRL register
                  C_CSIMGNOREQUEST,           // CS image request
                  0x01000000L,                // FLASH size in bytes
                  1                           // Granularity in word
                },
                // Certificate Signature
                {
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L,
                  0x00000000L, 0x00000000L, 0x00000000L, 0x00000000L
                }
              };

#endif /* (CHIPSET == 12) */
