/*                @(#) nom : sys_memif.h SID: 1.2 date : 05/23/03             */
/* Filename:      sys_memif.h                                                 */
/* Version:       1.2                                                         */
/******************************************************************************
 *                   WIRELESS COMMUNICATION SYSTEM DEVELOPMENT
 *
 *             (C) 2002 Texas Instruments France. All rights reserved
 *
 *                          Author : Francois AMAND
 *
 *
 *  Important Note
 *  --------------
 *
 *  This S/W is a preliminary version. It contains information on a product 
 *  under development and is issued for evaluation purposes only. Features 
 *  characteristics, data and other information are subject to change.
 *
 *  The S/W is furnished under Non Disclosure Agreement and may be used or
 *  copied only in accordance with the terms of the agreement. It is an offence
 *  to copy the software in any way except as specifically set out in the 
 *  agreement. No part of this document may be reproduced or transmitted in any
 *  form or by any means, electronic or mechanical, including photocopying and
 *  recording, for any purpose without the express written permission of Texas
 *  Instruments Inc.
 *
 ******************************************************************************
 *
 *  FILE NAME: sys_memif.h
 *
 *
 *  PURPOSE:  Include file to use the ARM memory interface drivers for CALYPSO 
 *            PLUS.
 *            The drivers allows ARM memory interface configuration and
 *            control.
 *
 *
 *  FILE REFERENCES:
 *
 *  Name                  IO      Description
 *  -------------         --      ---------------------------------------------
 *  
 *
 *
 *  EXTERNAL VARIABLES:
 *
 *  Source:
 *
 *  Name                  Type              IO   Description
 *  -------------         ---------------   --   ------------------------------
 *
 *
 *
 *  EXTERNAL REFERENCES:
 *
 *  Name                Description
 *  ------------------  -------------------------------------------------------
 *
 *
 *
 *  ABNORMAL TERMINATION CONDITIONS, ERROR AND WARNING MESSAGES:
 *  
 *
 *
 *  ASSUMPTION, CONSTRAINTS, RESTRICTIONS:
 *  
 *
 *
 *  NOTES:
 *  
 *
 *
 *  REQUIREMENTS/FUNCTIONAL SPECIFICATION REFERENCES:
 *
 *
 *
 *
 *  DEVELOPMENT HISTORY:
 *
 *  Date         Name(s)         Version  Description
 *  -----------  --------------  -------  -------------------------------------
 *  11-Oct-2002  Francois AMAND  0.0.1    First implementation
 *  24-Feb-2003  G.Leterrier     0.0.2    change include name for mapping definition
 *  25 Feb-2003  G.Leterrier     0.0.3    Change MACRO to take in account reserved bit in registers
 *
 *  ALGORITHM: 
 *
 *
 *****************************************************************************/


#ifndef __SYS_MEMIF_H__
  #define __SYS_MEMIF_H__

  #include "l1sw.cfg"
  #include "chipset.cfg"
  
  #if (CHIPSET == 12)

    #if (OP_L1_STANDALONE == 0)
      #include "main/sys_types.h"
    #else
      #include "sys_types.h"
    #endif

    #include "sys_map.h"
  
    /****************************************************************************
     *                            CONSTANT DEFINITION
     ***************************************************************************/
  
    /*
     *  Chip-select offset definition
     */
    #define C_MEMIF_CS0_OFFSET  0
    #define C_MEMIF_CS1_OFFSET  1
    #define C_MEMIF_CS2_OFFSET  2
    #define C_MEMIF_CS3_OFFSET  3
    #define C_MEMIF_CS4_OFFSET  4
    #define C_MEMIF_CS5_OFFSET  5
  
    #define C_MEMIF_NB_EXTERNAL_CS  6
    
    #define C_MEMIF_CS_SIZE_MAX_MB  64
    
    #define C_MEMIF_INTERNAL_SRAM_START_ADDR      0x08000000
  
    /*
     *  Registers offset definition
     */
    #define C_MEMIF_CONF_CSX_OFFSET(cs_index)     (0x00 + 2 * cs_index)
    #define C_MEMIF_EXWS_CSX_OFFSET(cs_index)     (0x20 + 2 * cs_index)
    #define C_MEMIF_DCCTRL_CSX_OFFSET(cs_index)   (0x30 + 2 * cs_index)
    #define C_MEMIF_API_RHEA_CTRL_OFFSET          0x0E
    #define C_MEMIF_EX_CTRL_OFFSET                0x10
    #define C_MEMIF_DSPMS_OFFSET                  0x2E
  
  
    /*
     *  Registers address definition
     */
    #define C_MEMIF_CONF_CSX_REG(cs_index)    * (volatile SYS_UWORD16 *) (C_MAP_MEMIF_BASE + C_MEMIF_CONF_CSX_OFFSET(cs_index))
    #define C_MEMIF_EXWS_CSX_REG(cs_index)    * (volatile SYS_UWORD16 *) (C_MAP_MEMIF_BASE + C_MEMIF_EXWS_CSX_OFFSET(cs_index))
    #define C_MEMIF_DCCTRL_CSX_REG(cs_index)  * (volatile SYS_UWORD16 *) (C_MAP_MEMIF_BASE + C_MEMIF_DCCTRL_CSX_OFFSET(cs_index))
    #define C_MEMIF_API_RHEA_CTRL_REG         * (volatile SYS_UWORD16 *) (C_MAP_MEMIF_BASE + C_MEMIF_API_RHEA_CTRL_OFFSET)
    #define C_MEMIF_EX_CTRL_REG               * (volatile SYS_UWORD16 *) (C_MAP_MEMIF_BASE + C_MEMIF_EX_CTRL_OFFSET)
    #define C_MEMIF_DSPMS_REG                 * (volatile SYS_UWORD16 *) (C_MAP_MEMIF_BASE + C_MEMIF_DSPMS_OFFSET)
  
  
  
    /*
     *  CONF_CSx register definition
     */
    #define C_MEMIF_CONF_CSX_MASK   0x0100
    /* Bits position in the register */
    #define C_MEMIF_CONF_WS_POS     0
    #define C_MEMIF_CONF_DVS_POS    5
    #define C_MEMIF_CONF_WE_POS     7
    #define C_MEMIF_CONF_DC_POS     9
    #define C_MEMIF_CONF_RODC_POS   12
    #define C_MEMIF_CONF_WRDC_POS   13
    #define C_MEMIF_CONF_WWS_POS    14
  
    /* DVS bits definition */
    #define C_MEMIF_DVS_8           0     /* device size = 8 bits */
    #define C_MEMIF_DVS_16          1     /* device size = 16 bits */
    #define C_MEMIF_DVS_32          2     /* device size = 32 bits */
  
    /* WE bits definition */
    #define C_MEMIF_WRITE_DIS       0     /* write disable */
    #define C_MEMIF_WRITE_EN        1     /* write enable */
  
    /* RODC bits definition */
    #define C_MEMIF_RODC_DIS        0     /* Read Only Dummy Cycle mode Enable */
    #define C_MEMIF_RODC_EN         1     /* Read Only Dummy Cycle mode Disable */
  
    /* WRDC bits definition */
    #define C_MEMIF_WRDC_DIS        0     /* Write-Read Insertion Dummy Cycle mode Enable */
    #define C_MEMIF_WRDC_EN         1     /* Write-Read Insertion Dummy Cycle mode Disable */
  
    /* WWS bits definition */
    #define C_MEMIF_WWS_VALUE_DIS   1     /* WRSS value use for write and WS for read access */
    #define C_MEMIF_WWS_VALUE_EN    0     /* WS value use for write and read access */
  
  
  
    /*
     *  EXWS_CSx register definition
     */
    #define C_MEMIF_EXWS_MASK       0x0038
    /* Bits position in the register */
    #define C_MEMIF_EXWS_PME_POS    0
    #define C_MEMIF_EXWS_PMS_POS    1
    #define C_MEMIF_EXWS_PMWS_POS   6
    #define C_MEMIF_EXWS_WRWS_POS   11
  
    /* PME bits definition */
    #define C_MEMIF_PAGE_MODE_DIS   0     /* Page mode disable */
    #define C_MEMIF_PAGE_MODE_EN    1     /* Page mode enable */
  
    /* PMS bits definition */
    #define C_MEMIF_PMS_2B          0     /* Page size = 2 bytes */
    #define C_MEMIF_PMS_4B          1     /* Page size = 4 bytes */
    #define C_MEMIF_PMS_8B          2     /* Page size = 8 bytes */
    #define C_MEMIF_PMS_16B         3     /* Page size = 16 bytes */
  
  
  
    /*
     *  DCCTRL_CSx register definition
     */
    /* Bits position in the register */
    #define C_MEMIF_DCCTRL_DCECS0_POS   0
    #define C_MEMIF_DCCTRL_DCECS1_POS   1
    #define C_MEMIF_DCCTRL_DCECS2_POS   2
    #define C_MEMIF_DCCTRL_DCECS3_POS   3
    #define C_MEMIF_DCCTRL_DCECS4_POS   4
    #define C_MEMIF_DCCTRL_DCECS5_POS   5
  
    /* DCECSx bits definition */
    #define C_MEMIF_DCECS_DIS           0     /* No DC */
    #define C_MEMIF_DCECS_EN            1     /* Insert Dummy Cycle if previous CSn is CSn */
  
  
  
    /*
     *  EX_CTRL register definition
     */
    #define C_MEMIF_EX_CTRL_MASK                 0x0780
    /* Bits position in the register */
    #define C_MEMIF_EX_CTRL_WSR_POS             0
    #define C_MEMIF_EX_CTRL_CTRL_WS0_POS        1
    #define C_MEMIF_EX_CTRL_CTRL_WS1_POS        2
    #define C_MEMIF_EX_CTRL_CTRL_WS2_POS        3
    #define C_MEMIF_EX_CTRL_CTRL_WS3_POS        4
    #define C_MEMIF_EX_CTRL_CTRL_WS4_POS        5
    #define C_MEMIF_EX_CTRL_CTRL_WS5_POS        6
    #define C_MEMIF_EX_CTRL_DISABLE_DU_POS      11
    #define C_MEMIF_EX_CTRL_CS_MODE_POS         12
    #define C_MEMIF_EX_CTRL_CS_MODE_EN_POS      14
    #define C_MEMIF_EX_CTRL_EX_PAGEM_POS        15
  
    /* DISABLE_DU bit definition */
    #define C_MEMIF_EX_CTRL_DU_EN               0   /* DU capture is enabled */
    #define C_MEMIF_EX_CTRL_DU_DIS              1   /* DU capture is disabled */
  
    /* CS_MODE bits definition */
    #define C_MEMIF_EX_CTRL_CS_MODE_MASK        0x0003
    
    #define C_MEMIF_EX_CTRL_CS_MODE_0           0   /* CS_MODE configuration 0 */
    #define C_MEMIF_EX_CTRL_CS_MODE_1           1   /* CS_MODE configuration 1 */
    #define C_MEMIF_EX_CTRL_CS_MODE_2           2   /* CS_MODE configuration 2 */
    #define C_MEMIF_EX_CTRL_CS_MODE_3           3   /* CS_MODE configuration 3 */
  
    /* CS_MODE_EN bit definition */
    #define C_MEMIF_EX_CTRL_CS_MODE_FREEZE      1   /* Freeze CS_MODE configuration and access to CS_MODE_EN bit */
  
    /* EX_PAGEM bit definition */
    #define C_MEMIF_EX_CTRL_EX_PAGEM_DIS        0   /* Disable extended page-mode */
    #define C_MEMIF_EX_CTRL_EX_PAGEM_EN         1   /* Enable extended page-mode */
  
  
  
    /*
     *  API_RHEA_CTRL register definition
     */
    #define C_MEMIF_API_RHEA_CTRL_MASK          0x0015
    /* Bits position in the register */
    #define C_MEMIF_API_RHEA_CTRL_ADAPT0_POS    1
    #define C_MEMIF_API_RHEA_CTRL_ADAPT1_POS    3
    #define C_MEMIF_API_RHEA_CTRL_ADAPTAPI_POS  5
    #define C_MEMIF_API_RHEA_CTRL_DEBUG_POS     6
  
    /* ADAPT0, ADAPT1 and ADAPTAPI bits definition */
    #define C_MEMIF_API_RHEA_NO_ADAPT           0   /* no memory adaptation */
    #define C_MEMIF_API_RHEA_ADAPT              1   /* memory adaptation */
  
    /* DEBUG bits definition */
    #define C_MEMIF_API_RHEA_NO_DEBUG           0   /* no ARM address can be observed */
    #define C_MEMIF_API_RHEA_DEBUG              1   /* ARM address can be observed */
  
  
  
    /*
     *  DSPMS register definition
     */
    /* Bits position in the register */
    #define C_MEMIF_DSPMS_POS                   0
  
    /* DSPMS bit definition */
    #define C_MEMIF_DSPMS_MASK                  0x0003
    #define C_MEMIF_DSPMS_0MBITS_TO_DSP         0x0000
    #define C_MEMIF_DSPMS_0_5MBITS_TO_DSP       0x0001
    



    /****************************************************************************
     *                            MACRO DEFINITION
     ***************************************************************************/
  
    #define F_MEMIF_ENABLE_EXTENDED_PAGE_MODE     C_MEMIF_EX_CTRL_REG |= (C_MEMIF_EX_CTRL_EX_PAGEM_EN << C_MEMIF_EX_CTRL_EX_PAGEM_POS)
  
    #define F_MEMIF_DU_ENABLE                     C_MEMIF_EX_CTRL_REG &= ~(C_MEMIF_EX_CTRL_DU_DIS << C_MEMIF_EX_CTRL_DISABLE_DU_POS)
    #define F_MEMIF_DU_DISABLE                    C_MEMIF_EX_CTRL_REG |=  (C_MEMIF_EX_CTRL_DU_DIS << C_MEMIF_EX_CTRL_DISABLE_DU_POS)
  
  
    #define F_MEMIF_DEBUG_FREEZE                  C_MEMIF_API_RHEA_CTRL_REG &= ~(C_MEMIF_API_RHEA_DEBUG <<C_MEMIF_API_RHEA_CTRL_DEBUG_POS)

    /****************************************************************************
     *                            STRUCTURE DEFINITION
     ***************************************************************************/
  
    typedef struct {
      /* CONF_CSx register configuration */
      SYS_UWORD8  d_ws;
      SYS_UWORD8  d_dvs;
      SYS_UWORD8  d_we;
      SYS_UWORD8  d_dc;
      SYS_UWORD8  d_rodc;
      SYS_UWORD8  d_wrdc;
      SYS_UWORD8  d_wws;
  
      /* EXWS_CSx register configuration */
      SYS_UWORD8  d_pme;
      SYS_UWORD8  d_pms;
      SYS_UWORD8  d_pmws;
      SYS_UWORD8  d_wrws;
      
      /* DCCTRL_CSx register configuration */
      SYS_UWORD8  d_dcecs0;
      SYS_UWORD8  d_dcecs1;
      SYS_UWORD8  d_dcecs2;
      SYS_UWORD8  d_dcecs3;
      SYS_UWORD8  d_dcecs4;
      SYS_UWORD8  d_dcecs5;

    } T_MEMIF_CS_CONFIG;
    


    /****************************************************************************
     *                            PROTOTYPE DEFINITION
     ***************************************************************************/
    
    void f_memif_init_cs(SYS_UWORD8 d_cs, T_MEMIF_CS_CONFIG *p_cs_config);
  
    void f_memif_init_api_rhea_ctrl(SYS_UWORD8 d_adap0,
                                    SYS_UWORD8 d_adap1,
                                    SYS_UWORD8 d_adap_api,
                                    SYS_UWORD8 d_debug);
  
    void f_memif_du_enable(void);

    void f_memif_du_disable(void);
  
    void f_memif_extended_page_mode_enable(void);
    
    void f_memif_shared_sram_allocation(SYS_UWORD16 d_allocation_cfg);

    void f_memif_cs_mode(SYS_UWORD16 d_cs_mode_cfg);

    void f_memif_debug_freeze(void);

  #endif /* (CHIPSET == 12) */

#endif /* __SYS_MEMIF_H__ */
