/*                @(#) nom : sys_memif.c SID: 1.2 date : 05/23/03             */
/* Filename:      sys_memif.c                                                 */
/* Version:       1.2                                                         */
/******************************************************************************
 *                   WIRELESS COMMUNICATION SYSTEM DEVELOPMENT
 *
 *             (C) 2002 Texas Instruments France. All rights reserved
 *
 *                          Author : Francois AMAND
 *
 *
 *  Important Note
 *  --------------
 *
 *  This S/W is a preliminary version. It contains information on a product 
 *  under development and is issued for evaluation purposes only. Features 
 *  characteristics, data and other information are subject to change.
 *
 *  The S/W is furnished under Non Disclosure Agreement and may be used or
 *  copied only in accordance with the terms of the agreement. It is an offence
 *  to copy the software in any way except as specifically set out in the 
 *  agreement. No part of this document may be reproduced or transmitted in any
 *  form or by any means, electronic or mechanical, including photocopying and
 *  recording, for any purpose without the express written permission of Texas
 *  Instruments Inc.
 *
 ******************************************************************************
 *
 *  FILE NAME: sys_memif.c
 *
 *
 *  PURPOSE:  Drivers to be used for ARM memory interface configuration and
 *            control for CALYPSO PLUS.
 *
 *
 *  FILE REFERENCES:
 *
 *  Name                  IO      Description
 *  -------------         --      ---------------------------------------------
 *  
 *
 *
 *  EXTERNAL VARIABLES:
 *
 *  Source:
 *
 *  Name                  Type              IO   Description
 *  -------------         ---------------   --   ------------------------------
 *
 *
 *
 *  EXTERNAL REFERENCES:
 *
 *  Name                Description
 *  ------------------  -------------------------------------------------------
 *
 *
 *
 *  ABNORMAL TERMINATION CONDITIONS, ERROR AND WARNING MESSAGES:
 *  
 *
 *
 *  ASSUMPTION, CONSTRAINTS, RESTRICTIONS:
 *  
 *
 *
 *  NOTES:
 *  
 *
 *
 *  REQUIREMENTS/FUNCTIONAL SPECIFICATION REFERENCES:
 *
 *
 *
 *
 *  DEVELOPMENT HISTORY:
 *
 *  Date         Name(s)         Version  Description
 *  -----------  --------------  -------  -------------------------------------
 *  11-Oct-2002  Francois AMAND  0.0.1    First implementation
 *  25-Feb-2003  G.Leterrier     0.0.2    Modification for reserved bit management 
 *                                        f_memif_init_cs
 *                                        f_memif_init_api_rhea_ctrl
 *  26-Feb-2003 G.Leterrier               Disable page mode before re-configuration
 *
 *  ALGORITHM: 
 *
 *
 *****************************************************************************/

#include "l1sw.cfg"
#include "chipset.cfg"

#if (CHIPSET == 12)

  #include "board.cfg"

  #if (OP_L1_STANDALONE == 0)
    #include "main/sys_types.h"
  #else
    #include "sys_types.h"
  #endif
  #include "sys_memif.h"
  
  
  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_init_cs
   *      Configure the memory features connected on the chip-select cs.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument       Type                   IO  Description
   *  ------------   -------------------    --  ---------------------------------
   *  d_cs           SYS_UWORD8             I   Chip-select number
   *  p_cs_config    T_MEMIF_CS_CONFIG *    I   Configuration to apply to the
   *                                            chip-select.
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_init_cs(SYS_UWORD8 d_cs, T_MEMIF_CS_CONFIG *p_cs_config) {
  
    SYS_UWORD16 d_conf_csx_reg,d_exws_csx_reg;

    /* save value of reserved bit */

    d_conf_csx_reg = C_MEMIF_CONF_CSX_REG(d_cs);
    d_conf_csx_reg &= C_MEMIF_CONF_CSX_MASK;

    d_exws_csx_reg = C_MEMIF_EXWS_CSX_REG(d_cs);
    d_exws_csx_reg &= C_MEMIF_EXWS_MASK;


    /* disable page mode before change of configuration */
    C_MEMIF_EXWS_CSX_REG(d_cs) &= ~(C_MEMIF_PAGE_MODE_EN);


    /*
     *  Configure CONF_CSx register
     */
    C_MEMIF_CONF_CSX_REG(d_cs) = (p_cs_config->d_ws   << C_MEMIF_CONF_WS_POS)   | 
                                 (p_cs_config->d_dvs  << C_MEMIF_CONF_DVS_POS)  | 
                                 (p_cs_config->d_we   << C_MEMIF_CONF_WE_POS)   | 
                                 (p_cs_config->d_dc   << C_MEMIF_CONF_DC_POS)   | 
                                 (p_cs_config->d_rodc << C_MEMIF_CONF_RODC_POS) | 
                                 (p_cs_config->d_wrdc << C_MEMIF_CONF_WRDC_POS) | 
                                 (p_cs_config->d_wws  << C_MEMIF_CONF_WWS_POS)  | d_conf_csx_reg;
  
    /*
     *  Configure EXWS_CSx register
     */
    C_MEMIF_EXWS_CSX_REG(d_cs) = (p_cs_config->d_pme  << C_MEMIF_EXWS_PME_POS)  | 
                                 (p_cs_config->d_pms  << C_MEMIF_EXWS_PMS_POS)  | 
                                 (p_cs_config->d_pmws << C_MEMIF_EXWS_PMWS_POS) | 
                                 (p_cs_config->d_wrws << C_MEMIF_EXWS_WRWS_POS) | d_exws_csx_reg;
  
    /*
     *  Configure DCCTRL_CSx register
     */
    C_MEMIF_DCCTRL_CSX_REG(d_cs) = (p_cs_config->d_dcecs0 << C_MEMIF_DCCTRL_DCECS0_POS) |
                                   (p_cs_config->d_dcecs1 << C_MEMIF_DCCTRL_DCECS1_POS) |
                                   (p_cs_config->d_dcecs2 << C_MEMIF_DCCTRL_DCECS2_POS) |
                                   (p_cs_config->d_dcecs3 << C_MEMIF_DCCTRL_DCECS3_POS) |
                                   (p_cs_config->d_dcecs4 << C_MEMIF_DCCTRL_DCECS4_POS) |
                                   (p_cs_config->d_dcecs5 << C_MEMIF_DCCTRL_DCECS5_POS); 
  } /* f_memif_init_cs() */
  
  
  
  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_init_api_rhea_ctrl
   *    Configure the API_RHEA_CTRL register.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument     Type         IO  Description
   *  ----------   ----------   --  -------------------------------------------
   *  d_adap0      SYS_UWORD8   I   Rhea strobe 0 access size adaptation enable
   *  d_adap1      SYS_UWORD8   I   Rhea strobe 1 access size adaptation enable
   *  d_adap_api   SYS_UWORD8   I   API access size adaptation enable
   *  d_debug      SYS_UWORD8   I   ARM address debug enable/disable
   *
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_init_api_rhea_ctrl(SYS_UWORD8 d_adap0,
                                  SYS_UWORD8 d_adap1,
                                  SYS_UWORD8 d_adap_api,
                                  SYS_UWORD8 d_debug) {
    SYS_UWORD16 d_api_rhea_ctrl;

    d_api_rhea_ctrl = C_MEMIF_API_RHEA_CTRL_REG;
    d_api_rhea_ctrl &= C_MEMIF_API_RHEA_CTRL_MASK;

  
    C_MEMIF_API_RHEA_CTRL_REG = (d_adap0    << C_MEMIF_API_RHEA_CTRL_ADAPT0_POS)   | 
                                (d_adap1    << C_MEMIF_API_RHEA_CTRL_ADAPT1_POS)   | 
                                (d_adap_api << C_MEMIF_API_RHEA_CTRL_ADAPTAPI_POS) | 
                                (d_debug    << C_MEMIF_API_RHEA_CTRL_DEBUG_POS)    | d_api_rhea_ctrl;
  
  } /* f_memif_init_api_rhea_ctrl() */
  
  
/******************************************************************************
   *
   *  FUNCTION NAME: f_memif_debug_freeze
   *    Freeze externa memory interface during internal access
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument     Type         IO  Description
   *  ----------   ----------   --  -------------------------------------------
   *
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_debug_freeze(void) {
  
    F_MEMIF_DEBUG_FREEZE;
  
  } /* f_memif_debug_freeze() */
  

  
  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_du_enable
   *    Enable Debug Unit capture.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument     Type         IO  Description
   *  ----------   ----------   --  -------------------------------------------
   *
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_du_enable(void) {
  
    F_MEMIF_DU_ENABLE;
  
  } /* f_memif_du_enable() */
  
  
  
  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_du_disable
   *    Disable Debug Unit capture.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument     Type         IO  Description
   *  ----------   ----------   --  -------------------------------------------
   *
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_du_disable(void) {
  
    F_MEMIF_DU_DISABLE;
  
  } /* f_memif_du_disable() */
  
  
  
  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_extended_page_mode_enable
   *    Enable Extended Page Mode feature, which locks the CS in active state
   *    when accessing internal memory bus.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument     Type         IO  Description
   *  ----------   ----------   --  -------------------------------------------
   *
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_extended_page_mode_enable(void) {
  
    F_MEMIF_ENABLE_EXTENDED_PAGE_MODE;
  
  } /* f_memif_extended_page_mode_enable() */
  
  
  
  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_shared_sram_allocation
   *    Configure the Shared SRAM allocation.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument           Type          IO  Description
   *  ----------------   -----------   --  ------------------------------------
   *  d_allocation_cfg   SYS_UWORD16   I   Shared SRAM allocation configuration
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_shared_sram_allocation(SYS_UWORD16 d_allocation_cfg) {
    SYS_UWORD16 d_dspms_reg = C_MEMIF_DSPMS_REG;

    d_dspms_reg &= ~C_MEMIF_DSPMS_MASK;
    
    d_dspms_reg |= (d_allocation_cfg & C_MEMIF_DSPMS_MASK) << C_MEMIF_DSPMS_POS;

    C_MEMIF_DSPMS_REG = d_dspms_reg;
  } /* f_memif_shared_sram_allocation() */



  /******************************************************************************
   *
   *  FUNCTION NAME: f_memif_cs_mode
   *    Configure the chip-select size.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument           Type          IO  Description
   *  ----------------   -----------   --  ------------------------------------
   *  d_cs_mode_cfg      SYS_UWORD16   I   Chip-select size configuration
   *
   * RETURN VALUE: None
   *
   *****************************************************************************/
  
  void f_memif_cs_mode(SYS_UWORD16 d_cs_mode_cfg) {
    SYS_UWORD16 d_ex_ctrl_reg = C_MEMIF_EX_CTRL_REG;

    d_ex_ctrl_reg &= ~(C_MEMIF_EX_CTRL_CS_MODE_MASK << C_MEMIF_EX_CTRL_CS_MODE_POS);
    
    d_ex_ctrl_reg |= (d_cs_mode_cfg & C_MEMIF_EX_CTRL_CS_MODE_MASK) << C_MEMIF_EX_CTRL_CS_MODE_POS;

    C_MEMIF_EX_CTRL_REG = d_ex_ctrl_reg;
  } /* f_memif_cs_mode() */



#endif /* (CHIPSET == 12) */
