#
#       Makefile for basic drivers (ARM compiler)
#
#       Copyright (c) Texas Instruments 2002
#
#               Author: Laurent Sollier
#       Date : 17 May 2002

# Compilation flags
DRVC_DBG          := $(NODBG)    # Debug symbolic option

DRIVERS_FLAGS     := $(DRVC_DBG) -mn $(INL) $(16INST) -o $(ALGN) $(CFLAGSDRIVERS)
CFLAGS32          := $(DRVC_DBG) $(INL) -o $(ALGN) $(CFLAGSDRIVERS)

WIN_DRIVERS_FLAGS := $($(TP)CFLAGS) $(CFLAGSDRIVERS)
WIN_CFLAGS32      := $($(TP)CFLAGS) $(CFLAGSDRIVERS)

#For ABB
ABB_FLAGS   := $(DRVC_DBG) $(16INST) -mn $(CFLAGSDRIVERS)

ifeq ($(OP_L1_STANDALONE), 0)
ifeq ($(SRVC),0)
  ABB_FLAGS += -dIDS=0
else
  ABB_FLAGS += -dIDS=1
endif
endif

# Libraries definition
DRIVER_FLASH   := $(OUT_LIB_DIR)/drivers_flash.lib
DRIVER_INT_RAM := $(OUT_LIB_DIR)/drivers_int_ram.lib
NIQ32_INT_RAM  := $(OUT_LIB_DIR)/niq32_int_ram.lib
LIB_ABB        := $(OUT_LIB_DIR)/abb.lib
CFG_LIBS       += $(DRIVER_FLASH) $(DRIVER_INT_RAM) $(NIQ32_INT_RAM) $(LIB_ABB)

# Source definition
SRC_DRIVER_FLASH += $(DRIVERS_CORE_DIR)/dsp_dwnld/leadapi.c    \
                    $(DRIVERS_CORE_DIR)/inth/niq.c             \
                    $(DRIVERS_CORE_DIR)/uart/uart.c            \
                    $(DRIVERS_CORE_DIR)/inth/inth.c            \
                    $(DRIVERS_CORE_DIR)/timer/timer.c          \
                    $(DRIVERS_CORE_DIR)/timer/timer1.c         \
                    $(DRIVERS_CORE_DIR)/timer/timer2.c         \
                    $(DRIVERS_CORE_DIR)/timer/timer_sec.c      \
                    $(DRIVERS_CORE_DIR)/security/certificate.c
                    
ifeq ($(OP_L1_STANDALONE), 1)
  SRC_DRIVER_FLASH += $(DRIVERS_CORE_DIR)/uart/serialswitch_core.c                    
endif

SRC_ABB_CORE     += $(DRIVERS_CORE_DIR)/spi/spi_drv.c          \
                    $(DRIVERS_CORE_DIR)/abb/abb.c              \
                    $(DRIVERS_CORE_DIR)/abb/abb_core_inth.c

ifeq ($(CHIPSET),12)
  SRC_DRIVER_FLASH += $(DRIVERS_CORE_DIR)/dma/sys_dma.c         \
                      $(DRIVERS_CORE_DIR)/dma/sys_dma_it.c      \
                      $(DRIVERS_CORE_DIR)/inth/sys_inth.c       \
                      $(DRIVERS_CORE_DIR)/inth/sys_inth32.c     \
                      $(DRIVERS_CORE_DIR)/memif/sys_memif.c
endif

ifeq ($(CHIPSET),12)
  SRC_ASM_DRIVER_INT_RAM += $(DRIVERS_CORE_DIR)/clkm/sys_wait_clkm.s
endif

ifeq ($(findstring 1,$(TI_PROFILER) $(TI_NUC_MONITOR)),1)
   SRC_NIQ32_INT_RAM += $(DRIVERS_CORE_DIR)/inth/niq32.c
else
   SRC_DRIVER_FLASH += $(DRIVERS_CORE_DIR)/inth/niq32.c
endif

ifeq ($(BOARD),34)
  SRC_DRIVER_INT_RAM += $(DRIVERS_CORE_DIR)/clkm/clkm.c         \
                        $(DRIVERS_CORE_DIR)/armio/armio.c
else
  ifeq ($(BOARD),35)
    SRC_DRIVER_INT_RAM += $(DRIVERS_CORE_DIR)/clkm/clkm.c       \
                          $(DRIVERS_CORE_DIR)/armio/armio.c
  else
    SRC_DRIVER_FLASH += $(DRIVERS_CORE_DIR)/clkm/clkm.c         \
                        $(DRIVERS_CORE_DIR)/armio/armio.c
  endif
endif

# Objects definition
OBJ_DRIVER_FLASH := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(SRC_DRIVER_FLASH)))
CFG_OBJS += $(OBJ_DRIVER_FLASH)
CFG_DEPS += $(OBJ_DRIVER_FLASH:.obj=.d)

OBJ_DRIVER_INT_RAM := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(SRC_DRIVER_INT_RAM)))
OBJ_ASM_DRIVER_INT_RAM := $(patsubst ../%.s,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.s,$(SRC_ASM_DRIVER_INT_RAM)))
CFG_OBJS += $(OBJ_DRIVER_INT_RAM) $(OBJ_ASM_DRIVER_INT_RAM)
CFG_DEPS += $(OBJ_DRIVER_INT_RAM:.obj=.d)

OBJ_NIQ32_INT_RAM:= $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(SRC_NIQ32_INT_RAM)))
CFG_OBJS += $(OBJ_NIQ_32_INT_RAM)
CFG_DEPS += $(OBJ_NIQ_32_INT_RAM:.obj=.d)

OBJ_ABB_CORE:= $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(SRC_ABB_CORE)))
CFG_OBJS += $(OBJ_ABB_CORE)
CFG_DEPS += $(OBJ_ABB_CORE:.obj=.d)

#Sources that needs to be compiled into 32 bit state code
#They still must be added to the SRC_DRIVER_FLASH due to generation of libraries
SRC32   += $(DRIVERS_CORE_DIR)/inth/niq32.c $(DRIVERS_CORE_DIR)/inth/sys_inth32.c
OBJ32   := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$(SRC32)))


######## LIBRARIES #############
$(DRIVER_FLASH) : $(OBJ_DRIVER_FLASH) $(OBJ_ABB_CORE)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

$(DRIVER_INT_RAM) : $(OBJ_DRIVER_INT_RAM) $(OBJ_ASM_DRIVER_INT_RAM)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

$(NIQ32_INT_RAM) : $(OBJ_NIQ32_INT_RAM)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(filter-out $(OBJ32), $(OBJ_DRIVER_FLASH)) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)DRIVERS_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

$(filter-out $(OBJ32), $(OBJ_DRIVER_INT_RAM)) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)DRIVERS_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

$(OBJ32) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)CFLAGS32) $($(TP)COUTPUT_FLAG)$(@D)/ $<

$(OBJ_ABB_CORE) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)ABB_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

# WARNING : sys_wait_clkm.s is compiled thanks to default rule specified in top level makefile
