/*
 * ARMIO.H  * * Control diagnostic bits * * Reference : GCS207 *
 */

#include "chipset.cfg"

#include "l1sw.cfg"

#if (OP_L1_STANDALONE == 0)
  #include "main/sys_types.h"
#else
  #include "sys_types.h"
#endif


// Duplicate address with ARMIO_IO_CNTL
// Need to investigate !!!
//#define ARMIO_CNTL      (MEM_ARMIO + 0x04) /* I/O control */

#define ARMIO_IN        (MEM_ARMIO + 0x00) /* inputs */
#define ARMIO_OUT       (MEM_ARMIO + 0x02) /* outputs */
#define ARMIO_IO_CNTL   (MEM_ARMIO + 0x04) /* I/O control */
#define ARMIO_CNTL_REG  (MEM_ARMIO + 0x06) /* control ARMIO */
#define ARMIO_LOAD_TIM  (MEM_ARMIO + 0x08) /* load TIM */
#if (CHIPSET != 12)
  #define ARMIO_KBR_IN    (MEM_ARMIO + 0x0A) /* KBR inputs (rows) */
  #define ARMIO_KBR_OUT   (MEM_ARMIO + 0x0C) /* KBR outputs (columns) */
#endif
#define ARMIO_PWM_CNTL  (MEM_ARMIO + 0x0E) /* LIGHT/BUZZER control */
#define ARMIO_LIGHT     (MEM_ARMIO + 0x10) /* light value */
#define ARMIO_BUZZER    (MEM_ARMIO + 0x12) /* buzzer value */
#define ARMIO_CLOCKEN   0x0020
#if (CHIPSET != 12)
  #define CLKM_IO_CNTL    MEM_IO_SEL         /* control IO */
#endif

#if (CHIPSET == 12)
  #define GPIO_INTERRUPT_LEVEL_REG  * (volatile SYS_UWORD16 *) (MEM_ARMIO + 0x16)
  #define GPIO_INTERRUPT_MASK_REG   * (volatile SYS_UWORD16 *) (MEM_ARMIO + 0x18)
#else
  #define ARMIO_GPIO_EVENT_MODE (MEM_ARMIO + 0x14) /* GPIO event mode */
  #define ARMIO_KBD_GPIO_INT    (MEM_ARMIO + 0x16) /* Kbd/GPIO IRQ register */
  #define ARMIO_KBD_GPIO_MASKIT (MEM_ARMIO + 0x18) /* Kbd/GPIO mask IRQ */
// CC test 0316  
  #define ARMIO_GPIO_DEBOUNCE   (MEM_ARMIO + 0x1A) /* GPIO debounceing register*/
// end  
#endif


#if (CHIPSET != 12)
  #define ARMIO_DCD (2) /* IO used for DCD on C-Sample - Output */
#endif
#define ARMIO_DTR (3) /* IO used for DTR on C-Sample - Input */

#define ARMIO_FALLING_EDGE (0)
#define ARMIO_RISING_EDGE  (1)

#if (CHIPSET != 12)
  #define ARMIO_KEYPDAD_INT (0x0001)
  #define ARMIO_GPIO_INT    (0x0002)

  #define ARMIO_MASKIT_KBD  (0x0001)
  #define ARMIO_MASKIT_GPIO (0x0002)

  void AI_EnableBit(int bit);
  void AI_DisableBit(int bit);
#endif
void AI_SetBit(int bit);
void AI_ResetBit(int bit);
void AI_ConfigBitAsOutput(int bit);
void AI_ConfigBitAsInput(int bit);
SYS_BOOL AI_ReadBit(int bit);
void AI_SetSimIO3V(SYS_UWORD8 StdOutput);

#if (OP_L1_STANDALONE == 0)
  void AI_Power(SYS_UWORD8 power);
#endif

void AI_ResetTspIO(void);
void AI_ResetDbgReg(void);
void AI_ResetIoConfig(void);
void AI_InitIOConfig(void);
void AI_ClockEnable (void);

void AI_SelectIOForIT (SYS_UWORD16 Pin, SYS_UWORD16 Edge);
#if (CHIPSET != 12)
  int  AI_CheckITSource (SYS_UWORD16 Source);
#endif
void AI_UnmaskIT (SYS_UWORD16 Source);
void AI_MaskIT (SYS_UWORD16 Source);

