/**
                                                                          
	@file:	uwire.h	
	
	@author Davide Carpegna                              
                                                                          
    @version	1.0	

    Purpose:	Driver for the uwire HD module       
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    09/22/2000	Create		
    10/18/2001  Updated for R2D by Christophe Favergeon
																											    
																			
 (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved
*/

#ifndef _UWIRE_H_
#define _UWIRE_H_

#define MEM_UWIRE       0xFFFE4000
#define	TDR             (MEM_UWIRE)
#define	RDR             (MEM_UWIRE)
#define	CSR             (MEM_UWIRE+0x02)
#define	SR1             (MEM_UWIRE+0x04)
#define	SR2             (MEM_UWIRE+0x06)
#define	SR3             (MEM_UWIRE+0x08)

#define INDEX_CS1       (1 << 10)
#define NB_BITS_WR_8    (1 << 8 )
#define CS_CMD          (1 << 12)
#define START           (1 << 13)
#define CS1_EDGE_RD     (1 << 6)
#define CS1_FRQ_FINT_4  (1 << 9)
#define SR3_CLK_EN      1

#define CSRB            ( 1<<14 )

#define IO_SEL0         0xFFFEF008
#define IO_SEL          0xFFFEF00A

#define GPIO_INOUT      0xFFFE4804
#define GPIO_OUT        0xFFFE4802 
#define CNTL_RST        0xFFFFFD04

#ifdef _WINDOWS
   #ifdef __cplusplus
      extern "C"
      {
   #endif
#endif

// prototypes of uwire functions for lcd
BOOLEAN lcd_polling(void);
void lcd_transmit_cmd(UINT8 cmd);
void uwire_init_lcd(void);

// Defined only for board
void lcd_transmit_data(UINT8 data);

// Defined only for PC
void lcd_refresh(void);
void lcd_set_pos(unsigned char x,unsigned char y);
void* lcd_get_dc(void);

#ifdef _WINDOWS
   #ifdef __cplusplus
      }
   #endif
#endif

#endif /*_UWIRE_H_*/