/**
                                                                          
	@file:	r2d_task.c
	
	@author Christophe Favergeon                              
                                                                          
    @version 0.5	

    Purpose: Refresh task for R2D. It is calling the LCD dependent refresh subroutine
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    06/02/2001	Create		
	10/18/2001  Version 0.5 for first integration with Riviera database
																											    
																			
 (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved
*/




#include "rv/general.h"
#include "rvf/rvf_api.h"
#include "rvm/rvm_api.h"
#include "rvm/rvm_use_id_list.h"
#include "r2d/r2d_messages.h"
#include "r2d/r2d_env.h"
#include "r2d/r2d_config.h"
#include "r2d/r2d.h"
#include "r2d/r2d_i.h"

extern void r2d_refresh(void);

extern INT16 r2d_g_refresh_disabled;

/*******************************************************************************
** Function         r2d_core
**
** Description      Core of the r2d task, which refresh the LCD
**					
*******************************************************************************/
T_RVM_RETURN r2d_core(void)
{	
	BOOLEAN error_occured = FALSE;
//	T_R2D_EVT * msg_ptr_rx, * msg_ptr_tx;
	
	//r2d_start();


	rvf_send_trace("R2D REFRESH TASK STARTED",24, NULL_PARAM, 
			   RV_TRACE_LEVEL_DEBUG_HIGH, R2D_USE_ID );
	

	/* loop to process messages */
	while (error_occured == FALSE)
	{
		UINT16 received_event;
		//rvf_send_trace("WAIT EVENT",strlen("WAIT EVENT"), NULL_PARAM, 
		//	   RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_XXX );
		/* Wait for the necessary events (infinite wait for a msg in the mailbox 0). */
		 received_event = rvf_wait ( EVENT_MASK(RVF_APPL_EVT_0), 0);

		 //rvf_send_trace("EVENT RECEIVED",strlen("EVENT RECEIVED"), NULL_PARAM, 
		//	   RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_XXX );
					
		/* If an event related to mailbox 0 is received, then */
		if (received_event & EVENT_MASK(RVF_APPL_EVT_0) ) 
		{
			//rvf_send_trace("GOOD EVENT",strlen("GOOD EVENT"), NULL_PARAM, 
			//   RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_XXX );

			r2d_g_event_was_sent=FALSE;
			if (r2d_g_refresh_disabled==0)
			  r2d_refresh();
			rvf_delay(RVF_MS_TO_TICKS(R2D_REFRESH_PERIOD));
		}

	}
	
	return RVM_OK;	
}
