/**
                                                                          
	@file:	r2d_refresh.c
	
	@author Christophe Favergeon                              
                                                                          
    @version 0.5	

    Purpose: Includes LCDs depend definitions for the refresh task
	         (Second part of LCD APIs)
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    06/02/2001	Create		
	10/18/2001  Version 0.5 for first integration with Riviera database
																											    
																			
 (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved
*/




#include "rv/general.h"
#include "rvf/rvf_api.h"
#include "r2d/r2d_messages.h"
#include "r2d/r2d_env.h"
#include "r2d/lcd_messages_ti.h"
#include "r2d/lcd_messages.h"
#include "r2d/r2d_config.h"
#include "r2d/r2d.h"
#include "r2d/r2d_i.h"
#ifdef _WINDOWS
#include <Windows.h>
#endif
#include "r2d/uwire.h"


extern T_RVF_MB_ID r2d_mb_id;

INT16 r2d_update_ul_x,r2d_update_ul_y,r2d_update_br_x,r2d_update_br_y;


#if (R2D_REFRESH == R2D_VERTICAL)
  UINT32 r2d_lcd_memory_words[(((R2D_WIDTH*R2D_MWHEIGHT)+1))];
#else
  UINT32 r2d_lcd_memory_words[(((R2D_MWWIDTH*R2D_HEIGHT)+1))];
#endif

void r2d_reinit_update_region(void)
{
	rvf_lock_mutex(r2d_g_global_mutex);
	//r2d_update_ul_x=0;
	//r2d_update_ul_y=0;
	//r2d_update_br_x=R2D_WIDTH-1;
	//r2d_update_br_y=R2D_HEIGHT-1;
	r2d_update_ul_x=R2D_WIDTH;
	r2d_update_ul_y=R2D_HEIGHT;
	r2d_update_br_x=-1;
	r2d_update_br_y=-1;
	rvf_unlock_mutex(r2d_g_global_mutex);
}

#if (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD)
#include "lcds/colorpc/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_CSAMPLE)
#include "lcds/pc_csample/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_DSAMPLE)
#include "lcds/pc_dsample/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_SIMPLE_LCD) 
#include "lcds/simple/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_MIRRORED_LCD) 
#include "lcds/simple/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_CUSTOMER_LCD) 
#include "lcds/customer/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_HORIZONTAL_LCD) 
#include "lcds/horizontal/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_COLOR_LCD) 
#include "lcds/colorboard/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_DSAMPLE)
#include "lcds/d_sample/r2d_task_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_BW_DSAMPLE)
#include "lcds/bw_d_sample/r2d_task_i.c"
#endif

