/**
 * @file	r2d_pool_size.h
 *
 * Declarations of:
 * - the memory bank sizes and their watermark
 * - the SWE stack size
 * - the pool size needed (generally the sum of memory bank and stack sizes)
 *
 * @author	Vincent Oberle
 * @version 0.1
 */

/*
 * History:
 *
 *	Date       	Author					Modification
 *	-------------------------------------------------------------------
 *	07/08/2003	Vincent Oberle			Extracted from rvf_pool_size.h
 *
 * (C) Copyright 2003 by Texas Instruments Incorporated, All Rights Reserved
 */

#ifndef __R2D_POOL_SIZE_H_
#define __R2D_POOL_SIZE_H_


#ifndef _WINDOWS
  #include "config/r2d.cfg"
  #include "config/board.cfg"
  #include "config/swconfig.cfg"
#endif


/*
 * Values used in r2d_env.h (Stack) & r2d_inits.c (Memory Banks)
 */
#define R2D_STACK_SIZE   (1000)

#if (R2D_LCD_TEST == 1)
   #if defined (_WINDOWS)
      #define R2D_MB1_SIZE   (4000)
   #else
      #define R2D_MB1_SIZE   (3000)
   #endif
#elif ((BOARD == 7) || (BOARD == 8) || (BOARD == 9))
/* #if ((R2D_EMBEDDED_LCD == R2D_MIRRORED_LCD) || (R2D_EMBEDDED_LCD == R2D_SIMPLE_LCD)) */
  #define R2D_MB1_SIZE   (2000) /* B or C-Sample with B&W LCD (default setting) */
/* #elif (R2D_EMBEDDED_LCD == R2D_BOARD_COLOR_LCD) */
  /* #define R2D_MB1_SIZE (3000) */ /* C-Sample with Color LCD */
#elif ((BOARD == 40) || (BOARD == 41) || (BOARD == 42) || (BOARD == 43))
/* #elif ((R2D_EMBEDDED_LCD == R2D_BOARD_DSAMPLE) || (R2D_EMBEDDED_LCD == R2D_BOARD_BW_DSAMPLE)) */
  #define R2D_MB1_SIZE   (4000) /* D-Sample */
#elif defined (_WINDOWS)
/* #elif (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD) */
  #define R2D_MB1_SIZE   (4000) /* ColorPC */
/* #elif (R2D_EMBEDDED_LCD == R2D_PC_CSAMPLE) */
  /* #define R2D_MB1_SIZE (XXXX) */
/* #elif (R2D_EMBEDDED_LCD == R2D_PC_DSAMPLE) */
  /* #define R2D_MB1_SIZE (XXXX) */
/* #elif (R2D_EMBEDDED_LCD == R2D_CUSTOMER_LCD) */
  /* #define R2D_MB1_SIZE (XXXX) */
/* #elif (R2D_EMBEDDED_LCD == R2D_HORIZONTAL_LCD) */
  /* #define R2D_MB1_SIZE (XXXX) */
#endif

#define R2D_POOL_SIZE    (R2D_STACK_SIZE + R2D_MB1_SIZE)


#endif /*__R2D_POOL_SIZE_H_*/
