/****************************************************************************/
/*                                                                          */
/*	File Name:	xxx_messages.h												*/
/*                                                                          */
/*	Purpose:	This file contains data structures and functions prototypes */
/*				used to send events to the XXX SWE.							*/
/*                                                                          */
/*  Version		0.1															*/
/*																			*/
/* 	Date       	Modification												*/
/*  ------------------------------------									*/
/*  20/08/2000	Create														*/
/*																			*/
/*	Author		David Lamy-Charrier (dlamy@tif.ti.com)						*/
/*																			*/
/* (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved*/
/****************************************************************************/
#ifndef __R2D_MESSAGES_H_
#define __R2D_MESSAGES_H_


#include "rv/rv_general.h"

#ifdef __cplusplus
extern "C"
{
#endif




/* the message offset must differ for each SWE in order to have unique msg_id in the system */
#define R2D_MESSAGES_OFFSET		(0x36 << 10)


/* define a first msg id */
#define R2D_MESSAGE_1		(R2D_MESSAGES_OFFSET | 0x0001)



/*****************************************/
/* structures of messages send to R2D	*/
typedef struct
{	T_RV_HDR	os_hdr;
	BOOLEAN		status;
} T_R2D_EVT;



#ifdef __cplusplus
}
#endif


#endif /* __R2D_MESSAGES_H_ */

