/**
                                                                          
	@file:	r2d_lcds.c
	
	@author Christophe Favergeon                              
                                                                          
    @version	0.5	

    Purpose:	Include LCDs dependent definitions (the LCD APIs)
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    06/02/2001	Create		
	10/18/2001  Version 0.5 for first integration with Riviera database
																											    
																			
 (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved
*/

#include "rv/general.h"
#include "rvf/rvf_api.h"
#include "r2d/r2d_config.h"
#include "r2d/r2d.h"
#include "r2d/r2d_i.h"
#include "r2d/r2d_independance_layer.h"
#if (R2D_DEBUG == R2D_ON)
#include <stdio.h>
#endif

#ifdef _WINDOWS
#include "Windows.h"
#endif

#ifndef _WINDOWS
	#include "config/board.cfg"
#endif

//////////////////////////////////
//
// Include LCD dependent C code
//
#if (R2D_EMBEDDED_LCD == R2D_SIMPLE_LCD)
  #include "lcds/simple/R2D_simple_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD)
  #include "lcds/colorpc/R2D_pc_color_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_CSAMPLE)
#include "lcds/pc_csample/R2D_pc_csample_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_DSAMPLE)
#include "lcds/pc_dsample/R2D_pc_dsample_lcd_i.c"
#endif


#if (R2D_EMBEDDED_LCD == R2D_MIRRORED_LCD)
  #include "lcds/simple/R2D_simple_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_CUSTOMER_LCD)
  #include "lcds/customer/R2D_customer_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_HORIZONTAL_LCD)
  #include "lcds/horizontal/R2D_horizontal_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_COLOR_LCD)
  #include "lcds/colorboard/R2D_board_color_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_DSAMPLE)
#include "lcds/d_sample/R2D_board_dsample_lcd_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_BW_DSAMPLE)
#include "lcds/bw_d_sample/R2D_board_bw_dsample_lcd_i.c"
#endif