/**
                                                                          
	@file:	r2d_lcd_geometry.c
	
	@author Christophe Favergeon                              
                                                                          
    @version	0.5	

    Purpose:	Low level drawing subroutines interacting directly with framebuffers
	            and with LCDs APIs
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    06/02/2001	Create		
	10/18/2001  Version 0.5 for first integration with Riviera database
																											    
																			
 (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved
*/


#include "rv/general.h"
#include "rvf/rvf_api.h"
#include "rvm/rvm_use_id_list.h"
#include "r2d/r2d_config.h"
#include "r2d/r2d.h"
#include "r2d/r2d_i.h"
#include "r2d/r2d_independance_layer.h"
#if (R2D_DEBUG == R2D_ON)
#include <stdio.h>
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD)
#include "Windows.h"
#endif



#define IND_r2d_color_to_lcd r2d_color_to_lcd
#define  IND_r2d_get_drawing_mode r2d_get_drawing_mode
#define  IND_rvf_send_trace rvf_send_trace
#define  IND_r2d_lcd_to_color r2d_lcd_to_color

#define IND_r2d_lcd_foreground_pixel r2d_lcd_foreground_pixel

#define IND_r2d_color_framebuffer_foreground_pixel r2d_color_framebuffer_foreground_pixel

#if (R2D_ASM == R2D_ON)
extern void r2d_blit_la(UINT32 *a);
extern void r2d_blit_lb(UINT32 *a);

extern void r2d_patch_blit(T_R2D_GC_PTR dst_gc,T_R2D_DRAWING_MODE mode,
					R2D_BOOLEAN use_foreground_color,INT32 srcdst);

extern UINT32 r2d_lcd_start_copy;
extern UINT32 r2d_lcd_start_or;
extern UINT32 r2d_lcd_start_and;
extern UINT32 r2d_lcd_start_xor;
extern UINT32 r2d_lcd_start_notcopy;
extern UINT32 r2d_lcd_start_notor;
extern UINT32 r2d_lcd_start_notand;
extern UINT32 r2d_lcd_start_notxor;
extern UINT32 r2d_lcd_start_alpha;
extern UINT32 r2d_lcd_start_foreground_pixel;

extern UINT32 r2d_color_start_copy;
extern UINT32 r2d_color_start_or;
extern UINT32 r2d_color_start_and;
extern UINT32 r2d_color_start_xor;
extern UINT32 r2d_color_start_notcopy;
extern UINT32 r2d_color_start_notor;
extern UINT32 r2d_color_start_notand;
extern UINT32 r2d_color_start_notxor;
extern UINT32 r2d_color_start_alpha;
extern UINT32 r2d_color_start_foreground_pixel;

extern UINT32 r2d_start_get_color;


// Drawing mode
extern UINT32 r2d_sb_down1;
extern UINT32 r2d_sb_down2;
extern UINT32 r2d_sa_up1;
extern UINT32 r2d_sa_up2;

// Foreground detection
extern UINT32 r2d_sdb_down1;
extern UINT32 r2d_sdb_down2;
extern UINT32 r2d_sda_up1;
extern UINT32 r2d_sda_up2;

// Color conversion
extern UINT32 r2d_scb_down1;
extern UINT32 r2d_scb_down2;
extern UINT32 r2d_sca_up1;
extern UINT32 r2d_sca_up2;

extern UINT32 r2d_start_branch_inst;
extern UINT32 r2d_stop_branch_inst;
extern UINT32 r2d_blit_foreground;
extern UINT32 r2d_blit_background;
extern UINT32 r2d_skip_color_proc_a;
extern UINT32 r2d_end_ynb_color_dst_a;
extern UINT32 r2d_skip_color_proc_b;
extern UINT32 r2d_end_ynb_color_dst_b;

// Patch list for write_shift_pixel_down
extern UINT32 r2d_sft_dst_n_b_down1,r2d_sft_dst_n_b_down2;
extern UINT32 r2d_sft_srcb__b_down1,r2d_sft_srcb__b_down2;
extern UINT32 r2d_sft_dstc__b_down1,r2d_sft_dstc__b_down2;

extern UINT32 r2d_sft_src_c_b_down1,r2d_sft_src_c_b_down2;
extern UINT32 r2d_sft_b_c_b_down1,r2d_sft_b_c_b_down2;
extern UINT32 r2d_sft_dstb_c_b_down1,r2d_sft_dstb_c_b_down2;
extern UINT32 r2d_sft_d_c_b_down1,r2d_sft_d_c_b_down2;
extern UINT32 r2d_sft_dstc_c_b_down1,r2d_sft_dstc_c_b_down2;

// Patch list for write_shift_pixel_up
extern UINT32 r2d_sft_dst_n_a_up1,r2d_sft_dst_n_a_up2;
extern UINT32 r2d_sft_srcb__a_up1,r2d_sft_srcb__a_up2;
extern UINT32 r2d_sft_dstc__a_up1,r2d_sft_dstc__a_up2;

extern UINT32 r2d_sft_src_c_a_up1,r2d_sft_src_c_a_up2;
extern UINT32 r2d_sft_b_c_a_up1,r2d_sft_b_c_a_up2;

// Patch list fro shift_pixel_down
extern UINT32 r2d_sft_dst_n_downa,r2d_sft_dst_n_downb,r2d_sft_dst_n_downc;
extern UINT32 r2d_sft_srcb_n_downa,r2d_sft_srcb_n_downb,r2d_sft_srcb_n_downc;

extern UINT32 r2d_sft_src_c_downa,r2d_sft_src_c_downb,r2d_sft_src_c_downc;

// Patch list fro shift_pixel_up
extern UINT32 r2d_sft_dst_n_upa,r2d_sft_dst_n_upb,r2d_sft_dst_n_upc;
extern UINT32 r2d_sft_srcb_n_upa,r2d_sft_srcb_n_upb,r2d_sft_srcb_n_upc;

extern UINT32 r2d_sft_src_c_upa,r2d_sft_src_c_upb,r2d_sft_src_c_upc;

extern UINT32 r2d_sconvcolb_down1,r2d_econvcolb_down1;
extern UINT32 r2d_sconvcolb_down2,r2d_econvcolb_down2;
extern UINT32 r2d_sconvcola_up1,r2d_econvcola_up1;
extern UINT32 r2d_sconvcola_up2,r2d_econvcola_up2;
extern UINT32 r2d_start_lcd_to_color,r2d_start_color_to_lcd;

extern UINT32 r2d_always_write_down,r2d_always_write_up,r2d_never_write;
extern UINT32 r2d_swb_down1,r2d_swb_down2,r2d_swa_up1,r2d_swa_up2;

extern UINT32 r2d_skip_color_dst_a,r2d_skip_color_dst_b;
extern UINT32 r2d_always_skip;
extern UINT32 r2d_enda,r2d_endb;
extern UINT32 r2d_lcd_start_nothing;

extern UINT32 r2d_skip_load_src_a_up1,r2d_skip_load_src_a_up2;
extern UINT32 r2d_skip_load_src_b_down1,r2d_skip_load_src_b_down2;
extern UINT32 r2d_skip_shift_down_downa,r2d_skip_shift_down_downb,r2d_skip_shift_down_downc;
extern UINT32 r2d_skip_shift_up_upa,r2d_skip_shift_up_upb,r2d_skip_shift_up_upc;
extern UINT32 r2d_no_null_src_counter_a,r2d_no_null_src_counter_b;
extern UINT32 r2d_end_a_up2,r2d_end_b_down2,r2d_end_downa,r2d_end_downb,r2d_end_downc;
extern UINT32 r2d_end_upa,r2d_end_upb,r2d_end_upc;

extern UINT32 r2d_always_read_b_down1,r2d_always_read_b_down2;
extern UINT32 r2d_always_read_a_up1,r2d_always_read_a_up2;
extern UINT32 r2d_always_read_down,r2d_always_read_up;

extern UINT32* r2d_g_asm_lcd_operators[];
extern UINT32* r2d_g_asm_color_operators[];

#endif

#include "LCDs/R2D_vertical_lcd_i.c"
