/**
                                                                          
	@file:	r2d_fonts.c	
	
	@author Christophe Favergeon                              
                                                                          
    @version	0.5	

    Purpose:	Font file including all fonts definition which are LCD
	            dependen
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    06/02/2001	Create		
	10/18/2001  Version 0.5 for first integration with Riviera database
																											    
																			
 (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved
*/

#include "rv/general.h"

#include "rvm/rvm_gen.h"
#include "rvm/rvm_ext_priorities.h"
#include "rvf/rvf_api.h"

#include "r2d/r2d_config.h"
#include "r2d/r2d.h"
#include "r2d/r2d_i.h"


extern T_R2D_FONT_DESCRIPTION *r2d_g_font_configuration;

#define r2d_new_font(name) T_R2D_FRAMEBUFFER* r2d_g_font_framebuffer_##name=NULL; \
	INT32 *r2d_g_font_metrics_##name=(INT32*)r2d_font_metric_##name+R2D_METRIC_START

#define r2d_init_font_field(field,name) { \
r2d_g_font_configuration[field].table=(INT32*)r2d_font_ptree_##name; \
r2d_g_font_configuration[field].metrics=r2d_g_font_metrics_##name; \
r2d_g_font_configuration[field].framebuffer=(T_R2D_FRAMEBUFFER_PTR)r2d_g_font_framebuffer_##name; \
r2d_g_font_configuration[field].compute_bold=FALSE; \
}

#define r2d_init_font_field_without_bold(field,name) { \
r2d_g_font_configuration[field].table=(INT32*)r2d_font_ptree_##name; \
r2d_g_font_configuration[field].metrics=r2d_g_font_metrics_##name; \
r2d_g_font_configuration[field].framebuffer=(T_R2D_FRAMEBUFFER_PTR)r2d_g_font_framebuffer_##name; \
r2d_g_font_configuration[field].compute_bold=TRUE; \
}

#define r2d_clean_font(name) \
 rvf_free_buf((void*)(r2d_g_font_framebuffer_##name->mutex));\
 rvf_free_buf((void*)(r2d_g_font_framebuffer_##name));\
 r2d_g_font_framebuffer_##name=NULL;

#if (R2D_REFRESH == R2D_VERTICAL) 
#define r2d_init_font(name) \
	h=r2d_font_metric_##name[0]; \
v=r2d_font_metric_##name[1]; \
   words=r2d_font_metric_##name[2]; \
   rvf_get_buf(r2d_mb_id, sizeof(T_R2D_FRAMEBUFFER), \
   (T_RVF_BUFFER**)&r2d_g_font_framebuffer_##name);\
   if (r2d_g_font_framebuffer_##name==NULL)\
     ret_err=R2D_MEMORY_ERR;\
   else\
	 {\
   length=h*words; \
   r2d_g_font_framebuffer_##name->p_memory_words=(UINT32*)r2d_font_bitmap_##name; \
   r2d_g_font_framebuffer_##name->refcount=-1; \
   r2d_g_font_framebuffer_##name->kind=R2D_LCD_KIND; \
   r2d_g_font_framebuffer_##name->p_frame_buffer_end=r2d_g_font_framebuffer_##name->p_memory_words+length; \
   r2d_g_font_framebuffer_##name->width=h; \
   r2d_g_font_framebuffer_##name->height=v; \
   rvf_get_buf(r2d_mb_id, sizeof(T_RVF_MUTEX), \
   (T_RVF_BUFFER**)&(r2d_g_font_framebuffer_##name->mutex));\
   if (r2d_g_font_framebuffer_##name->mutex!=NULL)\
   {\
        T_RVF_RET err;\
		err=rvf_initialize_mutex(r2d_g_font_framebuffer_##name->mutex);\
		if (err!=RVF_OK)\
		{\
		         ret_err=R2D_MEMORY_ERR;\
				 rvf_free_buf((void*)(r2d_g_font_framebuffer_##name->mutex));\
				 rvf_free_buf((void*)(r2d_g_font_framebuffer_##name));\
				 r2d_g_font_framebuffer_##name=NULL;\
		}\
   }\
   else\
   {\
       ret_err=R2D_MEMORY_ERR;\
	   rvf_free_buf((void*)(r2d_g_font_framebuffer_##name));\
	   r2d_g_font_framebuffer_##name=NULL;\
   }\
}
#else
#define r2d_init_font(name) h=r2d_font_metric_##name[0]; \
   v=r2d_font_metric_##name[1]; \
   words=r2d_font_metric_##name[2]; \
   rvf_get_buf(r2d_mb_id, sizeof(T_R2D_FRAMEBUFFER), \
   (T_RVF_BUFFER**)&r2d_g_font_framebuffer_##name);\
   if (r2d_g_font_framebuffer_##name==NULL)\
     ret_err=R2D_MEMORY_ERR;\
   else\
	 {\
   length=v*words; \
   r2d_g_font_framebuffer_##name->p_memory_words=(UINT32*)r2d_font_bitmap_##name; \
   r2d_g_font_framebuffer_##name->refcount=-1; \
   r2d_g_font_framebuffer_##name->kind=R2D_LCD_KIND; \
   r2d_g_font_framebuffer_##name->p_frame_buffer_end=r2d_g_font_framebuffer_##name->p_memory_words+length; \
   r2d_g_font_framebuffer_##name->width=h; \
   r2d_g_font_framebuffer_##name->height=v; \
   rvf_get_buf(r2d_mb_id, sizeof(T_RVF_MUTEX), \
   (T_RVF_BUFFER**)&(r2d_g_font_framebuffer_##name->mutex));\
   if (r2d_g_font_framebuffer_##name->mutex!=NULL)\
   {\
        T_RVF_RET err;\
		err=rvf_initialize_mutex(r2d_g_font_framebuffer_##name->mutex);\
		if (err!=RVF_OK)\
		{\
		         ret_err=R2D_MEMORY_ERR;\
				 rvf_free_buf((void*)(r2d_g_font_framebuffer_##name->mutex));\
				 rvf_free_buf((void*)(r2d_g_font_framebuffer_##name));\
				 r2d_g_font_framebuffer_##name=NULL;\
		}\
   }\
   else\
   {\
       ret_err=R2D_MEMORY_ERR;\
	   rvf_free_buf((void*)(r2d_g_font_framebuffer_##name));\
	   r2d_g_font_framebuffer_##name=NULL;\
   }\
}
#endif

#if (R2D_EMBEDDED_LCD == R2D_SIMPLE_LCD)
#include "lcds/simple/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD)
#include "lcds/colorpc/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_CSAMPLE)
#include "lcds/pc_csample/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_DSAMPLE)
#include "lcds/pc_dsample/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_MIRRORED_LCD)
#include "lcds/mirrored/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_CUSTOMER_LCD)
#include "lcds/customer/r2d_font_init_i.c"

#endif

#if (R2D_EMBEDDED_LCD == R2D_HORIZONTAL_LCD)
#include "lcds/horizontal/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_COLOR_LCD)
#include "lcds/colorboard/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_DSAMPLE)
#include "lcds/d_sample/r2d_font_init_i.c"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_BW_DSAMPLE)
#include "lcds/bw_d_sample/r2d_font_init_i.c"
#endif

