/****************************************************************************/
/*                                                                          */
/*	File Name:	r2d_env.h													*/
/*                                                                          */
/*	Purpose:	This file contains prototypes for RV Manager related	*/
/*				functions used to get info, start and stop the xxx block.	*/
/*                                                                          */
/*  Version		0.1															*/
/*																			*/
/* 	Date       	Modification												*/
/*  ------------------------------------									*/
/*  20/08/2000	Create														*/
/*																			*/
/*	Author		David Lamy-Charrier (dlamy@tif.ti.com)						*/
/*																			*/
/* (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved*/
/****************************************************************************/
#ifndef __R2D_ENV_H_
#define __R2D_ENV_H_


#include "rvm/rvm_gen.h"
#include "r2d/r2d_config.h"

#include "r2d/r2d_pool_size.h"	/* Stack & Memory Bank sizes definitions */


/* memory bank size and watermark */	 
                                        
/* R2D_MB_PRIM_SIZE defines in files r2d_task_init_i.c */
#define R2D_MB_PRIM_INC_SIZE			0
#define R2D_MB_PRIM_INC_WATERMARK		0

#define R2D_MAILBOX_USED	RVF_TASK_MBOX_0



/* generic functions declarations */
T_RVM_RETURN r2d_get_info (T_RVM_INFO_SWE  *infoSWE);

T_RVM_RETURN  r2d_set_info	(	T_RVF_ADDR_ID	addr_id,
								T_RV_RETURN		return_path[],
								T_RVF_MB_ID		bk_id_table[],
								T_RVM_CB_FUNC	call_back_error_ft);
T_RVM_RETURN r2d_init (void);

T_RVM_RETURN r2d_start (void);

T_RVM_RETURN r2d_stop (void);

T_RVM_RETURN r2d_kill (void);

#endif /*__R2D_ENV_H_*/

