/**
                                                                          
	@file:	r2d_env.c	
	
	@author Christophe Favergeon                              
                                                                          
    @version	0.5	

    Purpose:	Environment  for the software entity
                of Riviera 2D system (higher software layer)     
	
*/

/*
																			
 	Date       	Modification												
  ------------------------------------									
    06/02/2001	Create		
	10/18/2001  Version 0.5 for first integration with Riviera database
																											    
																			
 (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved
*/


#include "rv/general.h"

#include "rvm/rvm_gen.h"
#include "rvm/rvm_ext_priorities.h"
#include "rvm/rvm_use_id_list.h"


#include "r2d/r2d.h"
#include "r2d/r2d_env.h"
#include "r2d/r2d_messages.h"
#include "r2d/uwire.h" 

#include <string.h>


extern void r2d_core(UINT32 param);

/* global pointer to the error function */
T_RVM_RETURN (*r2d_error_ft)(T_RVM_NAME swe_name, T_RVM_RETURN error_cause, \
					T_RVM_ERROR_TYPE error_type,T_RVM_STRING error_msg);



/* global addr id */
T_RVF_ADDR_ID r2d_addr_id;



/* global memory bank ID */
T_RVF_MB_ID r2d_mb_id;

/* Global standard graphical context */
T_R2D_GC_PTR r2d_g_lcd_gc=NULL;

/* For communication with the task */
T_R2D_EVT * p_msg;

extern T_RVM_RETURN r2d_initializations(void);
extern T_RVM_RETURN r2d_cleanup();
extern UINT32 r2d_get_memory_bank_size();
/******************************************************************************
* Function	  : xxx_get_info
*
* Description : This function is called by the RV manager to learn 
*				xxx requirements in terms of memory, SWEs...
*
* Parameters  : T_RVM_INFO_SWE  * swe_info: pointer to the structure to fill
*				containing infos related to the xxx SWE.
*
* Return      :  T_RVM_RETURN
* 
* History	  : 0.1 (20-August-2000)
*									
*
******************************************************************************/
T_RVM_RETURN r2d_get_info(T_RVM_INFO_SWE  * infoSWE)
{

	/* SWE info */
	
	memcpy ( (UINT8 *) infoSWE->type_info.type4.swe_name, "R2D", 4);
	infoSWE->swe_type = RVM_SWE_TYPE_4;
	infoSWE->type_info.type4.stack_size=R2D_STACK_SIZE;
    infoSWE->type_info.type4.priority=RVM_R2D_TASK_PRIORITY;
	infoSWE->type_info.type4.swe_use_id=R2D_USE_ID;



	
	/* memory bank info */
	infoSWE->type_info.type4.nb_mem_bank= 1;

	
	
	memcpy ((UINT8 *) infoSWE->type_info.type4.mem_bank[0].bank_name, "R2D_PRIM", 9);
	infoSWE->type_info.type4.mem_bank[0].initial_params.size          = r2d_get_memory_bank_size();
	infoSWE->type_info.type4.mem_bank[0].initial_params.watermark     = r2d_get_memory_bank_size()-1000;
	

	/* linked SWE info */
	/* this SWE does not require any SWE to run */
	infoSWE->type_info.type4.nb_linked_swe = 0;
	
	
	/* generic functions */
	infoSWE->type_info.type4.set_info=r2d_set_info;
	infoSWE->type_info.type4.init     = r2d_init;
	infoSWE->type_info.type4.stop     = r2d_stop;
	infoSWE->type_info.type4.kill     = r2d_kill;
	infoSWE->type_info.type4.core = r2d_start;


	return RVM_OK;
}


/******************************************************************************
* Function	  : xxx_set_info
*
* Description : This function is called by the RV manager to inform  
*				the xxx SWE about task_id, mb_id and error function.
*
* Parameters  : - T_RVM_TASK_ID  taskId[]: array of task_id.
*					taskId[0] contains xxx task_id.
*				- T_RVF_MB_ID mbId[]: array of memory bank ids.
*				- callback function to call in case of unrecoverable error.
*
* Return      : T_RVM_RETURN
* 
* History	  : 0.1 (20-August-2000)
*									
*
******************************************************************************/
T_RVM_RETURN  r2d_set_info	(	T_RVF_ADDR_ID	addr_id,
						  T_RV_RETURN	 return_path[],
								T_RVF_MB_ID		bk_id_table[],
								T_RVM_CB_FUNC	call_back_error_ft)


{

	/* store the pointer to the error function */
	r2d_error_ft = call_back_error_ft ;

	r2d_addr_id=addr_id;


	/* Store MB id */
	r2d_mb_id = bk_id_table[0];

	/* return_path of linked SWE -> not used */

	return RVM_OK;
}




/******************************************************************************
* Function	  : xxx_start
*
* Description : This function is called by the RV manager to start the xxx
*				SWE, it is the body of the task.
*
* Parameters  : None
*
* Return      : T_RVM_RETURN
* 
* History	  : 0.1 (20-August-2000)
*									
*
******************************************************************************/
T_RVM_RETURN r2d_start(void)
{
	/*
	** Branch to main task core
	*/
	if (r2d_g_lcd_gc!=NULL)
	{
	  r2d_erase(r2d_g_lcd_gc);
	  r2d_core(0);
	  return RV_OK;
	}
	else
		return RV_MEMORY_ERR;
}



/******************************************************************************
* Function	  : xxx_stop
*
* Description : This function is called by the RV manager to stop the xxx SWE.
*
* Parameters  : None
*
* Return      : T_RVM_RETURN
* 
* History	  : 0.1 (20-August-2000)
*									
*
******************************************************************************/
T_RVM_RETURN r2d_stop(void)
{
	/*
	** other SWEs have not been killed yet, xxx can send messages to other SWEs
	*/
	return RVM_OK;
}

/******************************************************************************
* Function	  : xxx_kill
*
* Description : This function is called by the RV manager to kill the xxx 
*				SWE, after the xxx_stop function has been called.
*
* Parameters  : None
*
* Return      : T_RVM_RETURN
* 
* History	  : 0.1 (20-August-2000)
*									
*
******************************************************************************/
T_RVM_RETURN r2d_kill (void)
{
    r2d_cleanup();
	return RV_OK;
}




/******************************************************************************
* Function	  : xxx_init
*
* Description : This function is called by the RV manager to initialize the 
*				xxx SWE before creating the task and calling xxx_start. 
*
* Parameters  : None
*
* Return      : T_RVM_RETURN
* 
* History	  : 0.1 (20-August-2000)
*									
*
******************************************************************************/
T_RVM_RETURN r2d_init(void)
{
return(r2d_initializations());
}

