/***************************************************************************
                                                                          
  Name        r2d_config.h                                                   
                                                                          
  Function    Hardware dependent configurations                       
                                                                          
  Date        Modification                                                 
  -----------------------                                                 
  06/12/2001    Create                                                       
 **************************************************************************
  History       
                                                                          
****************************************************************************/


#ifndef __R2D_CONFIG__
#define __R2D_CONFIG__

#ifndef _WINDOWS
#include "config/r2d.cfg"
#include "config/board.cfg"
  #include "config/swconfig.cfg"
#endif

/*******************************

   MISC R2D CONSTANTS

*******************************/


#define R2D_ON 1
#define R2D_OFF 0

#define R2D_DEBUG_LOW 0
#define R2D_DEBUG_HIGH 1

// Color mode for the LCD
#define R2D_MONOCHROME 0
#define R2D_COLOR 1

// Mode of refresh for the LCD
#define R2D_VERTICAL 0
#define R2D_HORIZONTAL 1

// List of kind of supported LCDs
#define R2D_SIMPLE_LCD 1
#define R2D_PC_COLOR_LCD 2
#define R2D_MIRRORED_LCD 3
#define R2D_CUSTOMER_LCD 4
#define R2D_HORIZONTAL_LCD 5
#define R2D_BOARD_COLOR_LCD 6
#define R2D_BOARD_DSAMPLE 7
#define R2D_BOARD_BW_DSAMPLE 8
#define R2D_BOARD_ESAMPLE 9
#define R2D_PC_CSAMPLE 108
#define R2D_PC_DSAMPLE 109

/*******************************

   Riviera 2D configuration

*******************************/


// ln2 of dimension of dithering matrix
// (must change code if that value is changed)
#define R2D_DITHERING_DIMENSION 2

#define R2D_DEBUG R2D_ON

#define R2D_DEBUG_WARNING R2D_DEBUG_LOW

// For still on development new features
#define R2D_EXPERIMENT R2D_ON

// C-Sample for PC
#ifdef _WINDOWS
       #define R2D_REFRESH_PERIOD 50 // ms
       #define R2D_EMBEDDED_LCD R2D_PC_COLOR_LCD
#endif

#if (R2D_LCD_TEST == 1)
    #define R2D_REFRESH_PERIOD 40 // ms
	#define R2D_EMBEDDED_LCD R2D_BOARD_COLOR_LCD 
#else
    #if ((BOARD == 7) || (BOARD == 8) || (BOARD == 9))
		// C-Sample is equipped with Mirrored LCD
		#define R2D_REFRESH_PERIOD 40 // ms
		#define R2D_EMBEDDED_LCD R2D_MIRRORED_LCD 
   #elif ((BOARD == 40) || (BOARD == 41) || (BOARD == 42) || (BOARD == 43))
       #if (!GSMLITE)
         // D-Sample Board with Color Display
		 #define R2D_REFRESH_PERIOD 40 // ms
		 #define R2D_EMBEDDED_LCD R2D_BOARD_DSAMPLE
       #else
         // D-Sample Board with simulated B&W Display
         #define R2D_REFRESH_PERIOD 40 // ms
         #define R2D_EMBEDDED_LCD R2D_BOARD_BW_DSAMPLE
	   #endif
  #endif
#endif

// Launch R2D_REFRESH_LOOP to estimate the time
// taken by one loop
#define R2D_BENCHMARKING R2D_OFF
#define R2D_REFRESH_LOOP 100


/*******************************

   Hardware dependence

*******************************/

// Shift by 2 to get the size of a long int
#define R2D_LONGSIZE_FACTOR 2  

// ln2 of the size of a memory word in bits
// (2^5 = 32 bits)
#define R2D_MEMORY_WORD 5

/*******************************

   Values used internally

*******************************/

#if (R2D_EMBEDDED_LCD == R2D_SIMPLE_LCD)
#include "r2d/lcds/simple/r2d_simple_lcd_i.h"
#endif

// Color LCD is just a simulation on PC and is using the
// color framebuffers
#if (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD)
#include "r2d/lcds/colorpc/r2d_pc_color_lcd_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_CSAMPLE)
#include "r2d/lcds/pc_csample/r2d_pc_csample_lcd_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_DSAMPLE)
#include "r2d/lcds/pc_dsample/r2d_pc_dsample_lcd_i.h"
#endif

// Color LCD is just a simulation on PC and is using the
// color framebuffers
#if (R2D_EMBEDDED_LCD == R2D_MIRRORED_LCD)
#include "r2d/lcds/mirrored/r2d_mirrored_lcd_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_CUSTOMER_LCD)
#include "r2d/lcds/customer/r2d_customer_lcd_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_HORIZONTAL_LCD)
#include "r2d/lcds/horizontal/r2d_horizontal_lcd_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_COLOR_LCD)
#include "r2d/lcds/colorboard/r2d_board_color_lcd_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_DSAMPLE)
#include "r2d/lcds/d_sample/r2d_board_dsample_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_BOARD_BW_DSAMPLE)
#include "r2d/lcds/bw_d_sample/r2d_board_bw_dsample_i.h"
#endif

#if (R2D_EMBEDDED_LCD == R2D_PC_COLOR_LCD)
#ifdef R2D_ASM
#undef R2D_ASM
#endif
#define R2D_ASM R2D_OFF
#endif

#if (R2D_ASM == R2D_ON)
#if (R2D_DITHERING == R2D_ON)
#undef R2D_DITHERING
#define R2D_DITHERING R2D_OFF
#endif

#endif


// Mask used to write or read a pixel value from a memory word
// It is also used in monochrome mode to extract the intensity level
// In color mode, a pixel will contain several intensity
// level and another mask to extract components should be used

// ifdef used because of limitation with TI preprocessor
// which is giving 0 for R2D_PIXEL_MASK instead of 0xFFFFFFFF
// when R2D_PIXEL_DEPTH is 32
#if (R2D_PIXEL_DEPTH == 32)
#define R2D_PIXEL_MASK 0xFFFFFFFF
#else
#define R2D_PIXEL_MASK (~(-1<<R2D_PIXEL_DEPTH))
#endif

// Pixel value mask for dithered levels
#define R2D_DITHERED_MASK (~(-1<<R2D_DITHERING_DIMENSION))


#if (R2D_PIXELS_PER_MEMORY_WORD == 0)

  // Position of the pixel in a memory word is extracted with
  // that mask applied to the pixel horizontal or vertical 
  // coordinate (depending on the REFRESH mode)
  // It allows to convert between unit pixels to unit memory words
  #define R2D_WORD_POSITION_MASK 0

  // Extension of vertical or horizontal for memory alignments
  // constraints
  #if (R2D_REFRESH == R2D_VERTICAL)
    #define R2D_MWHEIGHT R2D_HEIGHT
  #else
    #define R2D_MWWIDTH R2D_WIDTH
  #endif

  // Extend lengths to a integer number of memory words
  // and return new length in memory word units
  #define R2D_ALIGNED_MWLENGTH(a) a
#else
  // Above formula are right when the number of pixels
  // can be divided by 2 (so R2D_PIXELS_PER_MEMORY_WORD != 0 )

  // Position of the pixel in a memory word is extracted with
  // that mask applied to the pixel horizontal or vertical 
  // coordinate (depending on the REFRESH mode)
  // It allows to convert between unit pixels to unit memory words
#define R2D_WORD_POSITION_MASK (~(-1<<R2D_PIXELS_PER_MEMORY_WORD))

  // Extension of vertical or horizontal for memory alignments
  // constraints (the extension is done by excess. Sometime one
  // word may be added although it is not really needed)
  #if (R2D_REFRESH == R2D_VERTICAL)
    #define R2D_MWHEIGHT ((R2D_HEIGHT>>R2D_PIXELS_PER_MEMORY_WORD)+1)
  #else
    #define R2D_MWWIDTH ((R2D_WIDTH>>R2D_PIXELS_PER_MEMORY_WORD)+1)
  #endif

  // Extend lengths to a integer number of memory words
  // and return new length in memory word units

  // Never change it. It used for blit_rect
  #define R2D_ALIGNED_MWLENGTH(a) ((a>>R2D_PIXELS_PER_MEMORY_WORD) + 1)
   

#endif
// Start of description of metrics values
// for each char
// The first values are the global ones for the font
#define R2D_METRIC_START 8


// Position of buffer width value relative
// to start of char metrics in a font metric array
#define R2D_BUFFER_WIDTH_POS (-5)



#endif
