
  
  .state32

  .sect ".r2dlcd"

 .if (R2D_ASM = 1)

 .include "r2d_asm_configs.inc"
 .include "r2d_asm_utils.inc"
 .include "r2d_asm_patch_utils.inc"


 

 .global _r2d_start_branch_inst
 .global _r2d_stop_branch_inst
 .global _r2d_load_foreground
 .global _r2d_load_background

 .global _r2d_blit_foreground
 .global _r2d_blit_background

 .global _r2d_always_write_down
 .global _r2d_always_write_up
 .global _r2d_always_read_down
 .global _r2d_always_read_up

 .global _r2d_never_write
 .global _r2d_lcd_start_nothing

 .global _r2d_start_get_color

 .def _p_r2d_blit_foreground
 .def _p_r2d_blit_background

  .bss _r2d_blit_foreground,4,4,4
  .bss _r2d_blit_background,4,4,4

 
 .ref _r2d_color_alpha_operator
 .ref _r2d_color_framebuffer_foreground_pixel

 .def _r2d_icolor_alpha_op
 .def _r2d_icolor_foreground_pixel_test
 
 

 .global _r2d_color_start_copy
 .global _r2d_color_start_or
 .global _r2d_color_start_and
 .global _r2d_color_start_xor
 .global _r2d_color_start_notcopy
 .global _r2d_color_start_notor
 .global _r2d_color_start_notand
 .global _r2d_color_start_notxor
 .global _r2d_color_start_alpha
 .global _r2d_color_start_erase
 .global _r2d_color_start_foreground_pixel
 

_r2d_color_start_copy:
      MOV calca,calca
      MOV calcb,calca
      MOV calcb,calcb
_r2d_color_end_copy

_r2d_color_start_or:
      MOVS calca,calca,LSL #8
      MOVNEQ calcb,calca,LSR #8
	  NOP
_r2d_color_end_or

_r2d_color_start_and:
      MOV calca,calca
      AND calcb,calcb,calca
      MOV calcb,calcb
_r2d_color_end_and

_r2d_color_start_xor:
      MOV calca,calca
      EOR calcb,calcb,calca
      MOV calcb,calcb
_r2d_color_end_xor

_r2d_color_start_notcopy:
      MOV calca,calca
      MVN calcb,calca
      MOV calcb,calcb
_r2d_color_end_notcopy

_r2d_color_start_notor:
      MOV calca,calca
      ORR calcb,calcb,calca
      MVN calcb,calcb
_r2d_color_end_notor

_r2d_color_start_notand:
      MOV calca,calca
      AND calcb,calcb,calca
      MVN calcb,calcb
_r2d_color_end_notand

_r2d_color_start_notxor:
      MOV calca,calca
      EOR calcb,calcb,calca
      MVN calcb,calcb
_r2d_color_end_notxor

_r2d_color_start_erase:
      MOVS calca,calca,LSL #8
      MOVNEQ calcb,calca,LSR #8
	  NOP
_r2d_color_end_erase

_r2d_color_start_alpha
  ; Identifying code telling the patcher that a special
  ; construct required to branch to a C function is used
    .long BRANCH_ID
  ; The absolute address of the C function which is going to be
  ; converted to a PC relative offset by the patcher
    .long _r2d_icolor_alpha_op
_r2d_color_stop_alpha

_r2d_color_start_foreground_pixel
  ; Identifying code telling the patcher that a special
  ; construct required to branch to a C function is used
    .long BRANCH_ID
  ; The absolute address of the C function which is going to be
  ; converted to a PC relative offset by the patcher
    .long _r2d_icolor_foreground_pixel_test
_r2d_color_stop_foreground_pixel





  ; Stub function allowing to branch to a C one whose interface
  ; is UINT32 r2d_lcd_some_operator(UINT32 old,UINT32 value)
_r2d_icolor_alpha_op:
    R2D_OP_SAVE_CONTEXT
    BL _r2d_color_alpha_operator
    R2D_OP_RESTORE_CONTEXT

  ; Check kind of pixel
_r2d_icolor_foreground_pixel_test:
    R2D_COL_SAVE_CONTEXT
    BL _r2d_color_framebuffer_foreground_pixel
    R2D_COL_RESTORE_CONTEXT

  ; First instruction replacing ".long BRANCH_ID" when code is patched
_r2d_start_branch_inst
    STMFD SP!, {calca}

_r2d_stop_branch_inst
    LDMFD SP!, {calca}

  ; Code reading the foreground and background colors
  ; from a const table
_r2d_start_get_color
     LDRNE calca,_p_r2d_blit_foreground
     LDREQ calca,_p_r2d_blit_background
     LDR calca,[calca]
_r2d_stop_get_color

  ; Code doing nothing to removed patch
_r2d_lcd_start_nothing
     MOV calca,calca
     MOV calca,calca
     MOV calca,calca
_r2d_lcd_stop_nothing

  ; Force writing of value when dst is R2D color framebuffer
  ; (down mode)
_r2d_always_write_down
     STR dstvalue,[p_dst_current],#4

  ; Force writing of value when dst is R2D color framebuffer
  ; (up mode)
_r2d_always_write_up
     STR dstvalue,[p_dst_current],#-4

  ; Force reading of src when src is R2D color framebuffer
_r2d_always_read_down:
    LDR src_current,[p_src_current,#4]!

  ; Force reading of src when src is R2D color framebuffer
_r2d_always_read_up:
    LDR src_current,[p_src_current,#-4]!


  ; Remove force writing
_r2d_never_write
     MOV dstvalue,dstvalue

  
 
  ; Array containing current foreground and background colors
  .align 4
_p_r2d_blit_foreground:  .field _r2d_blit_foreground,32

  .align 4
_p_r2d_blit_background:  .field _r2d_blit_background,32



 .endif
 .end
