 
 .ref _r2d_start_branch_inst
 .ref _r2d_stop_branch_inst
 .ref _r2d_load_foreground
 .ref _r2d_load_background

 .ref _r2d_blit_foreground
 .ref _r2d_blit_background

 .ref _r2d_always_write_down
 .ref _r2d_always_write_up

 .ref _r2d_never_write
 .ref _r2d_lcd_start_nothing

 .ref _p_r2d_blit_foreground
 .ref _p_r2d_blit_background

BRANCH_ID .set 0xFF000000

;------------------------------------
;
; Context for drawing mode operators
;
; Result in calcb (R4)
R2D_OP_SAVE_CONTEXT .macro
  STMFD SP!, {R0,R1,R2,R3,R5,R6,R7,R8,R9,R10,R11,R12,R14}
  LDR R1,[SP,#52] ; Read (calca)
  MOV R0,calcb ; Read calcb (dst = old which is going to be replaced
               ; by computed value)
 .endm

R2D_OP_RESTORE_CONTEXT .macro
   MOV calcb,R0 ; Save result of C function into calcb
   LDMFD SP!, {R0,R1,R2,R3,R5,R6,R7,R8,R9,R10,R11,R12,R14}
   MOV PC,LR ; Return
 .endm

;------------------------------------
;
; Context for foreground detection
;
; Result in calca (R4)
R2D_COL_SAVE_CONTEXT .macro
  STMFD SP!, {R0,R1,R2,R3,R5,R6,R7,R8,R9,R10,R11,R12,R14}
  LDR R1,[R0,#S_FRAME.p_local_src_gc_ind]; Read (src_gc)
  LDR R0,[SP,#52] ; Read (calca)
 .endm

R2D_COL_RESTORE_CONTEXT .macro
   MOV LR,R0
   STR LR,[SP,#52] ; Save result of C function into calca
              ; calca color has been overrided by foreground/
              ; or background color of calcb
   LDMFD SP!, {R0,R1,R2,R3,R5,R6,R7,R8,R9,R10,R11,R12,R14}
   
   MOV PC,LR ; Return
 .endm

;------------------------------------
;
; Context for color conversion
;
; Result in calca (R4)
R2D_COLCONV_SAVE_CONTEXT .macro
  STMFD SP!, {R0,R1,R2,R3,R5,R6,R7,R8,R9,R10,R11,R12,R14}
  LDR R0,[SP,#52] ; Read (calca)
 .endm

R2D_COLCONV_RESTORE_CONTEXT .macro
   MOV calca,R0
   STR calca,[SP,#52] ; Save result of C function into calca
   LDMFD SP!, {R0,R1,R2,R3,R5,R6,R7,R8,R9,R10,R11,R12,R14}
   
   MOV PC,LR ; Return
 .endm

