 ;.if (_R2D_CONFIG_ASM_INC_ == 0)
_R2D_CONFIG_ASM_INC_ .set 1


R2D_ON .set 1
R2D_OFF .set 0

; Color mode for the LCD
R2D_MONOCHROME .set 0
R2D_COLOR .set 1

; Mode of refresh for the LCD
R2D_VERTICAL .set 0
R2D_HORIZONTAL .set 1

; List of kind of supported LCDs
R2D_SIMPLE_LCD .set 1
R2D_PC_COLOR_LCD .set 2
R2D_MIRRORED_LCD .set 3
R2D_CUSTOMER_LCD .set 4
R2D_HORIZONTAL_LCD .set 5
R2D_BOARD_COLOR_LCD .set 6
R2D_BOARD_DSAMPLE_LCD .set 7
R2D_BOARD_BW_DSAMPLE_LCD .set 8

;
;
;   Riviera 2D configuration
;
;


; ln2 of dimension of dithering matrix
; (must change code if that value is changed)
R2D_DITHERING_DIMENSION .set 2

R2D_DEBUG .set R2D_ON



R2D_REFRESH_PERIOD .set 40 ; ms

   .if R2D_LCD_TEST = 1
R2D_EMBEDDED_LCD .set R2D_BOARD_COLOR_LCD 
  .elseif BOARD = 8      ; C-Sample SRAM CS0
R2D_EMBEDDED_LCD .set R2D_MIRRORED_LCD
  .elseif BOARD = 9  ; C-Sample Flash CS0
R2D_EMBEDDED_LCD .set R2D_MIRRORED_LCD
  .elseif BOARD = 40 ; D-Sample SRAM CS0
R2D_EMBEDDED_LCD .set R2D_BOARD_DSAMPLE_LCD
  .elseif BOARD = 41 ; D-Sample Flash CS0
R2D_EMBEDDED_LCD .set R2D_BOARD_DSAMPLE_LCD
  .endif 

 

; Launch R2D_REFRESH_LOOP to estimate the time
; taken by one loop
R2D_BENCHMARKING .set R2D_OFF
R2D_REFRESH_LOOP .set 100


;
;
;  Hardware dependence
;
;

; Shift by 2 to get the size of a long int
R2D_LONGSIZE_FACTOR .set 2  

; ln2 of the size of a memory word in bits
; (2^5 = 32 bits)
R2D_MEMORY_WORD .set 5

;
;
;  Values used internally
;
;

 .if (R2D_EMBEDDED_LCD = R2D_SIMPLE_LCD)
 .include "LCDs/Simple/R2D_simple_lcd_i.inc"
 .endif

; Color LCD is just a simulation on PC and is using the
; color framebuffers
 .if (R2D_EMBEDDED_LCD = R2D_PC_COLOR_LCD)
 .include "LCDs/ColorPC/R2D_pc_color_lcd_i.inc"
 .endif

; Color LCD is just a simulation on PC and is using the
; color framebuffers
 .if (R2D_EMBEDDED_LCD = R2D_MIRRORED_LCD)
 .include "LCDs/Mirrored/R2D_mirrored_lcd_i.inc"
 .endif

 .if (R2D_EMBEDDED_LCD = R2D_CUSTOMER_LCD)
 .include "LCDs/Customer/R2D_customer_lcd_i.inc"
 .endif

 .if (R2D_EMBEDDED_LCD = R2D_HORIZONTAL_LCD)
 .include "LCDs/Horizontal/R2D_horizontal_lcd_i.inc"
 .endif

 .if (R2D_EMBEDDED_LCD = R2D_BOARD_COLOR_LCD)
 .include "LCDs/ColorBoard/R2D_board_color_lcd_i.inc"
 .endif

 .if (R2D_EMBEDDED_LCD = R2D_BOARD_DSAMPLE_LCD)
 .include "LCDs/D_Sample/R2D_board_dsample_i.inc"
 .endif

 .if (R2D_EMBEDDED_LCD = R2D_BOARD_BW_DSAMPLE_LCD)
 .include "LCDs/BW_D_Sample/R2D_board_bw_dsample_i.inc"
 .endif

 .if (R2D_ASM = R2D_ON)

R2D_DITHERING .set R2D_OFF

; Mask used to write or read a pixel value from a memory word
; It is also used in monochrome mode to extract the intensity level
; In color mode, a pixel will contain several intensity
; level and another mask to extract components should be used
	.if (R2D_PIXEL_DEPTH = 32)
R2D_PIXEL_MASK .set 0xFFFFFFFF
	.else
R2D_PIXEL_MASK .set (~(-1<<R2D_PIXEL_DEPTH))
	.endif

; Pixel value mask for dithered levels
R2D_DITHERED_MASK .set (~(-1<<R2D_DITHERING_DIMENSION))


 .if (R2D_PIXELS_PER_MEMORY_WORD = 0)

  ; Position of the pixel in a memory word is extracted with
  ; that mask applied to the pixel horizontal or vertical 
  ; coordinate (depending on the REFRESH mode)
  ; It allows to convert between unit pixels to unit memory words
R2D_WORD_POSITION_MASK .set 0

  ; Extension of vertical or horizontal for memory alignments
  ; constraints
  .if (R2D_REFRESH = R2D_VERTICAL)
R2D_MWHEIGHT .set R2D_HEIGHT
  .else
R2D_MWWIDTH .set R2D_WIDTH
  .endif


 .else
  ; Above formula are right when the number of pixels
  ; can be divided by 2 (so R2D_PIXELS_PER_MEMORY_WORD != 0 )

  ; Position of the pixel in a memory word is extracted with
  ; that mask applied to the pixel horizontal or vertical 
  ; coordinate (depending on the REFRESH mode)
  ; It allows to convert between unit pixels to unit memory words
R2D_WORD_POSITION_MASK .set (~(-1<<R2D_PIXELS_PER_MEMORY_WORD))

  ; Extension of vertical or horizontal for memory alignments
  ; constraints (the extension is done by excess. Sometime one
  ; word may be added although it is not really needed)
  .if (R2D_REFRESH = R2D_VERTICAL)
R2D_MWHEIGHT .set ((R2D_HEIGHT>>R2D_PIXELS_PER_MEMORY_WORD)+1)
  .else
R2D_MWWIDTH .set ((R2D_WIDTH>>R2D_PIXELS_PER_MEMORY_WORD)+1)
  .endif

  ; Extend lengths to a integer number of memory words
  ; and return new length in memory word units

  

 .endif
; Start of description of metrics values
; for each char
; The first values are the global ones for the font
R2D_METRIC_START .set 8


; Position of buffer width value relative
; to start of char metrics in a font metric array
R2D_BUFFER_WIDTH_POS .set (-5)


  .endif

 ;.endif



