#include "rv/general.h"
#include "rvf/rvf_api.h"
#include "r2d/r2d_config.h"
#include "r2d/r2d.h"
#include "r2d/r2d_i.h"
#include "r2d/r2d_independance_layer.h"

#if (R2D_PIXEL_DEPTH == 32)
#define R2D_PIXEL_DOWN_OUT(a) (0)
#define R2D_PIXEL_UP_OUT(a) (0)
#else
#define R2D_PIXEL_DOWN_OUT(a) (a>>R2D_PIXEL_DEPTH)
#define R2D_PIXEL_UP_OUT(a) (a<<R2D_PIXEL_DEPTH)
#endif


#if (R2D_ASM == R2D_ON)
extern void r2d_blit_la(UINT32 *a);
extern void r2d_blit_lb(UINT32 *a);

extern UINT32 r2d_lcd_start_copy;
extern UINT32 r2d_lcd_start_or;
extern UINT32 r2d_lcd_start_and;
extern UINT32 r2d_lcd_start_xor;
extern UINT32 r2d_lcd_start_notcopy;
extern UINT32 r2d_lcd_start_notor;
extern UINT32 r2d_lcd_start_notand;
extern UINT32 r2d_lcd_start_notxor;
extern UINT32 r2d_lcd_start_alpha;
extern UINT32 r2d_lcd_start_erase;
extern UINT32 r2d_lcd_start_foreground_pixel;

extern UINT32 r2d_color_start_copy;
extern UINT32 r2d_color_start_or;
extern UINT32 r2d_color_start_and;
extern UINT32 r2d_color_start_xor;
extern UINT32 r2d_color_start_notcopy;
extern UINT32 r2d_color_start_notor;
extern UINT32 r2d_color_start_notand;
extern UINT32 r2d_color_start_notxor;
extern UINT32 r2d_color_start_alpha;
extern UINT32 r2d_color_start_erase;
extern UINT32 r2d_color_start_foreground_pixel;

extern UINT32 r2d_start_get_color;


// Drawing mode
extern UINT32 r2d_sb_down1;
extern UINT32 r2d_sb_down2;
extern UINT32 r2d_sa_up1;
extern UINT32 r2d_sa_up2;

// Foreground detection
extern UINT32 r2d_sdb_down1;
extern UINT32 r2d_sdb_down2;
extern UINT32 r2d_sda_up1;
extern UINT32 r2d_sda_up2;

// Color conversion
extern UINT32 r2d_scb_down1;
extern UINT32 r2d_scb_down2;
extern UINT32 r2d_sca_up1;
extern UINT32 r2d_sca_up2;

extern UINT32 r2d_start_branch_inst;
extern UINT32 r2d_stop_branch_inst;
extern UINT32 r2d_blit_foreground;
extern UINT32 r2d_blit_background;
extern UINT32 r2d_skip_color_proc_a;
extern UINT32 r2d_end_ynb_color_dst_a;
extern UINT32 r2d_skip_color_proc_b;
extern UINT32 r2d_end_ynb_color_dst_b;

// Patch list for write_shift_pixel_down
extern UINT32 r2d_sft_dst_n_b_down1,r2d_sft_dst_n_b_down2;
extern UINT32 r2d_sft_srcb_n_b_down1,r2d_sft_srcb_n_b_down2;
extern UINT32 r2d_sft_dstc_n_b_down1,r2d_sft_dstc_n_b_down2;

extern UINT32 r2d_sft_src_c_b_down1,r2d_sft_src_c_b_down2;
extern UINT32 r2d_sft_b_c_b_down1,r2d_sft_b_c_b_down2;
extern UINT32 r2d_sft_dstb_c_b_down1,r2d_sft_dstb_c_b_down2;
extern UINT32 r2d_sft_d_c_b_down1,r2d_sft_d_c_b_down2;
extern UINT32 r2d_sft_dstc_c_b_down1,r2d_sft_dstc_c_b_down2;

// Patch list for write_shift_pixel_up
extern UINT32 r2d_sft_dst_n_a_up1,r2d_sft_dst_n_a_up2;
extern UINT32 r2d_sft_srcb_n_a_up1,r2d_sft_srcb_n_a_up2;
extern UINT32 r2d_sft_dstc_n_a_up1,r2d_sft_dstc_n_a_up2;

extern UINT32 r2d_sft_src_c_a_up1,r2d_sft_src_c_a_up2;
extern UINT32 r2d_sft_b_c_a_up1,r2d_sft_b_c_a_up2;

// Patch list fro shift_pixel_down
extern UINT32 r2d_sft_dst_n_downa,r2d_sft_dst_n_downb,r2d_sft_dst_n_downc;
extern UINT32 r2d_sft_srcb_n_downa,r2d_sft_srcb_n_downb,r2d_sft_srcb_n_downc;

extern UINT32 r2d_sft_src_c_downa,r2d_sft_src_c_downb,r2d_sft_src_c_downc;

// Patch list fro shift_pixel_up
extern UINT32 r2d_sft_dst_n_upa,r2d_sft_dst_n_upb,r2d_sft_dst_n_upc;
extern UINT32 r2d_sft_srcb_n_upa,r2d_sft_srcb_n_upb,r2d_sft_srcb_n_upc;

extern UINT32 r2d_sft_src_c_upa,r2d_sft_src_c_upb,r2d_sft_src_c_upc;

extern UINT32 r2d_sconvcolb_down1,r2d_econvcolb_down1;
extern UINT32 r2d_sconvcolb_down2,r2d_econvcolb_down2;
extern UINT32 r2d_sconvcola_up1,r2d_econvcola_up1;
extern UINT32 r2d_sconvcola_up2,r2d_econvcola_up2;
extern UINT32 r2d_start_lcd_to_color,r2d_start_color_to_lcd;

extern UINT32 r2d_always_write_down,r2d_always_write_up,r2d_never_write;
extern UINT32 r2d_swb_down1,r2d_swb_down2,r2d_swa_up1,r2d_swa_up2;

extern UINT32 r2d_skip_color_dst_a,r2d_skip_color_dst_b;
extern UINT32 r2d_always_skip;
extern UINT32 r2d_enda,r2d_endb;
extern UINT32 r2d_lcd_start_nothing;

UINT32* r2d_g_asm_lcd_operators[]=
{
   &r2d_lcd_start_copy,
   &r2d_lcd_start_or,
   &r2d_lcd_start_and,
   &r2d_lcd_start_xor,
   &r2d_lcd_start_notcopy,
   &r2d_lcd_start_notor,
   &r2d_lcd_start_notand,
   &r2d_lcd_start_notxor,
   &r2d_lcd_start_alpha,
   &r2d_lcd_start_erase
};

UINT32* r2d_g_asm_color_operators[]=
{
   &r2d_color_start_copy,
   &r2d_color_start_or,
   &r2d_color_start_and,
   &r2d_color_start_xor,
   &r2d_color_start_notcopy,
   &r2d_color_start_notor,
   &r2d_color_start_notand,
   &r2d_color_start_notxor,
   &r2d_color_start_alpha,
   &r2d_color_start_erase
};


extern void r2d_patch_color_conversion(T_R2D_GC_PTR gc);
extern void r2d_patch_shift(UINT32 *src,UINT32 shift);
extern void r2d_patch_branch(UINT32 *src,UINT32 *dst,BOOLEAN f);
extern void r2d_patch_get_color(UINT32* src,UINT32 *dst);
extern void r2d_patch_inst(UINT32* src,UINT32 *dst);
extern void r2d_patch_code_block(UINT32* src,UINT32 *dst);

extern void r2d_check_rectangle_overlap(INT16 src_x,INT16 src_y,INT16 dst_x,INT16 dst_y,
INT32 width,INT32 height,
INT32 *h_direction,INT32 *v_direction);

/*********************

  R2D ASM MODE

**********************/


// Requires shapes in graphic context coordinates
void           r2d_blit_asm(T_R2D_GC_PTR src_gc,T_R2D_GC_PTR dst_gc,
                             T_R2D_SHAPE_PTR src_rectangle, 
							 T_R2D_SHAPE_PTR dst_rectangle,
							 R2D_BOOLEAN use_foreground_color,INT32 srcdst)
{
    T_R2D_GC_PTR local_src_gc,local_dst_gc;
    UINT32 *p_src,*p_dst,*p_src_current,*p_dst_current,*p_src_start,*p_dst_start;
    INT16 rect_width,rect_height,src_x,src_y,dst_x,dst_y;
    INT16 src_offset,dst_offset,src_height,dst_height;
    INT16 xnb,ynb,src_nb_rows,dst_nb_rows;
    INT16 src_dy,dst_dy,end_dst_dy,end_src_dy; // distance from word boundary
    INT16 shift; // relative position (modulo a memory word) between both rectangles
    // in bits 
    INT16 current_src_dy,current_dst_dy;
    INT16 temp,dstcounter,srccounter;


    UINT32 dstvalue,dst_current;
    UINT32 srcvalue,src_current;
    INT32  h_direction,v_direction;
	INT16 x,y;
	BOOLEAN compensate;
    UINT32* code_dest;
    UINT32* code_src;

    compensate=TRUE;

    // Copy argument to local ones for enabling asm access
   
    local_src_gc=src_gc;
    local_dst_gc=dst_gc;

    
    

    {

    p_src=((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)src_gc)->p_frame_buffer))->p_memory_words;
    p_dst=((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)dst_gc)->p_frame_buffer))->p_memory_words;

    rect_width=r2d_get_xmax(src_rectangle)-r2d_get_xmin(src_rectangle);
    rect_height=r2d_get_ymax(src_rectangle)-r2d_get_ymin(src_rectangle);

    
    if ((rect_width<=0) || (rect_height<=0))
		goto end_blit_b;
    
    src_x=r2d_get_xmin(src_rectangle);
    src_y=r2d_get_ymin(src_rectangle);

    dst_x=r2d_get_xmin(dst_rectangle);
    dst_y=r2d_get_ymin(dst_rectangle);

    if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_LCDCOLOR))
       src_dy=(src_y & R2D_WORD_POSITION_MASK);
    else
       src_dy=0;

    if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_COLORLCD))
	  dst_dy=(dst_y & R2D_WORD_POSITION_MASK);
    else
      dst_dy=0;
	
    // Clipping convention such end_dst_dy is the first y position which must not
    // be copied at the end of a column
    //printf("dest y max=%d\n",r2d_get_ymax(dst_rectangle));
    if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_COLORLCD))
       end_dst_dy=((r2d_get_ymax(dst_rectangle)-1) & R2D_WORD_POSITION_MASK) ;
	else
       end_dst_dy=0;

    if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_LCDCOLOR))
       end_src_dy=((r2d_get_ymax(src_rectangle)-1) & R2D_WORD_POSITION_MASK) ;
	else
       end_src_dy=0;

    //printf("dst_dy, end_dst_dy before reverse=%d,%d\n",dst_dy,end_dst_dy);
    // Number of rows is word containing last point - word containing first point
    // + 1

    // We remove - 1 because last PIXEL is at 1 from the frontier line
    if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_COLORLCD))
       dst_nb_rows=R2D_ALIGNED_MWLENGTH(r2d_get_ymax(dst_rectangle)-1)-R2D_ALIGNED_MWLENGTH(dst_y)+1;
    else
       dst_nb_rows=r2d_get_ymax(dst_rectangle)-1-dst_y+1;

    if ((srcdst==R2D_LCDCOLOR) || (srcdst==R2D_LCDLCD))
      src_nb_rows=R2D_ALIGNED_MWLENGTH(r2d_get_ymax(src_rectangle)-1)-R2D_ALIGNED_MWLENGTH(src_y)+1;
    else
      src_nb_rows=r2d_get_ymax(src_rectangle)-1-src_y+1;

    //printf("src_nb_rows %d\n",src_nb_rows);
    //printf("dst_nb_rows %d\n",dst_nb_rows);

    
    h_direction=1;
    v_direction=1;
    if (((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)src_gc)->p_frame_buffer))==
       ((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)dst_gc)->p_frame_buffer)))
      r2d_check_rectangle_overlap(src_x,src_y,dst_x,dst_y,
      rect_width,rect_height,&h_direction,&v_direction);

    //printf("h,v=%d,%d\n",h_direction,v_direction);


#if (R2D_REFRESH == R2D_VERTICAL)      
      src_height=((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)src_gc)->p_frame_buffer))->height;
      dst_height=((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)dst_gc)->p_frame_buffer))->height;
#else
	  src_height=((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)src_gc)->p_frame_buffer))->width;
      dst_height=((T_R2D_FRAMEBUFFER*)(((T_R2D_GC*)dst_gc)->p_frame_buffer))->width;
#endif

      if ((srcdst==R2D_LCDCOLOR) || (srcdst==R2D_LCDLCD))
	     src_offset=R2D_ALIGNED_MWLENGTH(src_height);
      else
	     src_offset=src_height;

      if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_COLORLCD))
         dst_offset=R2D_ALIGNED_MWLENGTH(dst_height);
      else
         dst_offset=dst_height;


      //printf("%08X,dst offset=%08X\n",p_dst,dst_offset);

      if ((srcdst==R2D_LCDCOLOR) || (srcdst==R2D_LCDLCD))
         p_src_start=p_src
           +((src_x*src_offset+(src_y>>R2D_PIXELS_PER_MEMORY_WORD)));
      else
         p_src_start=p_src
           +((src_x*src_offset+(src_y)));

      if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_COLORLCD))
        p_dst_start=p_dst
           +((dst_x*dst_offset+(dst_y>>R2D_PIXELS_PER_MEMORY_WORD)));
      else
        p_dst_start=p_dst
           +((dst_x*dst_offset+(dst_y)));

      xnb=rect_width;

      //printf("src start %08X contains %08X\n",p_src_start,*p_src_start);
      //printf("dst start %08X contains %08X\n",p_dst_start,*p_dst_start);

      //printf("rect_width %d\n",rect_width);
      if (h_direction==-1)
      {
		x=r2d_get_xmax(dst_rectangle)-1;
        p_src_start+=(rect_width-1)*src_offset;
        p_dst_start+=(rect_width-1)*dst_offset;
      }
	  else
         x=r2d_get_xmin(dst_rectangle);

      //printf("src start %08X contains %08X\n",p_src_start,*p_src_start);
      //printf("dst start %08X contains %08X\n",p_dst_start,*p_dst_start);

      if (v_direction==-1)
      {
        p_src_start+=src_nb_rows-1;
        p_dst_start+=dst_nb_rows-1;

        temp=src_dy;
        src_dy=end_src_dy;
        end_src_dy=temp;

        temp=dst_dy;
        dst_dy=end_dst_dy;
        end_dst_dy=temp;
      }


      //printf("src start %08X contains %08X\n",p_src_start,*p_src_start);
      //printf("dst start %08X contains %08X\n",p_dst_start,*p_dst_start);

      //printf("dst_start=%08X contains %08X\n",p_dst_start,*p_dst_start);
      while(xnb!=0)
      {
        p_dst_current=p_dst_start;
        p_src_current=p_src_start;

        //printf("xnb=%d\n",xnb);
        //printf("src start %08X contains %08X\n",p_src_start,*p_src_start);
        //printf("dst start %08X contains %08X\n",p_dst_start,*p_dst_start);


        if ((srcdst==R2D_COLORCOLOR) || (srcdst==R2D_LCDCOLOR))
           ynb=dst_nb_rows;
        else
           ynb=dst_nb_rows-1; // no -1 when dest is R2D color
        
        if (v_direction==-1)
        {
		   y=r2d_get_ymax(dst_rectangle) - 1;
           if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_LCDCOLOR))
               current_src_dy=(1<<R2D_PIXELS_PER_MEMORY_WORD)-1;
           else
               current_src_dy=0;

           if ((srcdst==R2D_LCDLCD) || (srcdst==R2D_COLORLCD))
               current_dst_dy=(1<<R2D_PIXELS_PER_MEMORY_WORD)-1;
           else
               current_dst_dy=0;
        }
        else
        {
           current_src_dy=0;
           current_dst_dy=0;
		   y=r2d_get_ymin(dst_rectangle);
        }
        
        dstcounter=(1<<R2D_PIXELS_PER_MEMORY_WORD);
        srccounter=(1<<R2D_PIXELS_PER_MEMORY_WORD);
        
        dst_current=*p_dst_current;
        src_current=*p_src_current;
        //printf("src_current=%08X, dst_current=%08X\n",src_current,dst_current);
        temp=0;
        //printf("new column\n dst=%08X\n",p_dst_current);
        //printf("current_dst_dy =%d, dst_dy=%d\n",current_dst_dy,dst_dy);
        dstvalue=0;

		if (v_direction==-1)
		  r2d_blit_la((UINT32*)&local_src_gc);
        else
          r2d_blit_lb((UINT32*)&local_src_gc);

		

        
        dstvalue=0;
        
          
        if (h_direction==-1)
        {
          p_src_start-=src_offset;
          p_dst_start-=dst_offset;
		  x--;
        }
        else
        {
          p_src_start+=src_offset;
          p_dst_start+=dst_offset;
		  x++;
        }

        xnb--;
      }

      
      
    
  }
end_blit_b:dstvalue=0;
}
#endif
