/* Used by refresh task to extract bytes from the
framebuffer */


#define R2D_MB_PRIM_SIZE 2000

extern UINT32 r2d_p_refresh_buffer[4*R2D_WIDTH*R2D_MWHEIGHT];


static void r2d_refresh_task_init(void)
{
	INT16 i; 
	UINT32 *p;

	uwire_init_lcd();

	lcd_transmit_cmd(0x08); //display blank
	lcd_transmit_cmd(0x25); //power down use extended instructions
	lcd_transmit_cmd(0x04);	//set temperature coefficient to zero
	lcd_transmit_cmd(0x14); //set bias voltage level n=3
	lcd_transmit_cmd(0xc5); //set Vlcd to 7.2
	lcd_transmit_cmd(0x20); //set PD=0->chip activate ,H=0-> basic instruction set
	

	

	lcd_transmit_cmd(0x0d); //inverse video mode
	
	lcd_transmit_cmd(0x0c); //normal video mode
	
	p=r2d_p_refresh_buffer;
	for(i=0;i<4*R2D_WIDTH*R2D_MWHEIGHT;i++)
	{
		*p++=0;
	}
}

static void r2d_refresh_task_kill(void)
{
	
}

static void r2d_dithering_init(void)
{
   R2D_MALLOC(r2d_mb_id,UINT32,sizeof(UINT32)*4,r2d_g_dithering_matrix);
   r2d_g_dithering_matrix[0]=0;
   r2d_g_dithering_matrix[1]=2;
   r2d_g_dithering_matrix[2]=3;
   r2d_g_dithering_matrix[3]=1;
}
