
#ifndef _WINDOWS
	#include "r2d/uwire.h"
#endif



//value to transmit in order to set the x position on the lcd
static const char x_position[DISP_PIXELWIDTH] ={0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
				  		0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
				  		0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
				  		0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,						  
				  		0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
				  		0xd0,0xd1,0xd2,0xd3};

//value to transmit in order to set the y position on the lcd
static const char y_position[DISP_PAGEHEIGHT] ={0x40,0x41,0x42,0x43,0x44,0x45};


UINT32 r2d_p_refresh_buffer[4*R2D_WIDTH*R2D_MWHEIGHT];





/********************************************************************/
/*	set the DC input to high for data transmission	 				*/
/*																	*/
/********************************************************************/


void r2d_lcd_power_on(void)
{
}

void r2d_lcd_power_off(void)
{
}

void r2d_refresh(void)
{
	UINT16 i,j,k;

    UINT32 v;
	UINT32 *p;

	HDC bm;

	bm=lcd_get_dc();


    //rvf_send_trace("R2D REFRESH",strlen("R2D REFRESH"), NULL_PARAM, 
	//		   RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_XXX );

	p=r2d_g_framebuffer->p_memory_words;


    
	i=0;
	while(i<R2D_WIDTH)
	{
	  j=0;
	  while(j<R2D_MWHEIGHT*32)
	  {
            // If can read a new word from framebuffer
		    // and write it to refresh buffer
		    //if (r2d_p_refresh_state[i]+4<=R2D_MWHEIGHT*4)
		  v=*p++;
		  for(k=0;k<32;k++)
		  {
                //r2d_p_refresh_state[i]+=4;
			    
				if (v & 1)
			    SetPixelV(bm,i,j+k ,
		          0);
				else
			      SetPixelV(bm,i,j+k ,
		          RGB(197,210,216));
			    v=v>>1;

          }

       j+=32;
		
            
      }
	  i++;
	  
    } 
   
	r2d_reinit_update_region();


	lcd_refresh();



}



