#include "r2d/lcds/horizontal/font_bitmap_system.h"
#include "r2d/lcds/horizontal/font_metrics_system.h"
#include "r2d/lcds/horizontal/font_table_system.h"

#include "r2d/lcds/horizontal/font_bitmap_proportional.h"
#include "r2d/lcds/horizontal/font_metrics_proportional.h"
#include "r2d/lcds/horizontal/font_table_proportional.h"


r2d_new_font(system);

r2d_new_font(proportional);


/* Cleaning font structures when and error occurs at init */
void r2d_font_clean()
{
	r2d_clean_font(system);
	r2d_clean_font(proportional);
}

T_R2D_ERROR r2d_font_init()
{
   UINT16 length;
   UINT32 *p;
   UINT32 h,v,words;
   T_R2D_ERROR ret_err;

   ret_err=R2D_OK;

   r2d_init_font(system);
   if (ret_err!=R2D_OK)
	   return(ret_err);

   r2d_init_font(proportional);
   if (ret_err!=R2D_OK)
	   return(ret_err);



   r2d_init_font_field(R2D_SMALL_SYSTEM_NORMAL,system);
   r2d_init_font_field_without_bold(R2D_SMALL_SYSTEM_BOLD,system);
   r2d_init_font_field(R2D_SMALL_SYSTEM_ITALIC,system);
   r2d_init_font_field_without_bold(R2D_SMALL_SYSTEM_BOLD_ITALIC,system);

   r2d_init_font_field(R2D_MEDIUM_SYSTEM_NORMAL,system);
   r2d_init_font_field_without_bold(R2D_MEDIUM_SYSTEM_BOLD,system);
   r2d_init_font_field(R2D_MEDIUM_SYSTEM_ITALIC,system);
   r2d_init_font_field_without_bold(R2D_MEDIUM_SYSTEM_BOLD_ITALIC,system);

   r2d_init_font_field(R2D_BIG_SYSTEM_NORMAL,system);
   r2d_init_font_field_without_bold(R2D_BIG_SYSTEM_BOLD,system);
   r2d_init_font_field(R2D_BIG_SYSTEM_ITALIC,system);
   r2d_init_font_field_without_bold(R2D_BIG_SYSTEM_BOLD_ITALIC,system);

   r2d_init_font_field(R2D_SMALL_TYPEWRITER_NORMAL,system);
   r2d_init_font_field_without_bold(R2D_SMALL_TYPEWRITER_BOLD,system);
   r2d_init_font_field(R2D_SMALL_TYPEWRITER_ITALIC,system);
   r2d_init_font_field_without_bold(R2D_SMALL_TYPEWRITER_BOLD_ITALIC,system);

   r2d_init_font_field(R2D_MEDIUM_TYPEWRITER_NORMAL,system);
   r2d_init_font_field_without_bold(R2D_MEDIUM_TYPEWRITER_BOLD,system);
   r2d_init_font_field(R2D_MEDIUM_TYPEWRITER_ITALIC,system);
   r2d_init_font_field_without_bold(R2D_MEDIUM_TYPEWRITER_BOLD_ITALIC,system);

   r2d_init_font_field(R2D_BIG_TYPEWRITER_NORMAL,system);
   r2d_init_font_field_without_bold(R2D_BIG_TYPEWRITER_BOLD,system);
   r2d_init_font_field(R2D_BIG_TYPEWRITER_ITALIC,system);
   r2d_init_font_field_without_bold(R2D_BIG_TYPEWRITER_BOLD_ITALIC,system);

 r2d_init_font_field(R2D_SMALL_PROPORTIONAL_NORMAL,proportional);
   r2d_init_font_field_without_bold(R2D_SMALL_PROPORTIONAL_BOLD,proportional);
   r2d_init_font_field(R2D_SMALL_PROPORTIONAL_ITALIC,proportional);
   r2d_init_font_field_without_bold(R2D_SMALL_PROPORTIONAL_BOLD_ITALIC,proportional);

   r2d_init_font_field(R2D_MEDIUM_PROPORTIONAL_NORMAL,proportional);
   r2d_init_font_field_without_bold(R2D_MEDIUM_PROPORTIONAL_BOLD,proportional);
   r2d_init_font_field(R2D_MEDIUM_PROPORTIONAL_ITALIC,proportional);
   r2d_init_font_field_without_bold(R2D_MEDIUM_PROPORTIONAL_BOLD_ITALIC,proportional);

   r2d_init_font_field(R2D_BIG_PROPORTIONAL_NORMAL,proportional);
   r2d_init_font_field_without_bold(R2D_BIG_PROPORTIONAL_BOLD,proportional);
   r2d_init_font_field(R2D_BIG_PROPORTIONAL_ITALIC,proportional);
   r2d_init_font_field_without_bold(R2D_BIG_PROPORTIONAL_BOLD_ITALIC,proportional);

   return(R2D_OK);
}