#ifndef _R2D_ESAMPLE_CMDS_H_
#define _R2D_ESAMPLE_CMDS_H_

// #define LCD_activate *(volatile unsigned short*) 0x2400004 = 0xA6
// #define LCD_deactivate *(volatile unsigned short*) 0x2400000 = 0xA6


#define LCD_DISON 0xAF
#define LCD_DISOFF 0xAE
#define LCD_DISNOR 0xA6
#define LCD_DISINV 0xA7
#define LCD_DISCTL 0xCA
#define LCD_GCP64 0xCB
#define LCD_GCP16 0xCC
#define LCD_GSSET 0xCD
#define LCD_SLPIN 0x95
#define LCD_SLPOUT 0x94
#define LCD_SD_PSET 0x75
#define LCD_MD_PSET 0x76
#define LCD_SD_CSET 0x15
#define LCD_MD_CSET 0x16
#define LCD_DATCTL 0xBC
#define LCD_RAMWR 0x5C
#define LCD_RAMRD 0x5D
#define LCD_PTLIN 0xA8
#define LCD_PTLOUT 0xA9
#define LCD_ASCSET 0xAA
#define LCD_SCSTART 0xAB
#define LCD_VOLCTL 0xC6
#define LCD_NOP 0x25
#define LCD_OSCISEL 0x7
#define LCD_3500KSET 0xD1
#define LCD_3500KEND 0xD2
#define LCD_14MSET 0xD3
#define LCD_14MEND 0xD4



#define INIT_3500KSET 0x45
#define INIT_14MSET 0x4B
#define INIT_DATCTL 0x28 /* 5.6.5 bits for D-Sample */

#define INIT_OSCISEL 0x05
#define INIT_VOLCTL 0x1A /* 0x16*/ /* Nominel "volume" */
#define INIT_VOLCTL_Ton 0x98 /* Activate power-IC timer */
#define INIT_GSSET 0x00

#define DISCTL_PARAM_NBR   11
#define GCP64_PARAM_NBR    126
#define GCP16_PARAM_NBR    15
#define MD_PSET_PARAM_NBR  4
#define MD_CSET_PARAM_NBR  4
#define SD_PSET_PARAM_NBR  4
#define SD_CSET_PARAM_NBR  4
#define ASCSET_PARAM_NBR   7
#define SCSTART_PARAM_NBR  2

/*
extern const unsigned char INIT_DISCTL[DISCTL_PARAM_NBR];
extern const unsigned char INIT_GCP64[GCP64_PARAM_NBR];
extern const unsigned char INIT_GCP16[GCP16_PARAM_NBR];
extern const unsigned char INIT_MD_PSET[MD_PSET_PARAM_NBR];
extern const unsigned char INIT_MD_CSET[MD_CSET_PARAM_NBR] ;

extern const unsigned char INIT_SD_PSET[SD_PSET_PARAM_NBR];
extern const unsigned char INIT_SD_CSET[SD_CSET_PARAM_NBR];

extern const unsigned char INIT_ASCSET[ASCSET_PARAM_NBR];
extern const unsigned char INIT_SCSTART[SCSTART_PARAM_NBR];
*/
#endif