/* Used by refresh task to extract bytes from the
framebuffer */

#define __STANDARD_H__ /* Avoid to define UBYTE, SYS_UWORD16 and UINT32. */

#include "r2d/lcds/e_sample/r2d_task_init_i.h"
#include "r2d/lcds/e_sample/r2d_tfd_lcd.h"
#include "r2d/r2d_i.h"
#include "r2d/r2d_independance_layer.h"
#include "r2d/r2d_env.h"

const unsigned char INIT_DISCTL[DISCTL_PARAM_NBR] = { 0xDE,0x01,0x64,0x00,0x1B,0xF4,0x00,0xDC,0x00,0x02,0x00};

const unsigned char INIT_GCP64[GCP64_PARAM_NBR] = {
		0x15,0x00,0x29,0x00,0x3E,0x00,0x51,0x00,		0x65,0x00,0x7A,0x00,0x8D,0x00,0XA1,0x00,
		0XB6,0x00,0XC7,0x00,0XD8,0x00,0XEB,0x00,		0XFB,0x00,0x0B,0x01,0X1B,0x01,0X27,0x01,
		0x34,0x01,0x41,0x01,0x4C,0x01,0x55,0x01,		0x5F,0x01,0x68,0x01,0x70,0x01,0x78,0x01,
		0x7E,0x01,0x86,0x01,0x8C,0x01,0x94,0x01,		0x9B,0x01,0XA1,0x01,0xA4,0x01,0xA9,0x01,
		0xAD,0x01,0xB2,0x01,0xB7,0x01,0xBC,0x01,		0xC0,0x01,0xC4,0x01,0xC8,0x01,0xCB,0x01,
		0xCF,0x01,0xD2,0x01,0xD5,0x01,0xD8,0x01,		0xDB,0x01,0xE0,0x01,0xE3,0x01,0xE6,0x01,
		0xE8,0x01,0xEB,0x01,0xEE,0x01,0xF1,0x01,		0xF3,0x01,0xF8,0x01,0xF9,0x01,0xFC,0x01,
		0x00,0x02,0x03,0x02,0x07,0x02,0x09,0x02,		0x0E,0x02,0x13,0x02,0x1C,0x02 };
const unsigned char INIT_GCP16[GCP16_PARAM_NBR] = {
	0x1A,0x31,0x48,0x54,0x5F,0x67,0x70,0x76,0x7C,0x80,0x83,0x84,0x85,0x87,0x96 };

const unsigned char INIT_MD_PSET[MD_PSET_PARAM_NBR] = { 0x00, 0x01, 0x00, 0x01 };
const unsigned char INIT_MD_CSET[MD_CSET_PARAM_NBR] = { 0x00, 0x02, 0x00, 0x02 };

const unsigned char INIT_SD_PSET[SD_PSET_PARAM_NBR] = { 0, 0, 219, 0 };
const unsigned char INIT_SD_CSET[SD_CSET_PARAM_NBR] = { 2, 0, 177, 0 };

const unsigned char INIT_ASCSET[ASCSET_PARAM_NBR] = { 0x00, 0x00, 0xDB, 0x00, 0xDC, 0x00, 0x01 };
const unsigned char INIT_SCSTART[SCSTART_PARAM_NBR] = { 0x00, 0x00 };


extern T_RVF_MB_ID r2d_mb_id;


static void r2d_nop_delay(SYS_UWORD32 ms)
{
    unsigned short a;
    while (ms-- > 0) for (a=0;a<1000;a++) asm(" nop");
}




 void r2d_refresh_task_init(void)
{

#ifndef _WINDOWS

  SYS_UWORD32  i,j,k;
  SYS_UWORD16 command;
  SYS_UWORD16 data;
  SYS_UWORD16 tab_tmp[264];
  SYS_UWORD16 *ptr;

  command = LCD_DISNOR; /* LCD_activate */
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);


  command = LCD_DISOFF; // this command turns ON the full-screen display 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);


  command = LCD_SLPIN; // this command causes the LCD module to enter the sleep mode 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  

  command = LCD_DISNOR; // this command turns the display mode to NORMAL 
                        // without rewriting the content of the display data RAM 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
 
  r2d_nop_delay(10);

  command = LCD_DATCTL;  // data mode of the MPU interface 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  r2d_nop_delay(10);
  data =  0x08;
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);

  r2d_nop_delay(10);

  command = LCD_GSSET; // this command and the subsequent parameter make the grey scale mode 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  r2d_nop_delay(10);
  data = INIT_GSSET; // 64 gradients 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);


  r2d_nop_delay(100);


  command = LCD_DISCTL; // this command and the subsequent parameter make various display timing settings 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr = (SYS_UWORD16 *)&INIT_DISCTL[0];

  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 6, C_LCD_IF_DISPLAY);

  r2d_nop_delay(100);


  command = LCD_GCP64;  // Init palette for 64 gradient palette 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr = (SYS_UWORD16 *)&INIT_GCP64[0];
  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 63, C_LCD_IF_DISPLAY);

  r2d_nop_delay(100);

  command = LCD_GCP16;  // Init palette for 16 gradient palette 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr = (SYS_UWORD16 *)&INIT_GCP16[0];
  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 8, C_LCD_IF_DISPLAY);


  command = LCD_MD_CSET;  // set area devoted to DSP interface 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr =  (SYS_UWORD16 *)&INIT_MD_CSET[0];
  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 2 , C_LCD_IF_DISPLAY);


  command = LCD_MD_PSET;  // set area devoted to DSP interface 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr =  (SYS_UWORD16 *)&INIT_MD_PSET[0];
  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 2, C_LCD_IF_DISPLAY);


  command = LCD_SD_CSET;  // set area devoted to MPU interface 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr =  (SYS_UWORD16 *)&INIT_SD_CSET[0];

  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 2, C_LCD_IF_DISPLAY);


  command = LCD_SD_PSET;  // set area devoted to MPU interface
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  ptr =  (SYS_UWORD16 *)&INIT_SD_PSET[0];

  f_lcd_if_poll_write(C_LCD_IF_CS0, ptr, 2, C_LCD_IF_DISPLAY);



  command = LCD_OSCISEL;  // internal OSG 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  data = INIT_OSCISEL; // 0x05 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);


  command = LCD_14MSET; 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  data = INIT_14MSET; // 0x4B 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);


  command = LCD_14MEND;  
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);


  command = LCD_3500KSET; 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  data = INIT_3500KSET; // 0x45 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);


  command = LCD_3500KEND;
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);


  r2d_nop_delay(30);


  command = LCD_SLPOUT; // this command cancels the sleep mode 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);


  r2d_nop_delay(20);


  command = LCD_VOLCTL;  // sets Ton timing of power IC 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  data = INIT_VOLCTL_Ton; // 152 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);


  r2d_nop_delay(20);


  command = LCD_VOLCTL;  // sets the electronic volume 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
  data = INIT_VOLCTL;
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(data), 1, C_LCD_IF_DISPLAY);


  r2d_nop_delay(20);

  
  command = LCD_DISON; 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  command = LCD_DISNOR; // this command turns the display mode to NORMAL 
                        // without rewriting the content of the display data RAM 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  command = LCD_RAMWR; 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);


  for (i=0; i<264; i++)
  {
    // Try filling with white color 
    tab_tmp[i] = 0xFFFF;
  }
  
  for(j=0; j<220; j++)
  {
	f_lcd_if_poll_write(C_LCD_IF_CS0, &(tab_tmp[0]), 264, C_LCD_IF_DISPLAY);
  }

#endif
}

void r2d_refresh_task_kill(void)
{
}


void r2d_dithering_init(void)
{
   R2D_MALLOC(r2d_mb_id,UINT32,sizeof(UINT32)*4,r2d_g_dithering_matrix);
   if (r2d_g_dithering_matrix!=NULL)
   {
     r2d_g_dithering_matrix[0]=0;
     r2d_g_dithering_matrix[1]=2;
     r2d_g_dithering_matrix[2]=3;
     r2d_g_dithering_matrix[3]=1;
   }
}
