#include "r2d/lcds/e_sample/r2d_tfd_lcd.h"
#include "rvm/rvm_use_id_list.h"
#include "r2d/lcds/e_sample/lcd_if.h"

UINT16 tab_temp[264+1];

void r2d_lcd_power_on(void)
{
}

void r2d_lcd_power_off(void)
{
}

void r2d_refresh(void)
{
  UINT16 i,j;

#ifndef _WINDOWS
  
  UINT32 v;
  UINT16 r,g,b; // Red, Green, Blue
  UINT16 ind;
  UINT16 command;
  UINT32  *p;



  p=r2d_g_framebuffer->p_memory_words;

#if (R2D_REFRESH == R2D_HORIZONTAL)
    rvf_send_trace("R2D REFRESH",strlen("R2D REFRESH"), NULL_PARAM, 
			   RV_TRACE_LEVEL_DEBUG_HIGH, R2D_USE_ID );

  command = LCD_DISNOR;
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);

  command = LCD_RAMWR; 
  f_lcd_if_poll_write(C_LCD_IF_CS0, &(command), 1, C_LCD_IF_INSTRUCTION);
    

 for(j=0;j<220;j++)
  {
	  ind=0;
	  for (i=0;i<88;i++) // 2 pixels managed in the loop 
	  {

            v= *p++;
			v=~v;

			r=(UINT16)(v&0x0000F800); // 5 bits 
			r=r>>8;

  			g=(UINT16)(v&0x000007E0); // 6 bits 
			g=g<<5;

			tab_temp[ind++]= (r|g);

			b=(UINT16)(v&0x0000001F); // 5 bits 
			b=b<<3;


			v=v>>16;

			r=(UINT16)(v&0x0000F800); // 5 bits 

			tab_temp[ind++]= (b | r);


  			g=(UINT16)(v&0x000007E0); // 6 bits 
			g=g>>3;

			b=(UINT16)(v&0x0000001F); // 5 bits 
			b=b<<11;

			tab_temp[ind++]= (b | g);

    }
	  p++;
      
	  f_lcd_if_poll_write(C_LCD_IF_CS0, &(tab_temp[0]), 264, C_LCD_IF_DISPLAY);
    } 

#endif
#endif
   

}