/******************************************************************************
 *                   WIRELESS COMMUNICATION SYSTEM DEVELOPMENT
 *
 *             (C) 2002 Texas Instruments France. All rights reserved
 *
 *                          Author : Philippe MARTINEZ
 *
 *
 *  Important Note
 *  --------------
 *
 *  This S/W is a preliminary version. It contains information on a product 
 *  under development and is issued for evaluation purposes only. Features 
 *  characteristics, data and other information are subject to change.
 *
 *  The S/W is furnished under Non Disclosure Agreement and may be used or
 *  copied only in accordance with the terms of the agreement. It is an offence
 *  to copy the software in any way except as specifically set out in the 
 *  agreement. No part of this document may be reproduced or transmitted in any
 *  form or by any means, electronic or mechanical, including photocopying and
 *  recording, for any purpose without the express written permission of Texas
 *  Instruments Inc.
 *
 ******************************************************************************
 *
 *  FILE NAME: lcd_if32.c
 *
 *
 *  PURPOSE:  LCD Interface driver compiled in 32-bits mode (ARM mode)
 *
 *
 *  FILE REFERENCES:
 *
 *  Name                  IO      Description
 *  -------------         --      ---------------------------------------------
 *  
 *
 *
 *  EXTERNAL VARIABLES:
 *
 *  Source:
 *
 *  Name                  Type              IO   Description
 *  -------------         ---------------   --   ------------------------------
 *
 *
 *
 *  EXTERNAL REFERENCES:
 *
 *  Name                Description
 *  ------------------  -------------------------------------------------------
 *
 *
 *
 *  ABNORMAL TERMINATION CONDITIONS, ERROR AND WARNING MESSAGES:
 *  
 *
 *
 *  ASSUMPTION, CONSTRAINTS, RESTRICTIONS:
 *  
 *
 *
 *  NOTES:
 *  
 *
 *
 *  REQUIREMENTS/FUNCTIONAL SPECIFICATION REFERENCES:
 *
 *
 *
 *
 *  DEVELOPMENT HISTORY:
 *
 *  Date         Name(s)           Version  Description
 *  -----------  --------------    -------  -------------------------------------
 *  30-Oct-2002  Philippe MARTINEZ  0.0.1    First implementation
 *
 *  ALGORITHM: 
 *
 *
 *****************************************************************************/

#include "r2d/lcds/e_sample/lcd_if.h"

  /****************************************************************************
   *                         GLOBAL VARIABLES REFERENCE
   ***************************************************************************/

   /* internal structure instance */

   extern T_LCD_IF_INTERNAL d_lcd_if_internal;

#if (CHIPSET == 12)

  /******************************************************************************
   *
   *  FUNCTION NAME: f_lcd_if_it_handler
   *
   *    LCD Interface Interrupt Handler.
   *
   *
   *  ARGUMENT LIST:
   *
   *  Argument       Type                   IO  Description
   *  ------------   -------------------    --  ---------------------------------
   *  None  		  
   *                                            
   * RETURN VALUE: None
   *
   *****************************************************************************/

   void f_lcd_if_it_handler( void )
   {

     E_LCD_IF_CALLBACK_RET d_status;
	 SYS_UWORD32           d_nb_words_in_loop = 0;
	 SYS_UWORD8            i                  = 0;


     /* check the d_interrupt_state value and the buffer */

     if( (d_lcd_if_internal.d_interrupt_state == C_LCD_IF_IT_BUFF) && 
         (d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.d_buffer_size != 0) )
	 {
           /* Copy up to C_LCD_IF_TX_FIFO_SIZE words into the TX FIFO. */

	   if( d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.d_buffer_size >= C_LCD_IF_TX_FIFO_SIZE)
	   {
	     d_nb_words_in_loop = C_LCD_IF_TX_FIFO_SIZE; 
           }
	   else
	   {
	     d_nb_words_in_loop = d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.d_buffer_size; 
	   } // End if

           for( i=0; i<d_nb_words_in_loop ;i++ )
           {
	     F_LCD_IF_WRITE_IN_FIFO( d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.p_buffer[i] );
           } // End for

           /* update d_nb_words_to copy and p_buffer */
           d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.d_buffer_size -=  d_nb_words_in_loop;
	   d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.p_buffer      +=  d_nb_words_in_loop;
       
	 }
	 else
	 {
           /* Call the callback function */
	   d_status = (*d_lcd_if_internal.d_cs_struct[d_lcd_if_internal.d_current_cs].d_tx.p_callback)();

           /* disable the LCD Interface TX FIFO if needed */
	   if( d_status == C_LCD_IF_CALLBACK_DISABLE_IT)
	   {
	     F_LCD_IF_DISABLE_TX_FIFO_EMPTY_IT;

	     /* set internal state to IDLE */
	     d_lcd_if_internal.d_interrupt_state = C_LCD_IF_IDLE;
	   } // End if

	 } // End if

   } /* f_lcd_if_it_handler */

#endif
