

static UINT32 r2d_lcd_copy_operator(UINT32 old,UINT32 value)
{
	return(value);
}

static UINT32 r2d_lcd_or_operator(UINT32 old,UINT32 value)
{
	if ((value&0x0000FFFF)==0)
		return(old);
	else
	    return(value);
}
static UINT32 r2d_lcd_and_operator(UINT32 old,UINT32 value)
{
	return(old & value);
}
static UINT32 r2d_lcd_xor_operator(UINT32 old,UINT32 value)
{
	return(old ^ value) ;
}
static UINT32 r2d_lcd_not_copy_operator(UINT32 old,UINT32 value)
{
	return(~value);
}
static UINT32 r2d_lcd_not_or_operator(UINT32 old,UINT32 value)
{
	return(~(old | value));
}
static UINT32 r2d_lcd_not_and_operator(UINT32 old,UINT32 value)
{
	return(~(old & value));
}
static UINT32 r2d_lcd_not_xor_operator(UINT32 old,UINT32 value)
{
	return(~(old ^ value)) ;
}
static UINT32 r2d_lcd_erase_operator(UINT32 old,UINT32 value)
{
	if ((value&0x0FFFF)==0xFFFF)
		return(0);
	else
	    return(old);
}

// This operator is meaningless when alpha mode not supported
UINT32 r2d_lcd_alpha_operator(UINT32 old,UINT32 value)
{
			   UINT16 a,rs,gs,bs,rd,gd,bd;
			   UINT32 big_a;

			   big_a=value;
			   big_a=big_a>>16;

			   a=big_a;

			   if (a)
			   {

			   value=(~value) & 0x0FFFFFF;
			   old=(~old) & 0x0FFFFFF;
			   
			   bs=(value&0x1F);
               value=value>>5;
               gs=(value&0x3F);
               value=value>>6;
               rs=(value&0x1F);

			   

			   bd=(old&0x1F);
               old=old>>5;
               gd=(old&0x3F);
               old=old>>6;
               rd=(old&0x1F);


			   
			   
			   // Pixel value has been complemented before being
			   // saved so that the white correspond to 0 and be
			   // compatible with formulas for other modes.
			   // But alpha value is not complemented
			   // So a=0xFF correspond tranparency
			   bd=((a)*bd+(0x100 - a)*bs) >> 8;
			   gd=((a)*gd+(0x100 - a)*gs) >> 8;
			   rd=((a)*rd+(0x100 - a)*rs) >> 8;

			   

			   old=(~((rd<<11)|(gd<<5)|bd)) & 0x000FFFF;
			   return(old);
			   }
			   else
				   return(value);
}
 

const T_R2D_DRAWING_OPERATORS r2d_g_lcd_operators=
{
   &r2d_lcd_copy_operator,
   &r2d_lcd_or_operator,
   &r2d_lcd_and_operator,
   &r2d_lcd_xor_operator,
   &r2d_lcd_not_copy_operator,
   &r2d_lcd_not_or_operator,
   &r2d_lcd_not_and_operator,
   &r2d_lcd_not_xor_operator,
   NULL,
   &r2d_lcd_erase_operator
};


// Return the pixel value to write on the LCD or the offscreen
// pixmap
// (Convert Riviera color to D-Sample RGB Format with complement)
void r2d_convert_foreground_color(T_R2D_GC *gc,UINT32 color)
{
	INT16 r,g,b;
	UINT32 a;

	gc->foreground_pixel_value=0;
    
	//a=(r2d_alpha(color)) << 16;
	//gc->foreground_pixel_value|=a;

	r=(r2d_red(color)&0xF8) >> 3;
	g=(r2d_green(color)&0xFC) >> 2;
	b=(r2d_blue(color)&0xF8) >> 3 ;

    gc->foreground_pixel_value|= (~((r<<11) | (g<<5) | b)) & 0x0FFFF;
     
}

// Return the pixel value to write on the LCD or the offscreen
// pixmap
// (Convert riviera color to D-Sample RGB format with complement)
void r2d_convert_background_color(T_R2D_GC *gc,UINT32 color)
{
    INT16 r,g,b;
	UINT32 a;

	gc->background_pixel_value=0;

	//a=(r2d_alpha(color)) << 16;
	//gc->background_pixel_value|=a;

	r=(r2d_red(color)&0xF8) >> 3 ;
	g=(r2d_green(color)&0xFC) >> 2 ;
	b=(r2d_blue(color)&0xF8) >> 3 ;

    gc->background_pixel_value|= (~((r<<11) | (g<<5) | b)) & 0x0FFFF;
}



// Convert a LCD value (not color) to a value
// to be written into the 24bpp framebuffer
// In general, the value written is a packed
// representation of the ARGB color
// but it may be different according to the framebuffer
// internal format
BOOLEAN r2d_lcd_foreground_pixel(UINT32 lcd_value,T_R2D_GC_PTR src_gc)
{
   if (lcd_value&0x0000FFFF)
     return(TRUE);
   else
     return(FALSE);
}

// Color framebuffer to D-Sample LCD
UINT32 r2d_color_to_lcd(UINT32 pixel_value,INT16 x,INT16 y)
{
  
  INT16 red,green,blue;
  UINT32 alpha;

  //alpha=pixel_value & 0xFF000000;
  //alpha=alpha>>8;

  pixel_value=(~pixel_value) & 0x00FFFFFF;
  red=r2d_red(pixel_value);
  green=r2d_green(pixel_value);
  blue=r2d_blue(pixel_value);

  red=(red&0xF8)>>3;
  green=(green&0xFC)>>2;
  blue=(blue&0xF8)>>3;
  
  //return(((~((red<<11) | (green << 5) | blue)) & 0x0000FFFF) | alpha);
  return(((~((red<<11) | (green << 5) | blue)) & 0x0000FFFF) );
}

// D-Sample LCD to color framebuffer
UINT32 r2d_lcd_to_color(UINT32 color)
{
    
  INT16 r,g,b;
  UINT32 alpha;

  //alpha=color & 0x00FF0000;
 // alpha=alpha<<8;

  color=~color;
  b=(color&0x1F)<<3;
  color=color>>5;
  g=(color&0x3F)<<2;
  color=color>>6;
  r=(color&0x1F)<<3;

 // return(((~((r<<16) + (g<<8)+b)) & 0x00FFFFFF) | alpha);
  return(((~((r<<16) + (g<<8)+b)) & 0x00FFFFFF) );
}


