/* Used by refresh task to extract bytes from the
framebuffer */

#include "r2d/lcds/d_sample/r2d_tfd_lcd.h"

#include "main/sys_types.h"
#include "l1_types.h"
#include "memif/mem.h"


#define R2D_MB_PRIM_SIZE	(4000)
 

const unsigned char INIT_DISCTL[11] = { 0xDE,0x01,0x64,0x00,0x1B,0xF4,0x00,0xDC,0x00,0x02,0x00};


const unsigned char INIT_GCP64[126] =  {
	0x3B, 0x0, 0x42, 0x0, 0x4A, 0x0, 0x51, 
	0x0, 0x58, 0x0, 0x5F, 0x0, 0x66, 0x0, 0x6E, 
	0x0, 0x75, 0x0, 0x7C, 0x0, 0x83, 0x0, 0x8A, 
	0x0, 0x92, 0x0, 0x99, 0x0, 0xA0, 0x0, 0xA7, 
	0x0, 0xAE, 0x0, 0xB6, 0x0, 0xBD, 0x0, 0xC4, 
	0x0, 0xCB, 0x0, 0xD2, 0x0, 0xDA, 0x0, 0xE1, 
	0x0, 0xE8, 0x0, 0xEF, 0x0, 0xF6, 0x0, 0xFE, 
	0x0, 0x5, 0x1, 0xC, 0x1, 0x13, 0x1, 0x1A, 
	0x1, 0x22, 0x1, 0x29, 0x1, 0x30, 0x1, 0x37, 
	0x1, 0x3E, 0x1, 0x46, 0x1, 0x4D, 0x1, 0x54, 
	0x1, 0x5B, 0x1, 0x62, 0x1, 0x6A, 0x1, 0x71, 
	0x1, 0x78, 0x1, 0x7F, 0x1, 0x86, 0x1, 0x8E, 
	0x1, 0x95, 0x1, 0x9C, 0x1, 0xA3, 0x1, 0xAA, 
	0x1, 0xB2, 0x1, 0xB9, 0x1, 0xC0, 0x1, 0xC7, 
	0x1, 0xCE, 0x1, 0xD6, 0x1, 0xDD, 0x1, 0xE4, 
	0x1, 0xEB, 0x1, 0xF2, 0x1, 0xFA, 0x1 };
const unsigned char INIT_GCP16[15] = {
	0x1A,0x31,0x48,0x54,0x5F,0x67,0x70,0x76,0x7C,0x80,0x83,0x84,0x85,0x87,0x96 };


#ifdef EPSOM_ARRAY
const unsigned char INIT_GCP64[126] = {
		0x08,0x00,0x2A,0x00,0x4E,0x00,0x6B,0x00,		0x88,0x00,0xA3,0x00,0xBA,0x00,0XD1,0x00,
		0XE2,0x00,0XF3,0x00,0X03,0x01,0X13,0x01,		0X22,0x01,0x2F,0x01,0X2B,0x01,0X46,0x01,
		0x51,0x01,0x5B,0x01,0x64,0x01,0x6C,0x01,		0x74,0x01,0x7C,0x01,0x83,0x01,0x8A,0x01,
		0x91,0x01,0x98,0x01,0x9F,0x01,0xA6,0x01,		0xAC,0x01,0XB2,0x01,0xB7,0x01,0xBC,0x01,
		0xC1,0x01,0xC6,0x01,0xCB,0x01,0xD0,0x01,		0xD4,0x01,0xD8,0x01,0xDC,0x01,0xE0,0x01,
		0xE4,0x01,0xE8,0x01,0xEC,0x01,0xF0,0x01,		0xF4,0x01,0xF8,0x01,0xFB,0x01,0xFE,0x01,
		0x01,0x02,0x03,0x02,0x05,0x02,0x07,0x02,		0x09,0x02,0x0B,0x02,0x0D,0x02,0x0F,0x02,
		0x11,0x02,0x13,0x02,0x15,0x02,0x17,0x02,		0x19,0x02,0x1B,0x02,0x1C,0x02 };
#endif

const unsigned char INIT_MD_PSET[4] = { 0x00, 0x01, 0x00, 0x01 };
const unsigned char INIT_MD_CSET[4] = { 0x00, 0x02, 0x00, 0x02 };

const unsigned char INIT_SD_PSET[4] = { 0, 0, 219, 0 };
const unsigned char INIT_SD_CSET[4] = { 2, 0, 177, 0 };

const unsigned char INIT_ASCSET[7] = { 0x00, 0x00, 0xDB, 0x00, 0xDC, 0x00, 0x01 };
const unsigned char INIT_SCSTART[2] = { 0x00, 0x00 };

static void r2d_nop_delay(UINT32 ms)
{
    unsigned short a;
    while (ms-- > 0) for (a=0;a<1000;a++) asm(" nop");
}

 void r2d_refresh_task_init(void)
{

#ifndef _WINDOWS

  UINT32  i;

  LCD_activate;

  LCD_cmd(LCD_DISOFF);
  LCD_cmd(LCD_SLPIN);
  LCD_cmd(LCD_DISNOR);
  LCD_cmd(LCD_GSSET);
  LCD_data(INIT_GSSET); // 64 gradients

  r2d_nop_delay(100);

	
	LCD_cmd(LCD_DISCTL);	 // Init LCD controller
	for (i=0; i<11; i++)	LCD_data(INIT_DISCTL[i]);

	LCD_cmd(LCD_GCP64); 	// Init palette for 64 gradient palette
	for (i=0; i<126; i++)  LCD_data(INIT_GCP64[i]);

	LCD_cmd(LCD_GCP16); 	// Init palette for 16 gradient palette

	for (i=0; i<15; i++)	LCD_data(INIT_GCP16[i]);

	LCD_cmd(LCD_MD_CSET);  // set area devoted to DSP interface
	for (i=0; i<4; i++)  LCD_data(INIT_MD_CSET[i]);

	LCD_cmd(LCD_MD_PSET);  // set area devoted to DSP interface

	for (i=0; i<4; i++)  LCD_data(INIT_MD_PSET[i]);

	LCD_cmd(LCD_SD_CSET);  // set area devoted to MPU interface
	for (i=0; i<4; i++)  LCD_data(INIT_SD_CSET[i]);

	LCD_cmd(LCD_SD_PSET);  // set area devoted to MPU interface
	for (i=0; i<4; i++)  LCD_data(INIT_SD_PSET[i]);

	LCD_cmd(LCD_DATCTL);
	LCD_data(INIT_DATCTL);//0x08);

	LCD_cmd(LCD_OSCISEL);
	LCD_data(INIT_OSCISEL);//0x05);

	LCD_cmd(LCD_14MSET);
	LCD_data(INIT_14MSET);//0x4B);

	LCD_cmd(LCD_14MEND);

	LCD_cmd(LCD_3500KSET);
	LCD_data(INIT_3500KSET);//0x45);

	LCD_cmd(LCD_3500KEND);

	r2d_nop_delay(30);

	LCD_cmd(LCD_SLPOUT);

	r2d_nop_delay(20);

	LCD_cmd(LCD_VOLCTL);
	LCD_data(INIT_VOLCTL_Ton);// 152);

	r2d_nop_delay(20);

	LCD_cmd(LCD_VOLCTL);
	LCD_data(INIT_VOLCTL);



	r2d_nop_delay(20);
	LCD_cmd(LCD_DISON);

	LCD_cmd(LCD_RAMWR);

	  for (i=0; i<176*220; i++)
	  {
		//LCD_data(pic_data[i]);
		LCD_data(0xFFFF);
		// Try filling with white color
	  }



	LCD_deactivate;

#endif
}

static void r2d_refresh_task_kill(void)
{
}

static void r2d_dithering_init(void)
{
   R2D_MALLOC(r2d_mb_id,UINT32,sizeof(UINT32)*4,r2d_g_dithering_matrix);
   if (r2d_g_dithering_matrix!=NULL)
   {
     r2d_g_dithering_matrix[0]=0;
     r2d_g_dithering_matrix[1]=2;
     r2d_g_dithering_matrix[2]=3;
     r2d_g_dithering_matrix[3]=1;
   }
}

void r2d_lcd_off(void)
{
	 
  LCD_cmd(LCD_DISOFF);
  //wait 70ms
  r2d_nop_delay(70);
  LCD_cmd(LCD_SLPIN);  
  //wait 110ms
  r2d_nop_delay(110);
}
