 


 
  
  .state32

  .sect ".r2dlcd"


 .include "r2d_asm_configs.inc"
 .include "r2d_asm_utils.inc"
 .include "r2d_asm_patch_utils.inc"


 .if (R2D_ASM = R2D_ON)


 .ref _r2d_lcd_alpha_operator
 .ref _r2d_lcd_foreground_pixel
 .ref _r2d_lcd_to_color
 .ref _r2d_color_to_lcd

 .def _r2d_ialpha_op
 .def _r2d_iforeground_pixel_test
 
 .def _r2d_icolor_to_lcd
 .def _r2d_ilcd_to_color
 

 .global _r2d_lcd_start_copy
 .global _r2d_lcd_start_or
 .global _r2d_lcd_start_and
 .global _r2d_lcd_start_xor
 .global _r2d_lcd_start_notcopy
 .global _r2d_lcd_start_notor
 .global _r2d_lcd_start_notand
 .global _r2d_lcd_start_notxor
 .global _r2d_lcd_start_alpha
 .global _r2d_lcd_start_erase
 .global _r2d_lcd_start_foreground_pixel
 .global _r2d_start_get_color
 .global _r2d_start_color_to_lcd
 .global _r2d_start_lcd_to_color

_r2d_lcd_start_copy:
      MOV calca,calca
      MOV calcb,calca
      MOV calcb,calcb
_r2d_lcd_end_copy

_r2d_lcd_start_or:
      MOVS calca,calca,LSL #16
      MOVNEQ calcb,calca,LSR #16
	  NOP
_r2d_lcd_end_or

_r2d_lcd_start_and:
      MOV calca,calca
      AND calcb,calcb,calca
      MOV calcb,calcb
_r2d_lcd_end_and

_r2d_lcd_start_xor:
      MOV calca,calca
      EOR calcb,calcb,calca
      MOV calcb,calcb
_r2d_lcd_end_xor

_r2d_lcd_start_notcopy:
      MOV calca,calca
      MVN calcb,calca
      MOV calcb,calcb
_r2d_lcd_end_notcopy

_r2d_lcd_start_notor:
      MOV calca,calca
      ORR calcb,calcb,calca
      MVN calcb,calcb
_r2d_lcd_end_notor

_r2d_lcd_start_notand:
      MOV calca,calca
      AND calcb,calcb,calca
      MVN calcb,calcb
_r2d_lcd_end_notand

_r2d_lcd_start_notxor:
      MOV calca,calca
      EOR calcb,calcb,calca
      MVN calcb,calcb
_r2d_lcd_end_notxor

_r2d_lcd_start_alpha
  ; Identifying code telling the patcher that a special
  ; construct required to branch to a C function is used
    .long BRANCH_ID
  ; The absolute address of the C function which is going to be
  ; converted to a PC relative offset by the patcher
    .long _r2d_ialpha_op
_r2d_lcd_stop_alpha

_r2d_lcd_start_erase:
	  MOVS calca,calca,LSL #16
      MOVNEQ calcb,#0
	  NOP
_r2d_lcd_end_erase

_r2d_lcd_start_foreground_pixel
  ; Identifying code telling the patcher that a special
  ; construct required to branch to a C function is used
    .long BRANCH_ID
  ; The absolute address of the C function which is going to be
  ; converted to a PC relative offset by the patcher
    .long _r2d_iforeground_pixel_test
_r2d_lcd_stop_foreground_pixel


_r2d_start_lcd_to_color
  ; Identifying code telling the patcher that a special
  ; construct required to branch to a C function is used
    .long BRANCH_ID
  ; The absolute address of the C function which is going to be
  ; converted to a PC relative offset by the patcher
    .long _r2d_ilcd_to_color
_r2d_stop_lcd_to_color

_r2d_start_color_to_lcd
  ; Identifying code telling the patcher that a special
  ; construct required to branch to a C function is used
    .long BRANCH_ID
  ; The absolute address of the C function which is going to be
  ; converted to a PC relative offset by the patcher
    .long _r2d_icolor_to_lcd
_r2d_stop_color_to_lcd



  ; Stub function allowing to branch to a C one whose interface
  ; is UINT32 r2d_lcd_some_operator(UINT32 old,UINT32 value)
_r2d_ialpha_op:
    R2D_OP_SAVE_CONTEXT
    BL _r2d_lcd_alpha_operator
    R2D_OP_RESTORE_CONTEXT

  ; Check kind of pixel
_r2d_iforeground_pixel_test:
    R2D_COL_SAVE_CONTEXT
    BL _r2d_lcd_foreground_pixel
    R2D_COL_RESTORE_CONTEXT

  ; All color conversion subroutines
_r2d_icolor_to_lcd:
    R2D_COLCONV_SAVE_CONTEXT
    BL _r2d_color_to_lcd
    R2D_COLCONV_RESTORE_CONTEXT

_r2d_ilcd_to_color:
    R2D_COLCONV_SAVE_CONTEXT
    BL _r2d_lcd_to_color
    R2D_COLCONV_RESTORE_CONTEXT

 .endif
 .end
