
#ifndef _WINDOWS
	#include "r2d/uwire.h"
#endif



//value to transmit in order to set the x position on the lcd
static const char x_position[DISP_PIXELWIDTH] ={0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
				  		0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
				  		0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
				  		0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,						  
				  		0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
				  		0xd0,0xd1,0xd2,0xd3};

//value to transmit in order to set the y position on the lcd
static const char y_position[DISP_PAGEHEIGHT] ={0x40,0x41,0x42,0x43,0x44,0x45};


UINT32 r2d_p_refresh_buffer[4*R2D_WIDTH*R2D_MWHEIGHT];


#if (R2D_BENCHMARKING == R2D_ON)
    UINT32 r2d_g_tick=0;
#endif

	
#ifndef _WINDOWS
void r2d_int_set_DC_low(void)
{
	* (volatile UINT16 *) GPIO_OUT &= ~(0x02); //gpio(1) ->0
}

/********************************************************************/
/*	set the DC input to high for data transmission	 				*/
/*																	*/
/********************************************************************/
void r2d_int_set_DC_high(void)
{
	* (volatile UINT16 *) GPIO_OUT |= 0x02; //gpio(1) ->1
}


static void r2d_int_lcd_transmit_cmd(UINT8 cmd)
{
	r2d_int_set_DC_low();
	* (volatile UINT16 *) TDR = cmd <<8;
	* (volatile UINT16 *) CSR |= NB_BITS_WR_8 + CS_CMD + START ; // transmit command data
	while (((* (volatile UINT16 *) CSR) & CSRB) != 0 ); // wait for end of WRITE
	* (volatile UINT16 *) CSR &= ~CS_CMD; // clears Chip Select 	
}

static BOOLEAN r2d_int_lcd_polling(void)
{
	if (((* (volatile UINT16 *) CSR) & CSRB) == 0 )
	{
	    * (volatile UINT16 *) CSR &= ~CS_CMD; // clears Chip Select 
		return(TRUE);
	}
	else 
		return(FALSE);
}



#endif

void r2d_lcd_power_on(void)
{
}

void r2d_lcd_power_off(void)
{
}


void r2d_refresh(void)
{
	UINT16 i,j;

    UINT32 v;

	UINT32 *buffer_end,*buffer_write;
	UINT32 *p,*writing;
	INT32 *buffer_read;
	UINT16 byte;

#if (R2D_BENCHMARKING == R2D_ON)
    
	UINT32 time,k;

	if (!r2d_g_tick)
	{
		time=rvf_get_tick_count();
		
	}

	
	for(k=0;k<R2D_REFRESH_LOOP;k++)
	{
#endif
#ifndef _WINDOWS
	r2d_int_lcd_transmit_cmd(x_position[0]);// set X to 0
	r2d_int_lcd_transmit_cmd(y_position[0]);// set Y to 0
#else
	lcd_transmit_cmd(x_position[0]);// set X to 0
	lcd_transmit_cmd(y_position[0]);// set Y to 0
#endif    	
    //rvf_send_trace("R2D REFRESH",strlen("R2D REFRESH"), NULL_PARAM, 
	//		   RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_XXX );

	p=r2d_g_framebuffer->p_memory_words;

	// First word out of refresh buffer
	buffer_end=r2d_p_refresh_buffer+(R2D_HEIGHT>>3)*R2D_WIDTH;
	buffer_read=(INT32*)r2d_p_refresh_buffer;
	buffer_write=r2d_p_refresh_buffer;
    writing=buffer_write-R2D_WIDTH;
	
    
	i=0;
	while(i<R2D_WIDTH)
	{
	  j=0;
	  while(j<R2D_MWHEIGHT)
	  {
            // If can read a new word from framebuffer
		    // and write it to refresh buffer
		    //if (r2d_p_refresh_state[i]+4<=R2D_MWHEIGHT*4)
			{
                //r2d_p_refresh_state[i]+=4;
			    v=*p++;
			    j++;

				writing+=R2D_WIDTH;
			    *writing = (v & 0xFF) | 0x80000000;

			    v=v>>8;
			    writing+=R2D_WIDTH;
			    *writing = (v & 0xFF) | 0x80000000;

			    v=v>>8;
			    writing+=R2D_WIDTH;
			    *writing = (v & 0xFF) | 0x80000000;

			    v=v>>8;
			    writing+=R2D_WIDTH;
			    *writing = (v & 0xFF) | 0x80000000;

			

			    
            }

#ifndef _WINDOWS
			if ((r2d_int_lcd_polling()) && (buffer_read != (INT32*)buffer_end))
#else
			// If polling finished
			if ((lcd_polling()) && (buffer_read != (INT32*)buffer_end))
#endif
			{
				// If new data is available
				// to be sent to LCD
				if (*buffer_read<0)
				{
#ifndef _WINDOWS
				   * (volatile UINT16 *) GPIO_OUT |= 0x02; //gpio(1) ->1
                   * (volatile  UINT16 *) TDR = *buffer_read <<8;
	               * (volatile UINT16 *) CSR |= NB_BITS_WR_8 + CS_CMD + START ; // transmit data		
#else
				  lcd_transmit_data(*buffer_read);
#endif

				  *buffer_read++=0;
				  
				}
			}

		    
            
      }
	  i++;
	  writing=(++buffer_write) - R2D_WIDTH;;
    } 
   // Finish sending datas to LCD
   while(buffer_read!=(INT32*)buffer_end)
   {
#ifndef _WINDOWS
	   if (r2d_int_lcd_polling())
#else
	   if (lcd_polling())
#endif
			{
				// If new data is available
				// to be sent to LCD
				if (*buffer_read<0)
				{
				  
#ifndef _WINDOWS
				   * (volatile UINT16 *) GPIO_OUT |= 0x02; //gpio(1) ->1
                   * (volatile  UINT16 *) TDR = *buffer_read <<8;
	               * (volatile UINT16 *) CSR |= NB_BITS_WR_8 + CS_CMD + START ; // transmit data
#else
				  lcd_transmit_data(*buffer_read);
#endif
				  *buffer_read++=0;
				  
				  
				}
			}
   }
   
#if (R2D_BENCHMARKING == R2D_ON)
	} // End benchmarking
#endif

	r2d_reinit_update_region();

#ifdef _WINDOWS
	lcd_refresh();
#endif

#if (R2D_BENCHMARKING == R2D_ON)
	if (r2d_g_tick==0)
	{
		time=rvf_get_tick_count()-time;
        r2d_g_tick=1;
		rvf_send_trace("R2D : Nb refreshs",17,R2D_REFRESH_LOOP, 
				   RV_TRACE_LEVEL_ERROR, TRACE_R2D );
		rvf_send_trace("R2D : Ms=",9,time*10, 
				   RV_TRACE_LEVEL_ERROR, TRACE_R2D );
    }
#endif
}



